<?php

declare( strict_types=1 );

namespace woocommerce_kafka_integration\includes;

use WC_Order_Query;

class Class_Woocommerce_Kafka_Historical {

	public static function sendHistoricalData() {
		if ( ! current_user_can( 'manage_woocommerce' ) ) {
			echo json_encode( [
				'success' => false,
			] );
			die;
		}
		try {
			$limit  = 10;
			$offset = 0;

			$orders = self::getOrders( $limit, $offset );

			$count = count( $orders );

			$connector = \woocommerce_kafka_integration\includes\connectors\Class_Woocommerce_Kafka_Connector::getInstance();
			$topic     = new \woocommerce_kafka_integration\includes\topics\Class_Woocommerce_Kafka_Order_Created_Topic( $connector );

			while ( count( $orders ) > 0 ) {
				foreach ( $orders as $order ) {
					if (!$order instanceof \WC_Order) {
						continue;
					}

					$topic->send( $order->get_id(), $order );
				}

				$offset += $limit;

				$orders = self::getOrders( $limit, $offset );

				$count += count( $orders );
			}

			echo json_encode( [
				'count'   => $count,
				'success' => true
			] );

			die;
		} catch ( \Exception $exception ) {
			echo $exception->getMessage();
			die;
		}
	}

	private static function getOrders( $limit = 1, $offset = 0 ) {
		$query = new WC_Order_Query( [
			'limit'  => $limit,
			'offset' => $offset,
			'type'   => 'shop_order',
			'date_created' => '2024-10-01...2025-04-31'
		] );

		try {
			return $query->get_orders();
		} catch ( \Exception $exception ) {
			echo $exception->getMessage();
			die;
		}
	}

}