<?php

declare( strict_types=1 );

namespace Affilyads\WoocommerceKafkaIntegration\Includes;

use WC_Order_Query;

class ClassWoocommerceKafkaHistorical {

    /**
     * @throws \Exception
     */
    public static function sendHistoricalData( string $startDate, string $endDate ): int {
        $connector = connectors\ClassWoocommerceKafkaConnector::getInstance();

        if ( ! $connector->isCheckedDependencies() ) {
            throw new \Exception( 'Some dependencies error! Please check debug.log' );
        }

        $topic  = new topics\ClassWoocommerceKafkaOrderUpdatedTopic( $connector );
        $limit  = 100;
        $page   = 1;
        $sent   = 0;

        do {
            $query = new \WC_Order_Query( [
                'limit'        => $limit,
                'page'         => $page++,
                'type'         => 'shop_order',
                'return'       => 'ids',
                'date_created' => "{$startDate}...{$endDate}",
            ] );

            $orders = $query->get_orders();
            foreach ( $orders as $order_id ) {
                $topic->send( $order_id, true );
                ++$sent;
            }

            wp_cache_flush();
            gc_collect_cycles();
        } while ( ! empty( $orders ) );

        return $sent;
    }

    /**
     * @throws \Exception
     */
    private static function getOrders(string $startDate, string $endDate, int $limit = 1, int $offset = 0 ): object|array
    {
		$query = new WC_Order_Query( [
			'limit'  => $limit,
			'offset' => $offset,
			'type'   => 'shop_order',
            'return'       => 'ids',
			'date_created' => "$startDate...$endDate"
		] );

        return $query->get_orders();
	}

}