<?php
/*
Plugin Name: WooCommerce Affiliate CID
Description: Render CID in WooCommerce admin area.
Version: 1.0
Author: Dmitriy Polisadov
*/

if (!defined('ABSPATH')) {
    exit;
}

function display_affiliate_cid_in_admin_order($order) {
    $url = $order->get_meta('_wc_order_attribution_session_entry');
    $parsedUrl = parse_url($url);

    if (isset($parsedUrl['query'])) {
        parse_str($parsedUrl['query'], $queryParams);
        $cid = $queryParams['cid'] ?? null;

        if (!empty($cid)) {
            echo '<div class="order_data_column">';
            echo '<h4>' . __('Affiliate CID', 'woocommerce-affiliate-cid') . '</h4>';
            echo '<p><strong>' . esc_html($cid) . '</strong></p>';
            echo '</div>';
        }
    }
}
add_action('woocommerce_admin_order_data_after_order_details', 'display_affiliate_cid_in_admin_order', 10, 1);
