<?php

namespace Fitsmart\PaypalParcels\ExternalService\PayPal;

use Fitsmart\PaypalParcels\Config;
use Fitsmart\PaypalParcels\Contract\OrderCheckerInterface;

class PaypalOrderChecker implements OrderCheckerInterface
{
    public function checkOrder($order): bool
    {
        if (!($order instanceof \WC_Order)) {
            throw new \RuntimeException('The Order is not instance of WC_Order class');
        }

        $configPart = Config::getConfigPart('paypal');
        $methods = $configPart['methods'] ?? [];

        if (!in_array($order->get_payment_method(), $methods)) {
            return false;
        }

        if (empty($order->get_transaction_id())) {
            return false;
        }

        return true;

    }

}
