<?php

namespace Fitsmart\PaypalParcels;

final class Config
{
    public static function getEnv(string $key, mixed $default = false): mixed
    {
        if (defined($key)) {
            return constant($key);
        }

        $value = getenv($key) ?: ($_ENV[$key] ?? '');

        if ($value === '') {
            return $default;
        }

        if (is_string($value)) {
            $lower = strtolower($value);
            if (in_array($lower, ['true', '1', 'yes'], true)) {
                return true;
            }
            if (in_array($lower, ['false', '0', 'no'], true)) {
                return false;
            }
        }

        return $value;
    }

    public static function getConfigPart(string $part): array
    {
        $configPath = dirname(__DIR__) . '/config/config.php';

        if (!is_readable($configPath)) {
            return [];
        }

        $config = include $configPath;

        return $config[$part] ?? [];
    }
}
