<?php

namespace Fitsmart\PaypalParcels\Application;

use Fitsmart\PaypalParcels\Contract\ApiClientInterface;
use Fitsmart\PaypalParcels\Contract\OrderCheckerInterface;
use Fitsmart\PaypalParcels\Contract\RequestDataPreparerInterface;
use Fitsmart\PaypalParcels\Contract\TrackingHandlerInterface;
use Psr\Log\LoggerInterface;

abstract class AbstractTrackingHandler implements TrackingHandlerInterface
{
    public function __construct(
        protected LoggerInterface $logger,
        protected OrderCheckerInterface $orderChecker,
        protected RequestDataPreparerInterface $dataPreparer,
        protected ApiClientInterface $apiClient
    ) {
    }

    public function process(int $noteId, \WC_Order $order): void
    {
        try {
            if (!$this->orderChecker->checkOrder($order)) {
                return;
            }

            $payload = $this->dataPreparer->preparePayload($noteId, $order);
            if (empty($payload)) {
                return;
            }

            $this->apiClient->createTracking($payload);

        } catch (\Throwable $exception) {
            $this->logger->warning('Error! ' . $exception->getMessage());
        }
    }
}
