<?php

return [
    'parse_data' => [
        // Huboo with keys as courier acronym
        [
            'tracking_number_pattern' => '~Tracking:\s*([A-Z0-9]+).*deutschepost\.com~i',
            'tracking_url_pattern' => '~Url:\s*(https?://[^\s]+)~i',
            'paypal_carrier' => 'DEUTSCHE_DE',
            'parcelpanel_carrier' => 'deutsche-post',
        ],

        [
            'tracking_number_pattern' => '~Tracking:\s*([A-Z0-9]+).*evri\.com~i',
            'tracking_url_pattern' => '~Url:\s*(https?://[^\s]+)~i',
            'paypal_carrier' => 'HERMESWORLD_UK',
            'parcelpanel_carrier' => 'hermes-uk',
        ],

        [
            'tracking_number_pattern' => '~Tracking:\s*([A-Z0-9]+).*royalmail\.com~i',
            'tracking_url_pattern' => '~Url:\s*(https?://[^\s]+)~i',
            'paypal_carrier' => 'ROYAL_MAIL',
            'parcelpanel_carrier' => 'royal-mail',
        ],

        [
            'tracking_number_pattern' => '~Tracking:\s*([A-Z0-9]+).*postnl\.nl~i',
            'tracking_url_pattern' => '~Url:\s*(https?://[^\s]+)~i',
            'paypal_carrier' => 'POSTNL_INTERNATIONAL',
            'parcelpanel_carrier' => 'postnl-parcels',
        ],

        [
            'tracking_number_pattern' => '~Tracking:\s*([A-Z0-9]+).*fedex\.com~i',
            'tracking_url_pattern' => '~Url:\s*(https?://[^\s]+)~i',
            'paypal_carrier' => 'FEDEX_FR',
            'parcelpanel_carrier' => 'fedex',
        ],

        [
            'tracking_number_pattern' => '~Tracking:\s*([A-Z0-9]+).*dpd\.de~i',
            'tracking_url_pattern' => '~Url:\s*(https?://[^\s]+)~i',
            'paypal_carrier' => 'DPD',
            'parcelpanel_carrier' => 'dpd-de',
        ],

        [
            'tracking_number_pattern' => '~Tracking:\s*([A-Z0-9]+).*gls-group\.eu~i',
            'tracking_url_pattern' => '~Url:\s*(https?://[^\s]+)~i',
            'paypal_carrier' => 'GLS',
            'parcelpanel_carrier' => 'gls',
        ],

        // Universal for Huboo, without courier
        [
            'tracking_number_pattern' => '~Tracking:\s*([A-Z0-9]+)\s*Url~i',
            'tracking_url_pattern' => '~Url:\s*(https?://[^\s]+)~i',
            'paypal_carrier' => 'OTHER',
            'parcelpanel_carrier' => '', // not passed to parcelpanel, it determines carrier automatically in case of Universal case
            'paypal_carrier_name_other' => 'Other',
        ],

        // ShipBob
        [
            'tracking_number_pattern' => '~\([^)]+mailingtechnology\.com[^)]+tn=([A-Z0-9]+)[^)]*\)~',
            'tracking_url_pattern' => '~\((https?://[^\)]+)\)~i',
            'paypal_carrier' => 'OTHER',
            'paypal_carrier_name_other' => 'Spring Tracked',
            'parcelpanel_carrier' => 'mailing-technology',
        ],
        [
            'tracking_number_pattern' => '~\([^)]+ups\.com[^)]+trackNums=([A-Z0-9]+)[^)]*\)~',
            'tracking_url_pattern' => '~\((https?://[^\)]+)\)~i',
            'paypal_carrier' => 'UPS',
            'parcelpanel_carrier' => 'ups',
        ],
        [
            'tracking_number_pattern' => '~\([^)]+deutschepost\.com[^)]+barcode=([A-Z0-9]+)[^)]*\)~',
            'tracking_url_pattern' => '~\((https?://[^\)]+)\)~i',
            'paypal_carrier' => 'DEUTSCHE_DE',
            'parcelpanel_carrier' => 'deutsche-post',
        ],
        [
            'tracking_number_pattern' => '~\([^)]+royalmail\.com[^)]+trackNumber=([A-Za-z0-9_-]+)[^)]*\)~i',
            'tracking_url_pattern' => '~\((https?://[^\)]+)\)~i',
            'paypal_carrier' => 'ROYAL_MAIL',
            'parcelpanel_carrier' => 'royal-mail',
        ],
    ],

    'paypal' => [
        // TODO: use prod/staging env
        'base_uri' => 'https://api-m.paypal.com',
        'oauth_uri' => 'https://api.paypal.com',
        'methods' => ['nuxt_express_paypal', 'nuxt_paypal'],
        'status' => 'SHIPPED',
        'other_carrier' => 'OTHER'
    ],

    'parcelpanel' => [
        'base_uri' => 'https://wp-api.parcelpanel.com/api/v1/',
    ],

];
