<?php

namespace Fitsmart\PaypalParcels;

use Fitsmart\PaypalParcels\Application\TrackingHandlerFactory;
use Fitsmart\PaypalParcels\Contract\TrackingHandlerInterface;
use Fitsmart\PaypalParcels\Enum\ExternalServiceEnum;


class Plugin
{
    const LOG_FILE_NAME = 'paypal_parcels_registration.log';

    public function __construct(
       readonly TrackingHandlerInterface $trackingHandler
    ) {
    }

    public static function bootstrap(): void
    {
        $externalServiceFromConfig = Config::getEnv('PP_EXTERNAL_SERVICE');

        $externalServiceEnum = ExternalServiceEnum::tryFrom($externalServiceFromConfig) ?? ExternalServiceEnum::PAYPAL;

        $handler = TrackingHandlerFactory::make($externalServiceEnum->value);

        $plugin = new self($handler);

        $plugin->register_hooks();
    }

    public function register_hooks(): void
    {
        add_action('woocommerce_order_note_added', [$this, 'run_tracking_handler'], 10, 2);
    }


    public function run_tracking_handler(int $noteId, \WC_Order $order): void
    {
        $this->trackingHandler->process($noteId, $order);
    }


}