<?php

namespace Fitsmart\PaypalParcels\Application;

use Fitsmart\PaypalParcels\Enum\ExternalServiceEnum;
use Fitsmart\PaypalParcels\ExternalService\ParcelPanel\ParcelpanelApiClient;
use Fitsmart\PaypalParcels\ExternalService\ParcelPanel\ParcelpanelOrderChecker;
use Fitsmart\PaypalParcels\ExternalService\ParcelPanel\ParcelpanelRequestDataPreparer;
use Fitsmart\PaypalParcels\ExternalService\ParcelPanel\ParcelpanelTrackingHandler;
use Fitsmart\PaypalParcels\ExternalService\PayPal\PaypalApiClient;
use Fitsmart\PaypalParcels\ExternalService\PayPal\PaypalOrderChecker;
use Fitsmart\PaypalParcels\ExternalService\PayPal\PaypalTrackingHandler;
use Fitsmart\PaypalParcels\ExternalService\PayPal\PaypalRequestDataPreparer;
use Monolog\Handler\StreamHandler;
use Monolog\Logger;

final class TrackingHandlerFactory
{
    public static function make(string $externalService): ?AbstractTrackingHandler
    {
        $upload_dir = wp_upload_dir()['basedir'];
        $log_file = trailingslashit($upload_dir) . 'parcels_registration.log';

        $logger = new Logger($externalService);
        $logger->pushHandler(new StreamHandler($log_file, Logger::INFO));

        return match ($externalService) {
            ExternalServiceEnum::PAYPAL->value => new PaypalTrackingHandler(
                $logger,
                new PaypalOrderChecker(),
                new PaypalRequestDataPreparer(),
                new PaypalApiClient($logger)
            ),
            ExternalServiceEnum::PARCELPANEL->value => new ParcelpanelTrackingHandler(
                $logger,
                new ParcelpanelOrderChecker(),
                new ParcelpanelRequestDataPreparer(),
                new ParcelpanelApiClient($logger)
            ),
            default => null,
        };
    }

}
