<?php

namespace Fitsmart\PaypalParcels\ExternalService\PayPal;

use Fitsmart\PaypalParcels\Config;
use Fitsmart\PaypalParcels\Contract\RequestDataPreparerInterface;
use Fitsmart\PaypalParcels\ExternalService\TrackingNoteParser;

class PaypalRequestDataPreparer implements RequestDataPreparerInterface
{
    public function prepareData(int $noteId, \WC_Order $order): array
    {
        $transactionId = $order->get_transaction_id();

        $noteStd = wc_get_order_note($noteId);
        if (!$noteStd instanceof \stdClass) {
            throw new \RuntimeException('No note object received');
        }

        $parser = new TrackingNoteParser();

        $trackingData = $parser->parse($noteStd->content,  Config::getConfigPart('parse_data') ?? []);
        if (!$trackingData) {
            return [];
        }

        $trackingData['transaction_id'] = $transactionId;
        $trackingData['status'] = Config::getConfigPart('paypal')['status'] ?? '';

        return $trackingData;
    }
}