<?php

namespace Fitsmart\PaypalParcels\ExternalService\ParcelPanel;

use Fitsmart\PaypalParcels\Config;
use Fitsmart\PaypalParcels\Contract\ApiClientInterface;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;
use Monolog\Logger;

class ParcelpanelApiClient implements ApiClientInterface
{
    private Client $client;
    private Logger $logger;

    public function __construct(Logger $logger)
    {
        $this->logger = $logger;
        $this->client = new Client([
            'base_uri' => 'https://wp-api.parcelpanel.com/api/v1/',
            'headers' => [
                'Content-Type' => 'application/json',
                'PP-Api-Key' => Config::getEnv('PP_PARCELPANEL_API_KEY', ''),
            ]
        ]);
    }

    public function create_tracking(int $order_id, array $tracking_data): bool
    {
        $payload = [
            'shipments' => [[
                'order_id' => $order_id,
                'tracking_number' => $tracking_data['tracking_number'] ?? '',
                //'courier_code' => $tracking_data['courier_code'] ?? '',
            ]]
        ];

        try {
            $response = $this->client->post('tracking/create', [
                'json' => $payload,
            ]);

            $status = $response->getStatusCode();

            if ($status >= 200 && $status < 300) {
                $this->logger->info('Tracking sent', [
                    'order_id' => $order_id,
                    'payload' => $payload,
                ]);
                return true;
            }

            $this->logger->error('ParcelPanel error response', [
                'status' => $status,
                'body' => $response->getBody()->getContents(),
            ]);
        } catch (GuzzleException $e) {
            $this->logger->error('ParcelPanel request failed', [
                'message' => $e->getMessage(),
                'order_id' => $order_id,
            ]);
        }

        return false;
    }
}
