<?php

namespace Fitsmart\PaypalParcels\Application;


use Fitsmart\PaypalParcels\Contract\ApiClientInterface;
use Fitsmart\PaypalParcels\Contract\OrderCheckerInterface;
use Fitsmart\PaypalParcels\Contract\RequestDataPreparerInterface;
use Fitsmart\PaypalParcels\Contract\TrackingHandlerInterface;
use Psr\Log\LoggerInterface;

abstract class AbstractTrackingHandler implements TrackingHandlerInterface
{
    public function __construct(
        protected LoggerInterface $logger,
        protected OrderCheckerInterface $orderChecker,
        protected RequestDataPreparerInterface $dataPreparer,
        protected ApiClientInterface $apiClient
    ) {
    }

    public function process(int $noteId, \WC_Order $order): void
    {
        try {
            if (!$this->orderChecker->checkOrder($order)) {
                $this->logger->warning('Checking of order failed');
                return;
            }

            $requestData = $this->dataPreparer->prepareData($noteId, $order);

            if (empty($requestData)) {
                return;
            }
            $this->logger->info('Data to request ', $requestData);
            $this->apiClient->create_tracking($order->get_id(), $requestData);

        } catch (\Throwable $exception) {
            $this->logger->warning('Error! ' . $exception->getMessage());
        }
    }
}
