<?php

namespace Fitsmart\PaypalParcels;

class ConfigHelper
{
    private static array $config;

    private static function loadConfig(): void {
        if (!isset(self::$config)) {
            self::$config = require dirname(__DIR__) . '/config/config.php';
        }
    }

    public static function getPayPalBaseUri(): string {
        self::loadConfig();
        return self::$config['paypal']['base_uri'];
    }
    public static function getPayPalOauthUri(): string {
        self::loadConfig();
        return self::$config['paypal']['oauth_uri'];
    }
    public static function getPayPalStatus(): string {
        self::loadConfig();
        return self::$config['paypal']['status'];
    }
    public static function getPayPalMethods(): array
    {
        self::loadConfig();
        return self::$config['paypal']['methods'];
    }
    public static function getPayPalOtherCarrier(): string
    {
        self::loadConfig();
        return self::$config['paypal']['other_carrier'];
    }

    public static function getParseData(): array
    {
        self::loadConfig();
        return self::$config['parse_data'];
    }

}
