<?php

return [
    'parse_data' => [
        // Huboo with keys as courier acronym
        [
            'tracking_number_pattern' => '~Tracking:\s*([A-Z0-9]+).*deutschepost\.com~i',
            'carrier' => 'DEUTSCHE_DE',
            'tracking_url_pattern' => '~Url:\s*(https?://[^\s]+)~i',
        ],

        [
            'tracking_number_pattern' => '~Tracking:\s*([A-Z0-9]+).*evri\.com~i',
            'carrier' => 'HERMESWORLD_UK',
            'tracking_url_pattern' => '~Url:\s*(https?://[^\s]+)~i',
        ],

        [
            'tracking_number_pattern' => '~Tracking:\s*([A-Z0-9]+).*royalmail\.com~i',
            'carrier' => 'ROYAL_MAIL',
            'tracking_url_pattern' => '~Url:\s*(https?://[^\s]+)~i',
        ],

        [
            'tracking_number_pattern' => '~Tracking:\s*([A-Z0-9]+).*postnl\.nl~i',
            'carrier' => 'POSTNL_INTERNATIONAL',
            'tracking_url_pattern' => '~Url:\s*(https?://[^\s]+)~i',
        ],

        [
            'tracking_number_pattern' => '~Tracking:\s*([A-Z0-9]+).*fedex\.com~i',
            'carrier' => 'FEDEX_FR',
            'tracking_url_pattern' => '~Url:\s*(https?://[^\s]+)~i',
        ],

        [
            'tracking_number_pattern' => '~Tracking:\s*([A-Z0-9]+).*dpd\.de~i',
            'carrier' => 'DPD',
            'tracking_url_pattern' => '~Url:\s*(https?://[^\s]+)~i',
        ],

        [
            'tracking_number_pattern' => '~Tracking:\s*([A-Z0-9]+).*gls-group\.eu~i',
            'carrier' => 'GLS',
            'tracking_url_pattern' => '~Url:\s*(https?://[^\s]+)~i',
        ],

        // Universal for Huboo, without courier
        [
            'tracking_number_pattern' => '~Tracking:\s*([A-Z0-9]+)\s*Url~i',
            'carrier' => 'OTHER',
            'carrier_name_other' => 'Other',
            'tracking_url_pattern' => '~Url:\s*(https?://[^\s]+)~i',
        ],

        // ShipBob
        [
            'tracking_number_pattern' => '~\([^)]+mailingtechnology\.com[^)]+tn=([A-Z0-9]+)[^)]*\)~',
            'carrier' => 'OTHER',
            'carrier_name_other' => 'Spring Tracked',
            'tracking_url_pattern' => '~\((https?://[^\)]+)\)~i',
        ],
        [
            'tracking_number_pattern' => '~\([^)]+ups\.com[^)]+trackNums=([A-Z0-9]+)[^)]*\)~',
            'carrier' => 'UPS',
            'tracking_url_pattern' => '~\((https?://[^\)]+)\)~i',
        ],
    ],

    'paypal' => [
        'base_uri' => 'https://api-m.sandbox.paypal.com',
        'oauth_uri' => 'https://api.sandbox.paypal.com',
        'methods' => ['nuxt_express_paypal', 'nuxt_paypal'],
        'status' => 'SHIPPED',
        'other_carrier' => 'OTHER'
    ],

];