<?php

namespace Fitsmart\PaypalParcels\ExternalService\ParcelPanel;

use Fitsmart\PaypalParcels\Config;
use Fitsmart\PaypalParcels\Contract\RequestDataPreparerInterface;
use Fitsmart\PaypalParcels\ExternalService\TrackingNoteParser;

class ParcelpanelRequestDataPreparer implements RequestDataPreparerInterface
{
    public function prepareData(int $noteId, \WC_Order $order): array
    {
        $noteStd = wc_get_order_note($noteId);
        if (!$noteStd instanceof \stdClass) {
            throw new \RuntimeException('No note object received');
        }

        $parser = new TrackingNoteParser();

        $trackingData = $parser->parse($noteStd->content,  Config::getConfigPart('parse_data') ?? []);

        return $trackingData ?: [];
    }
}