<?php
/**
 * Management API
 *
 * The version of the OpenAPI document: 3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Adyen\Service\Management;

use Adyen\AdyenException;
use Adyen\Client;
use Adyen\Service;
use Adyen\Model\Management\ObjectSerializer;

class APICredentialsMerchantLevelApi extends Service
{
    /**
     * @var array|string|string[]
     */
    private $baseURL;

    /**
     * APICredentialsMerchantLevelApi constructor.
     *
     * @param \Adyen\Client $client
     * @throws AdyenException
     */
    public function __construct(Client $client)
    {
        parent::__construct($client);

        // Create the baseUrl based on live/test and optional live-url-prefix
        $this->baseURL = $this->createBaseUrl("https://management-test.adyen.com/v3");
    }

    /**
    * Create an API credential
    *
    * @param string $merchantId
    * @param \Adyen\Model\Management\CreateMerchantApiCredentialRequest $createMerchantApiCredentialRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Management\CreateApiCredentialResponse
    * @throws AdyenException
    */
    public function createApiCredential(string $merchantId, \Adyen\Model\Management\CreateMerchantApiCredentialRequest $createMerchantApiCredentialRequest, array $requestOptions = null): \Adyen\Model\Management\CreateApiCredentialResponse
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}'], [$merchantId], "/merchants/{merchantId}/apiCredentials");
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $createMerchantApiCredentialRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\CreateApiCredentialResponse::class);
    }

    /**
    * Get an API credential
    *
    * @param string $merchantId
    * @param string $apiCredentialId
    * @param array|null $requestOptions
    * @return \Adyen\Model\Management\ApiCredential
    * @throws AdyenException
    */
    public function getApiCredential(string $merchantId, string $apiCredentialId, array $requestOptions = null): \Adyen\Model\Management\ApiCredential
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}', '{apiCredentialId}'], [$merchantId, $apiCredentialId], "/merchants/{merchantId}/apiCredentials/{apiCredentialId}");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\ApiCredential::class);
    }

    /**
    * Get a list of API credentials
    *
    * @param string $merchantId
    * @param array|null $requestOptions ['queryParams' => ['pageNumber'=> int, 'pageSize'=> int]]
    * @return \Adyen\Model\Management\ListMerchantApiCredentialsResponse
    * @throws AdyenException
    */
    public function listApiCredentials(string $merchantId, array $requestOptions = null): \Adyen\Model\Management\ListMerchantApiCredentialsResponse
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}'], [$merchantId], "/merchants/{merchantId}/apiCredentials");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\ListMerchantApiCredentialsResponse::class);
    }

    /**
    * Update an API credential
    *
    * @param string $merchantId
    * @param string $apiCredentialId
    * @param \Adyen\Model\Management\UpdateMerchantApiCredentialRequest $updateMerchantApiCredentialRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Management\ApiCredential
    * @throws AdyenException
    */
    public function updateApiCredential(string $merchantId, string $apiCredentialId, \Adyen\Model\Management\UpdateMerchantApiCredentialRequest $updateMerchantApiCredentialRequest, array $requestOptions = null): \Adyen\Model\Management\ApiCredential
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}', '{apiCredentialId}'], [$merchantId, $apiCredentialId], "/merchants/{merchantId}/apiCredentials/{apiCredentialId}");
        $response = $this->requestHttp($endpoint, strtolower('PATCH'), (array) $updateMerchantApiCredentialRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\ApiCredential::class);
    }
}
