<?php
/**
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Adyen\Service\BalancePlatform;

use Adyen\AdyenException;
use Adyen\Client;
use Adyen\Service;
use Adyen\Model\BalancePlatform\ObjectSerializer;

class TransactionRulesApi extends Service
{
    /**
     * @var array|string|string[]
     */
    private $baseURL;

    /**
     * TransactionRulesApi constructor.
     *
     * @param \Adyen\Client $client
     * @throws AdyenException
     */
    public function __construct(Client $client)
    {
        parent::__construct($client);

        // Create the baseUrl based on live/test and optional live-url-prefix
        $this->baseURL = $this->createBaseUrl("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    /**
    * Create a transaction rule
    *
    * @param \Adyen\Model\BalancePlatform\TransactionRuleInfo $transactionRuleInfo
    * @param array|null $requestOptions
    * @return \Adyen\Model\BalancePlatform\TransactionRule
    * @throws AdyenException
    */
    public function createTransactionRule(\Adyen\Model\BalancePlatform\TransactionRuleInfo $transactionRuleInfo, array $requestOptions = null): \Adyen\Model\BalancePlatform\TransactionRule
    {
        $endpoint = $this->baseURL . "/transactionRules";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $transactionRuleInfo->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\TransactionRule::class);
    }

    /**
    * Delete a transaction rule
    *
    * @param string $transactionRuleId
    * @param array|null $requestOptions
    * @return \Adyen\Model\BalancePlatform\TransactionRule
    * @throws AdyenException
    */
    public function deleteTransactionRule(string $transactionRuleId, array $requestOptions = null): \Adyen\Model\BalancePlatform\TransactionRule
    {
        $endpoint = $this->baseURL . str_replace(['{transactionRuleId}'], [$transactionRuleId], "/transactionRules/{transactionRuleId}");
        $response = $this->requestHttp($endpoint, strtolower('DELETE'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\TransactionRule::class);
    }

    /**
    * Get a transaction rule
    *
    * @param string $transactionRuleId
    * @param array|null $requestOptions
    * @return \Adyen\Model\BalancePlatform\TransactionRuleResponse
    * @throws AdyenException
    */
    public function getTransactionRule(string $transactionRuleId, array $requestOptions = null): \Adyen\Model\BalancePlatform\TransactionRuleResponse
    {
        $endpoint = $this->baseURL . str_replace(['{transactionRuleId}'], [$transactionRuleId], "/transactionRules/{transactionRuleId}");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\TransactionRuleResponse::class);
    }

    /**
    * Update a transaction rule
    *
    * @param string $transactionRuleId
    * @param \Adyen\Model\BalancePlatform\TransactionRuleInfo $transactionRuleInfo
    * @param array|null $requestOptions
    * @return \Adyen\Model\BalancePlatform\TransactionRule
    * @throws AdyenException
    */
    public function updateTransactionRule(string $transactionRuleId, \Adyen\Model\BalancePlatform\TransactionRuleInfo $transactionRuleInfo, array $requestOptions = null): \Adyen\Model\BalancePlatform\TransactionRule
    {
        $endpoint = $this->baseURL . str_replace(['{transactionRuleId}'], [$transactionRuleId], "/transactionRules/{transactionRuleId}");
        $response = $this->requestHttp($endpoint, strtolower('PATCH'), (array) $transactionRuleInfo->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\TransactionRule::class);
    }
}
