<?php

namespace PaymentWebhooks\Gateway\Adyen;

use PaymentWebhooks\Contract\StatusMapperInterface;
use PaymentWebhooks\Gateway\Common\CommonStatusMapper;
use PaymentWebhooks\Gateway\Common\PayloadHelper;

final class AdyenStatusMapper extends CommonStatusMapper implements StatusMapperInterface
{
    public function __construct(string $gateway)
    {
        parent::__construct($gateway);
    }

    public function map(array $payload): ?string
    {
        $eventCodePath = $this->jsonFields['event_code'];
        $eventCode = PayloadHelper::getByPath($payload, $eventCodePath);

        $successStatusPath = $this->jsonFields['success_status'];
        $success = PayloadHelper::getByPath($payload, $successStatusPath);

        if (!is_string($eventCode) || !is_string($success)) {
            throw new \RuntimeException('Invalid Adyen payload or config');
        }

        $key = $eventCode . ':' . $success;
        return $this->map[$key] ?? null;
    }
}
