<?php

namespace PaymentWebhooks\Application;

use PaymentWebhooks\Core\AbstractWebhookHandler;
use PaymentWebhooks\Core\OrderStatusUpdater;
use PaymentWebhooks\Gateway\Adyen\AdyenAuthenticator;
use PaymentWebhooks\Gateway\Adyen\AdyenPostValidator;
use PaymentWebhooks\Gateway\Adyen\AdyenStatusMapper;
use PaymentWebhooks\Gateway\Adyen\AdyenWebhookHandler;
use PaymentWebhooks\Gateway\Common\CommonOrderIdResolver;
use PaymentWebhooks\Gateway\Common\CommonPayloadValidator;
use PaymentWebhooks\Gateway\PayPal\PayPalAuthenticator;
use PaymentWebhooks\Gateway\PayPal\PayPalPostValidator;
use PaymentWebhooks\Gateway\PayPal\PayPalStatusMapper;
use PaymentWebhooks\Gateway\PayPal\PayPalWebhookHandler;
use PaymentWebhooks\Infrastructure\Logger;

class WebhookHandlerFactory
{
    public static function make(string $gateway): ?AbstractWebhookHandler
    {
        return match ($gateway) {
            'adyen' => new AdyenWebhookHandler(
                new AdyenAuthenticator(),
                new CommonPayloadValidator(),
                new AdyenPostValidator(),
                new AdyenStatusMapper($gateway),
                new OrderStatusUpdater(),
                Logger::forGateway($gateway),
                new CommonOrderIdResolver($gateway)
            ),
            'paypal' => new PayPalWebhookHandler(
                new PayPalAuthenticator(),
                new CommonPayloadValidator(),
                new PayPalPostValidator(),
                new PayPalStatusMapper($gateway),
                new OrderStatusUpdater(),
                Logger::forGateway($gateway),
                new CommonOrderIdResolver($gateway)
            ),
            default => null,
        };
    }
}
