<?php

/**
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Adyen\Model\LegalEntityManagement;

use \ArrayAccess;
use Adyen\Model\LegalEntityManagement\ObjectSerializer;

/**
 * TaxReportingClassification Class Doc Comment
 *
 * @category Class
 * @package  Adyen
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class TaxReportingClassification implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TaxReportingClassification';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'businessType' => 'string',
        'financialInstitutionNumber' => 'string',
        'mainSourceOfIncome' => 'string',
        'type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'businessType' => null,
        'financialInstitutionNumber' => null,
        'mainSourceOfIncome' => null,
        'type' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'businessType' => false,
        'financialInstitutionNumber' => false,
        'mainSourceOfIncome' => false,
        'type' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'businessType' => 'businessType',
        'financialInstitutionNumber' => 'financialInstitutionNumber',
        'mainSourceOfIncome' => 'mainSourceOfIncome',
        'type' => 'type'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'businessType' => 'setBusinessType',
        'financialInstitutionNumber' => 'setFinancialInstitutionNumber',
        'mainSourceOfIncome' => 'setMainSourceOfIncome',
        'type' => 'setType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'businessType' => 'getBusinessType',
        'financialInstitutionNumber' => 'getFinancialInstitutionNumber',
        'mainSourceOfIncome' => 'getMainSourceOfIncome',
        'type' => 'getType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const BUSINESS_TYPE_OTHER = 'other';
    public const BUSINESS_TYPE_LISTED_PUBLIC_COMPANY = 'listedPublicCompany';
    public const BUSINESS_TYPE_SUBSIDIARY_OF_LISTED_PUBLIC_COMPANY = 'subsidiaryOfListedPublicCompany';
    public const BUSINESS_TYPE_GOVERNMENTAL_ORGANIZATION = 'governmentalOrganization';
    public const BUSINESS_TYPE_INTERNATIONAL_ORGANIZATION = 'internationalOrganization';
    public const BUSINESS_TYPE_FINANCIAL_INSTITUTION = 'financialInstitution';
    public const MAIN_SOURCE_OF_INCOME_BUSINESS_OPERATION = 'businessOperation';
    public const MAIN_SOURCE_OF_INCOME_REAL_ESTATE_SALES = 'realEstateSales';
    public const MAIN_SOURCE_OF_INCOME_INVESTMENT_INTEREST_OR_ROYALTY = 'investmentInterestOrRoyalty';
    public const MAIN_SOURCE_OF_INCOME_PROPERTY_RENTAL = 'propertyRental';
    public const MAIN_SOURCE_OF_INCOME_OTHER = 'other';
    public const TYPE_NON_FINANCIAL_NON_REPORTABLE = 'nonFinancialNonReportable';
    public const TYPE_FINANCIAL_NON_REPORTABLE = 'financialNonReportable';
    public const TYPE_NON_FINANCIAL_ACTIVE = 'nonFinancialActive';
    public const TYPE_NON_FINANCIAL_PASSIVE = 'nonFinancialPassive';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getBusinessTypeAllowableValues()
    {
        return [
            self::BUSINESS_TYPE_OTHER,
            self::BUSINESS_TYPE_LISTED_PUBLIC_COMPANY,
            self::BUSINESS_TYPE_SUBSIDIARY_OF_LISTED_PUBLIC_COMPANY,
            self::BUSINESS_TYPE_GOVERNMENTAL_ORGANIZATION,
            self::BUSINESS_TYPE_INTERNATIONAL_ORGANIZATION,
            self::BUSINESS_TYPE_FINANCIAL_INSTITUTION,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getMainSourceOfIncomeAllowableValues()
    {
        return [
            self::MAIN_SOURCE_OF_INCOME_BUSINESS_OPERATION,
            self::MAIN_SOURCE_OF_INCOME_REAL_ESTATE_SALES,
            self::MAIN_SOURCE_OF_INCOME_INVESTMENT_INTEREST_OR_ROYALTY,
            self::MAIN_SOURCE_OF_INCOME_PROPERTY_RENTAL,
            self::MAIN_SOURCE_OF_INCOME_OTHER,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_NON_FINANCIAL_NON_REPORTABLE,
            self::TYPE_FINANCIAL_NON_REPORTABLE,
            self::TYPE_NON_FINANCIAL_ACTIVE,
            self::TYPE_NON_FINANCIAL_PASSIVE,
        ];
    }
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('businessType', $data ?? [], null);
        $this->setIfExists('financialInstitutionNumber', $data ?? [], null);
        $this->setIfExists('mainSourceOfIncome', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getBusinessTypeAllowableValues();
        if (!is_null($this->container['businessType']) && !in_array($this->container['businessType'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'businessType', must be one of '%s'",
                $this->container['businessType'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getMainSourceOfIncomeAllowableValues();
        if (!is_null($this->container['mainSourceOfIncome']) && !in_array($this->container['mainSourceOfIncome'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'mainSourceOfIncome', must be one of '%s'",
                $this->container['mainSourceOfIncome'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'type', must be one of '%s'",
                $this->container['type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets businessType
     *
     * @return string|null
     */
    public function getBusinessType()
    {
        return $this->container['businessType'];
    }

    /**
     * Sets businessType
     *
     * @param string|null $businessType The organization's business type.  Possible values: **other**, **listedPublicCompany**, **subsidiaryOfListedPublicCompany**, **governmentalOrganization**, **internationalOrganization**, **financialInstitution**.
     *
     * @return self
     */
    public function setBusinessType($businessType)
    {
        $allowedValues = $this->getBusinessTypeAllowableValues();
        if (!in_array($businessType, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'businessType', must be one of '%s'",
                    $businessType,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['businessType'] = $businessType;

        return $this;
    }

    /**
     * Gets financialInstitutionNumber
     *
     * @return string|null
     */
    public function getFinancialInstitutionNumber()
    {
        return $this->container['financialInstitutionNumber'];
    }

    /**
     * Sets financialInstitutionNumber
     *
     * @param string|null $financialInstitutionNumber The Global Intermediary Identification Number (GIIN) required for FATCA. Only required if the organization is a US financial institution and the `businessType` is **financialInstitution**.
     *
     * @return self
     */
    public function setFinancialInstitutionNumber($financialInstitutionNumber)
    {
        $this->container['financialInstitutionNumber'] = $financialInstitutionNumber;

        return $this;
    }

    /**
     * Gets mainSourceOfIncome
     *
     * @return string|null
     */
    public function getMainSourceOfIncome()
    {
        return $this->container['mainSourceOfIncome'];
    }

    /**
     * Sets mainSourceOfIncome
     *
     * @param string|null $mainSourceOfIncome The organization's main source of income. Only required if `businessType` is **other**.  Possible values: **businessOperation**, **realEstateSales**, **investmentInterestOrRoyalty**, **propertyRental**, **other**.
     *
     * @return self
     */
    public function setMainSourceOfIncome($mainSourceOfIncome)
    {
        $allowedValues = $this->getMainSourceOfIncomeAllowableValues();
        if (!in_array($mainSourceOfIncome, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'mainSourceOfIncome', must be one of '%s'",
                    $mainSourceOfIncome,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['mainSourceOfIncome'] = $mainSourceOfIncome;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type The tax reporting classification type.  Possible values: **nonFinancialNonReportable**, **financialNonReportable**, **nonFinancialActive**, **nonFinancialPassive**.
     *
     * @return self
     */
    public function setType($type)
    {
        $allowedValues = $this->getTypeAllowableValues();
        if (!in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'type', must be one of '%s'",
                    $type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    public function toArray(): array
    {
        $array = [];
        foreach (self::$openAPITypes as $propertyName => $propertyType) {
            $propertyValue = $this[$propertyName];
            if ($propertyValue !== null) {
                // Check if the property value is an object and has a toArray() method
                if (is_object($propertyValue) && method_exists($propertyValue, 'toArray')) {
                    $array[$propertyName] = $propertyValue->toArray();
                // Check if it's type datetime
                } elseif ($propertyValue instanceof \DateTime) {
                    $array[$propertyName] = $propertyValue->format(DATE_ATOM);
                // If it's an array type we should check whether it contains objects and if so call toArray method
                } elseif (is_array($propertyValue)) {
                    $array[$propertyName] = array_map(function ($item) {
                        return $item instanceof ModelInterface ? $item->toArray() : $item;
                    }, $propertyValue);
                } else {
                    // Otherwise, directly assign the property value to the array
                    $array[$propertyName] = $propertyValue;
                }
            }
        }
        return $array;
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}
