<?php

/**
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Adyen\Model\Checkout;

use \ArrayAccess;
use Adyen\Model\Checkout\ObjectSerializer;

/**
 * CheckoutPaymentMethod Class Doc Comment
 *
 * @category Class
 * @description The type and required details of a payment method to use.
 * @package  Adyen
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CheckoutPaymentMethod implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CheckoutPaymentMethod';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'bankAccountNumber' => 'string',
        'bankAccountType' => 'string',
        'bankLocationId' => 'string',
        'checkoutAttemptId' => 'string',
        'encryptedBankAccountNumber' => 'string',
        'encryptedBankLocationId' => 'string',
        'ownerName' => 'string',
        'recurringDetailReference' => 'string',
        'storedPaymentMethodId' => 'string',
        'transferInstrumentId' => 'string',
        'type' => 'string',
        'billingAddress' => 'string',
        'deliveryAddress' => 'string',
        'personalDetails' => 'string',
        'amazonPayToken' => 'string',
        'checkoutSessionId' => 'string',
        'beneficiaryId' => 'string',
        'applePayToken' => 'string',
        'fundingSource' => 'string',
        'holderName' => 'string',
        'issuer' => 'string',
        'blikCode' => 'string',
        'brand' => 'string',
        'cupsecureplusSmscode' => 'string',
        'cvc' => 'string',
        'encryptedCard' => 'string',
        'encryptedCardNumber' => 'string',
        'encryptedExpiryMonth' => 'string',
        'encryptedExpiryYear' => 'string',
        'encryptedSecurityCode' => 'string',
        'expiryMonth' => 'string',
        'expiryYear' => 'string',
        'fastlaneData' => 'string',
        'networkPaymentReference' => 'string',
        'number' => 'string',
        'shopperNotificationReference' => 'string',
        'srcCorrelationId' => 'string',
        'srcDigitalCardId' => 'string',
        'srcScheme' => 'string',
        'srcTokenReference' => 'string',
        'threeDS2SdkVersion' => 'string',
        'cashtag' => 'string',
        'customerId' => 'string',
        'grantId' => 'string',
        'onFileGrantId' => 'string',
        'requestId' => 'string',
        'subtype' => 'string',
        'firstName' => 'string',
        'lastName' => 'string',
        'shopperEmail' => 'string',
        'telephoneNumber' => 'string',
        'bankCode' => 'string',
        'googlePayCardNetwork' => 'string',
        'googlePayToken' => 'string',
        'masterpassTransactionId' => 'string',
        'orderID' => 'string',
        'payeePreferred' => 'string',
        'payerID' => 'string',
        'payerSelected' => 'string',
        'shopperAccountIdentifier' => 'string',
        'virtualPaymentAddress' => 'string',
        'pixRecurring' => '\Adyen\Model\Checkout\PixRecurring',
        'bank' => 'string',
        'clientType' => 'string',
        'identification' => 'string',
        'identificationType' => 'string',
        'deviceFingerprint' => 'string',
        'iban' => 'string',
        'samsungPayToken' => 'string',
        'billingSequenceNumber' => 'string',
        'appId' => 'string',
        'visaCheckoutCallId' => 'string',
        'openid' => 'string',
        'clickAndCollect' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'bankAccountNumber' => null,
        'bankAccountType' => null,
        'bankLocationId' => null,
        'checkoutAttemptId' => null,
        'encryptedBankAccountNumber' => null,
        'encryptedBankLocationId' => null,
        'ownerName' => null,
        'recurringDetailReference' => null,
        'storedPaymentMethodId' => null,
        'transferInstrumentId' => null,
        'type' => null,
        'billingAddress' => null,
        'deliveryAddress' => null,
        'personalDetails' => null,
        'amazonPayToken' => null,
        'checkoutSessionId' => null,
        'beneficiaryId' => null,
        'applePayToken' => null,
        'fundingSource' => null,
        'holderName' => null,
        'issuer' => null,
        'blikCode' => null,
        'brand' => null,
        'cupsecureplusSmscode' => null,
        'cvc' => null,
        'encryptedCard' => null,
        'encryptedCardNumber' => null,
        'encryptedExpiryMonth' => null,
        'encryptedExpiryYear' => null,
        'encryptedSecurityCode' => null,
        'expiryMonth' => null,
        'expiryYear' => null,
        'fastlaneData' => null,
        'networkPaymentReference' => null,
        'number' => null,
        'shopperNotificationReference' => null,
        'srcCorrelationId' => null,
        'srcDigitalCardId' => null,
        'srcScheme' => null,
        'srcTokenReference' => null,
        'threeDS2SdkVersion' => null,
        'cashtag' => null,
        'customerId' => null,
        'grantId' => null,
        'onFileGrantId' => null,
        'requestId' => null,
        'subtype' => null,
        'firstName' => null,
        'lastName' => null,
        'shopperEmail' => null,
        'telephoneNumber' => null,
        'bankCode' => null,
        'googlePayCardNetwork' => null,
        'googlePayToken' => null,
        'masterpassTransactionId' => null,
        'orderID' => null,
        'payeePreferred' => null,
        'payerID' => null,
        'payerSelected' => null,
        'shopperAccountIdentifier' => null,
        'virtualPaymentAddress' => null,
        'pixRecurring' => null,
        'bank' => null,
        'clientType' => null,
        'identification' => null,
        'identificationType' => null,
        'deviceFingerprint' => null,
        'iban' => null,
        'samsungPayToken' => null,
        'billingSequenceNumber' => null,
        'appId' => null,
        'visaCheckoutCallId' => null,
        'openid' => null,
        'clickAndCollect' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'bankAccountNumber' => false,
        'bankAccountType' => false,
        'bankLocationId' => false,
        'checkoutAttemptId' => false,
        'encryptedBankAccountNumber' => false,
        'encryptedBankLocationId' => false,
        'ownerName' => false,
        'recurringDetailReference' => false,
        'storedPaymentMethodId' => false,
        'transferInstrumentId' => false,
        'type' => false,
        'billingAddress' => false,
        'deliveryAddress' => false,
        'personalDetails' => false,
        'amazonPayToken' => false,
        'checkoutSessionId' => false,
        'beneficiaryId' => false,
        'applePayToken' => false,
        'fundingSource' => false,
        'holderName' => false,
        'issuer' => false,
        'blikCode' => false,
        'brand' => false,
        'cupsecureplusSmscode' => false,
        'cvc' => false,
        'encryptedCard' => false,
        'encryptedCardNumber' => false,
        'encryptedExpiryMonth' => false,
        'encryptedExpiryYear' => false,
        'encryptedSecurityCode' => false,
        'expiryMonth' => false,
        'expiryYear' => false,
        'fastlaneData' => false,
        'networkPaymentReference' => false,
        'number' => false,
        'shopperNotificationReference' => false,
        'srcCorrelationId' => false,
        'srcDigitalCardId' => false,
        'srcScheme' => false,
        'srcTokenReference' => false,
        'threeDS2SdkVersion' => false,
        'cashtag' => false,
        'customerId' => false,
        'grantId' => false,
        'onFileGrantId' => false,
        'requestId' => false,
        'subtype' => false,
        'firstName' => false,
        'lastName' => false,
        'shopperEmail' => false,
        'telephoneNumber' => false,
        'bankCode' => false,
        'googlePayCardNetwork' => false,
        'googlePayToken' => false,
        'masterpassTransactionId' => false,
        'orderID' => false,
        'payeePreferred' => false,
        'payerID' => false,
        'payerSelected' => false,
        'shopperAccountIdentifier' => false,
        'virtualPaymentAddress' => false,
        'pixRecurring' => false,
        'bank' => false,
        'clientType' => false,
        'identification' => false,
        'identificationType' => false,
        'deviceFingerprint' => false,
        'iban' => false,
        'samsungPayToken' => false,
        'billingSequenceNumber' => false,
        'appId' => false,
        'visaCheckoutCallId' => false,
        'openid' => false,
        'clickAndCollect' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'bankAccountNumber' => 'bankAccountNumber',
        'bankAccountType' => 'bankAccountType',
        'bankLocationId' => 'bankLocationId',
        'checkoutAttemptId' => 'checkoutAttemptId',
        'encryptedBankAccountNumber' => 'encryptedBankAccountNumber',
        'encryptedBankLocationId' => 'encryptedBankLocationId',
        'ownerName' => 'ownerName',
        'recurringDetailReference' => 'recurringDetailReference',
        'storedPaymentMethodId' => 'storedPaymentMethodId',
        'transferInstrumentId' => 'transferInstrumentId',
        'type' => 'type',
        'billingAddress' => 'billingAddress',
        'deliveryAddress' => 'deliveryAddress',
        'personalDetails' => 'personalDetails',
        'amazonPayToken' => 'amazonPayToken',
        'checkoutSessionId' => 'checkoutSessionId',
        'beneficiaryId' => 'beneficiaryId',
        'applePayToken' => 'applePayToken',
        'fundingSource' => 'fundingSource',
        'holderName' => 'holderName',
        'issuer' => 'issuer',
        'blikCode' => 'blikCode',
        'brand' => 'brand',
        'cupsecureplusSmscode' => 'cupsecureplus.smscode',
        'cvc' => 'cvc',
        'encryptedCard' => 'encryptedCard',
        'encryptedCardNumber' => 'encryptedCardNumber',
        'encryptedExpiryMonth' => 'encryptedExpiryMonth',
        'encryptedExpiryYear' => 'encryptedExpiryYear',
        'encryptedSecurityCode' => 'encryptedSecurityCode',
        'expiryMonth' => 'expiryMonth',
        'expiryYear' => 'expiryYear',
        'fastlaneData' => 'fastlaneData',
        'networkPaymentReference' => 'networkPaymentReference',
        'number' => 'number',
        'shopperNotificationReference' => 'shopperNotificationReference',
        'srcCorrelationId' => 'srcCorrelationId',
        'srcDigitalCardId' => 'srcDigitalCardId',
        'srcScheme' => 'srcScheme',
        'srcTokenReference' => 'srcTokenReference',
        'threeDS2SdkVersion' => 'threeDS2SdkVersion',
        'cashtag' => 'cashtag',
        'customerId' => 'customerId',
        'grantId' => 'grantId',
        'onFileGrantId' => 'onFileGrantId',
        'requestId' => 'requestId',
        'subtype' => 'subtype',
        'firstName' => 'firstName',
        'lastName' => 'lastName',
        'shopperEmail' => 'shopperEmail',
        'telephoneNumber' => 'telephoneNumber',
        'bankCode' => 'bankCode',
        'googlePayCardNetwork' => 'googlePayCardNetwork',
        'googlePayToken' => 'googlePayToken',
        'masterpassTransactionId' => 'masterpassTransactionId',
        'orderID' => 'orderID',
        'payeePreferred' => 'payeePreferred',
        'payerID' => 'payerID',
        'payerSelected' => 'payerSelected',
        'shopperAccountIdentifier' => 'shopperAccountIdentifier',
        'virtualPaymentAddress' => 'virtualPaymentAddress',
        'pixRecurring' => 'pixRecurring',
        'bank' => 'bank',
        'clientType' => 'clientType',
        'identification' => 'identification',
        'identificationType' => 'identificationType',
        'deviceFingerprint' => 'deviceFingerprint',
        'iban' => 'iban',
        'samsungPayToken' => 'samsungPayToken',
        'billingSequenceNumber' => 'billingSequenceNumber',
        'appId' => 'appId',
        'visaCheckoutCallId' => 'visaCheckoutCallId',
        'openid' => 'openid',
        'clickAndCollect' => 'clickAndCollect'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'bankAccountNumber' => 'setBankAccountNumber',
        'bankAccountType' => 'setBankAccountType',
        'bankLocationId' => 'setBankLocationId',
        'checkoutAttemptId' => 'setCheckoutAttemptId',
        'encryptedBankAccountNumber' => 'setEncryptedBankAccountNumber',
        'encryptedBankLocationId' => 'setEncryptedBankLocationId',
        'ownerName' => 'setOwnerName',
        'recurringDetailReference' => 'setRecurringDetailReference',
        'storedPaymentMethodId' => 'setStoredPaymentMethodId',
        'transferInstrumentId' => 'setTransferInstrumentId',
        'type' => 'setType',
        'billingAddress' => 'setBillingAddress',
        'deliveryAddress' => 'setDeliveryAddress',
        'personalDetails' => 'setPersonalDetails',
        'amazonPayToken' => 'setAmazonPayToken',
        'checkoutSessionId' => 'setCheckoutSessionId',
        'beneficiaryId' => 'setBeneficiaryId',
        'applePayToken' => 'setApplePayToken',
        'fundingSource' => 'setFundingSource',
        'holderName' => 'setHolderName',
        'issuer' => 'setIssuer',
        'blikCode' => 'setBlikCode',
        'brand' => 'setBrand',
        'cupsecureplusSmscode' => 'setCupsecureplusSmscode',
        'cvc' => 'setCvc',
        'encryptedCard' => 'setEncryptedCard',
        'encryptedCardNumber' => 'setEncryptedCardNumber',
        'encryptedExpiryMonth' => 'setEncryptedExpiryMonth',
        'encryptedExpiryYear' => 'setEncryptedExpiryYear',
        'encryptedSecurityCode' => 'setEncryptedSecurityCode',
        'expiryMonth' => 'setExpiryMonth',
        'expiryYear' => 'setExpiryYear',
        'fastlaneData' => 'setFastlaneData',
        'networkPaymentReference' => 'setNetworkPaymentReference',
        'number' => 'setNumber',
        'shopperNotificationReference' => 'setShopperNotificationReference',
        'srcCorrelationId' => 'setSrcCorrelationId',
        'srcDigitalCardId' => 'setSrcDigitalCardId',
        'srcScheme' => 'setSrcScheme',
        'srcTokenReference' => 'setSrcTokenReference',
        'threeDS2SdkVersion' => 'setThreeDS2SdkVersion',
        'cashtag' => 'setCashtag',
        'customerId' => 'setCustomerId',
        'grantId' => 'setGrantId',
        'onFileGrantId' => 'setOnFileGrantId',
        'requestId' => 'setRequestId',
        'subtype' => 'setSubtype',
        'firstName' => 'setFirstName',
        'lastName' => 'setLastName',
        'shopperEmail' => 'setShopperEmail',
        'telephoneNumber' => 'setTelephoneNumber',
        'bankCode' => 'setBankCode',
        'googlePayCardNetwork' => 'setGooglePayCardNetwork',
        'googlePayToken' => 'setGooglePayToken',
        'masterpassTransactionId' => 'setMasterpassTransactionId',
        'orderID' => 'setOrderID',
        'payeePreferred' => 'setPayeePreferred',
        'payerID' => 'setPayerID',
        'payerSelected' => 'setPayerSelected',
        'shopperAccountIdentifier' => 'setShopperAccountIdentifier',
        'virtualPaymentAddress' => 'setVirtualPaymentAddress',
        'pixRecurring' => 'setPixRecurring',
        'bank' => 'setBank',
        'clientType' => 'setClientType',
        'identification' => 'setIdentification',
        'identificationType' => 'setIdentificationType',
        'deviceFingerprint' => 'setDeviceFingerprint',
        'iban' => 'setIban',
        'samsungPayToken' => 'setSamsungPayToken',
        'billingSequenceNumber' => 'setBillingSequenceNumber',
        'appId' => 'setAppId',
        'visaCheckoutCallId' => 'setVisaCheckoutCallId',
        'openid' => 'setOpenid',
        'clickAndCollect' => 'setClickAndCollect'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'bankAccountNumber' => 'getBankAccountNumber',
        'bankAccountType' => 'getBankAccountType',
        'bankLocationId' => 'getBankLocationId',
        'checkoutAttemptId' => 'getCheckoutAttemptId',
        'encryptedBankAccountNumber' => 'getEncryptedBankAccountNumber',
        'encryptedBankLocationId' => 'getEncryptedBankLocationId',
        'ownerName' => 'getOwnerName',
        'recurringDetailReference' => 'getRecurringDetailReference',
        'storedPaymentMethodId' => 'getStoredPaymentMethodId',
        'transferInstrumentId' => 'getTransferInstrumentId',
        'type' => 'getType',
        'billingAddress' => 'getBillingAddress',
        'deliveryAddress' => 'getDeliveryAddress',
        'personalDetails' => 'getPersonalDetails',
        'amazonPayToken' => 'getAmazonPayToken',
        'checkoutSessionId' => 'getCheckoutSessionId',
        'beneficiaryId' => 'getBeneficiaryId',
        'applePayToken' => 'getApplePayToken',
        'fundingSource' => 'getFundingSource',
        'holderName' => 'getHolderName',
        'issuer' => 'getIssuer',
        'blikCode' => 'getBlikCode',
        'brand' => 'getBrand',
        'cupsecureplusSmscode' => 'getCupsecureplusSmscode',
        'cvc' => 'getCvc',
        'encryptedCard' => 'getEncryptedCard',
        'encryptedCardNumber' => 'getEncryptedCardNumber',
        'encryptedExpiryMonth' => 'getEncryptedExpiryMonth',
        'encryptedExpiryYear' => 'getEncryptedExpiryYear',
        'encryptedSecurityCode' => 'getEncryptedSecurityCode',
        'expiryMonth' => 'getExpiryMonth',
        'expiryYear' => 'getExpiryYear',
        'fastlaneData' => 'getFastlaneData',
        'networkPaymentReference' => 'getNetworkPaymentReference',
        'number' => 'getNumber',
        'shopperNotificationReference' => 'getShopperNotificationReference',
        'srcCorrelationId' => 'getSrcCorrelationId',
        'srcDigitalCardId' => 'getSrcDigitalCardId',
        'srcScheme' => 'getSrcScheme',
        'srcTokenReference' => 'getSrcTokenReference',
        'threeDS2SdkVersion' => 'getThreeDS2SdkVersion',
        'cashtag' => 'getCashtag',
        'customerId' => 'getCustomerId',
        'grantId' => 'getGrantId',
        'onFileGrantId' => 'getOnFileGrantId',
        'requestId' => 'getRequestId',
        'subtype' => 'getSubtype',
        'firstName' => 'getFirstName',
        'lastName' => 'getLastName',
        'shopperEmail' => 'getShopperEmail',
        'telephoneNumber' => 'getTelephoneNumber',
        'bankCode' => 'getBankCode',
        'googlePayCardNetwork' => 'getGooglePayCardNetwork',
        'googlePayToken' => 'getGooglePayToken',
        'masterpassTransactionId' => 'getMasterpassTransactionId',
        'orderID' => 'getOrderID',
        'payeePreferred' => 'getPayeePreferred',
        'payerID' => 'getPayerID',
        'payerSelected' => 'getPayerSelected',
        'shopperAccountIdentifier' => 'getShopperAccountIdentifier',
        'virtualPaymentAddress' => 'getVirtualPaymentAddress',
        'pixRecurring' => 'getPixRecurring',
        'bank' => 'getBank',
        'clientType' => 'getClientType',
        'identification' => 'getIdentification',
        'identificationType' => 'getIdentificationType',
        'deviceFingerprint' => 'getDeviceFingerprint',
        'iban' => 'getIban',
        'samsungPayToken' => 'getSamsungPayToken',
        'billingSequenceNumber' => 'getBillingSequenceNumber',
        'appId' => 'getAppId',
        'visaCheckoutCallId' => 'getVisaCheckoutCallId',
        'openid' => 'getOpenid',
        'clickAndCollect' => 'getClickAndCollect'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('bankAccountNumber', $data ?? [], null);
        $this->setIfExists('bankAccountType', $data ?? [], null);
        $this->setIfExists('bankLocationId', $data ?? [], null);
        $this->setIfExists('checkoutAttemptId', $data ?? [], null);
        $this->setIfExists('encryptedBankAccountNumber', $data ?? [], null);
        $this->setIfExists('encryptedBankLocationId', $data ?? [], null);
        $this->setIfExists('ownerName', $data ?? [], null);
        $this->setIfExists('recurringDetailReference', $data ?? [], null);
        $this->setIfExists('storedPaymentMethodId', $data ?? [], null);
        $this->setIfExists('transferInstrumentId', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('billingAddress', $data ?? [], null);
        $this->setIfExists('deliveryAddress', $data ?? [], null);
        $this->setIfExists('personalDetails', $data ?? [], null);
        $this->setIfExists('amazonPayToken', $data ?? [], null);
        $this->setIfExists('checkoutSessionId', $data ?? [], null);
        $this->setIfExists('beneficiaryId', $data ?? [], null);
        $this->setIfExists('applePayToken', $data ?? [], null);
        $this->setIfExists('fundingSource', $data ?? [], null);
        $this->setIfExists('holderName', $data ?? [], null);
        $this->setIfExists('issuer', $data ?? [], null);
        $this->setIfExists('blikCode', $data ?? [], null);
        $this->setIfExists('brand', $data ?? [], null);
        $this->setIfExists('cupsecureplusSmscode', $data ?? [], null);
        $this->setIfExists('cvc', $data ?? [], null);
        $this->setIfExists('encryptedCard', $data ?? [], null);
        $this->setIfExists('encryptedCardNumber', $data ?? [], null);
        $this->setIfExists('encryptedExpiryMonth', $data ?? [], null);
        $this->setIfExists('encryptedExpiryYear', $data ?? [], null);
        $this->setIfExists('encryptedSecurityCode', $data ?? [], null);
        $this->setIfExists('expiryMonth', $data ?? [], null);
        $this->setIfExists('expiryYear', $data ?? [], null);
        $this->setIfExists('fastlaneData', $data ?? [], null);
        $this->setIfExists('networkPaymentReference', $data ?? [], null);
        $this->setIfExists('number', $data ?? [], null);
        $this->setIfExists('shopperNotificationReference', $data ?? [], null);
        $this->setIfExists('srcCorrelationId', $data ?? [], null);
        $this->setIfExists('srcDigitalCardId', $data ?? [], null);
        $this->setIfExists('srcScheme', $data ?? [], null);
        $this->setIfExists('srcTokenReference', $data ?? [], null);
        $this->setIfExists('threeDS2SdkVersion', $data ?? [], null);
        $this->setIfExists('cashtag', $data ?? [], null);
        $this->setIfExists('customerId', $data ?? [], null);
        $this->setIfExists('grantId', $data ?? [], null);
        $this->setIfExists('onFileGrantId', $data ?? [], null);
        $this->setIfExists('requestId', $data ?? [], null);
        $this->setIfExists('subtype', $data ?? [], null);
        $this->setIfExists('firstName', $data ?? [], null);
        $this->setIfExists('lastName', $data ?? [], null);
        $this->setIfExists('shopperEmail', $data ?? [], null);
        $this->setIfExists('telephoneNumber', $data ?? [], null);
        $this->setIfExists('bankCode', $data ?? [], null);
        $this->setIfExists('googlePayCardNetwork', $data ?? [], null);
        $this->setIfExists('googlePayToken', $data ?? [], null);
        $this->setIfExists('masterpassTransactionId', $data ?? [], null);
        $this->setIfExists('orderID', $data ?? [], null);
        $this->setIfExists('payeePreferred', $data ?? [], null);
        $this->setIfExists('payerID', $data ?? [], null);
        $this->setIfExists('payerSelected', $data ?? [], null);
        $this->setIfExists('shopperAccountIdentifier', $data ?? [], null);
        $this->setIfExists('virtualPaymentAddress', $data ?? [], null);
        $this->setIfExists('pixRecurring', $data ?? [], null);
        $this->setIfExists('bank', $data ?? [], null);
        $this->setIfExists('clientType', $data ?? [], null);
        $this->setIfExists('identification', $data ?? [], null);
        $this->setIfExists('identificationType', $data ?? [], null);
        $this->setIfExists('deviceFingerprint', $data ?? [], null);
        $this->setIfExists('iban', $data ?? [], null);
        $this->setIfExists('samsungPayToken', $data ?? [], null);
        $this->setIfExists('billingSequenceNumber', $data ?? [], null);
        $this->setIfExists('appId', $data ?? [], null);
        $this->setIfExists('visaCheckoutCallId', $data ?? [], null);
        $this->setIfExists('openid', $data ?? [], null);
        $this->setIfExists('clickAndCollect', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];


        if ($this->container['ownerName'] === null) {
            $invalidProperties[] = "'ownerName' can't be null";
        }
        if ($this->container['type'] === null) {
            $invalidProperties[] = "'type' can't be null";
        }

        if ($this->container['applePayToken'] === null) {
            $invalidProperties[] = "'applePayToken' can't be null";
        }

        if ($this->container['issuer'] === null) {
            $invalidProperties[] = "'issuer' can't be null";
        }
        if ($this->container['fastlaneData'] === null) {
            $invalidProperties[] = "'fastlaneData' can't be null";
        }
        if ($this->container['firstName'] === null) {
            $invalidProperties[] = "'firstName' can't be null";
        }
        if ($this->container['lastName'] === null) {
            $invalidProperties[] = "'lastName' can't be null";
        }
        if ($this->container['shopperEmail'] === null) {
            $invalidProperties[] = "'shopperEmail' can't be null";
        }
        if ($this->container['telephoneNumber'] === null) {
            $invalidProperties[] = "'telephoneNumber' can't be null";
        }
        if ($this->container['googlePayToken'] === null) {
            $invalidProperties[] = "'googlePayToken' can't be null";
        }
        if ($this->container['masterpassTransactionId'] === null) {
            $invalidProperties[] = "'masterpassTransactionId' can't be null";
        }
        if ($this->container['bank'] === null) {
            $invalidProperties[] = "'bank' can't be null";
        }
        if ($this->container['clientType'] === null) {
            $invalidProperties[] = "'clientType' can't be null";
        }
        if ($this->container['identification'] === null) {
            $invalidProperties[] = "'identification' can't be null";
        }
        if ($this->container['identificationType'] === null) {
            $invalidProperties[] = "'identificationType' can't be null";
        }
        if ($this->container['iban'] === null) {
            $invalidProperties[] = "'iban' can't be null";
        }
        if ($this->container['samsungPayToken'] === null) {
            $invalidProperties[] = "'samsungPayToken' can't be null";
        }
        if ($this->container['billingSequenceNumber'] === null) {
            $invalidProperties[] = "'billingSequenceNumber' can't be null";
        }
        if ($this->container['visaCheckoutCallId'] === null) {
            $invalidProperties[] = "'visaCheckoutCallId' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets bankAccountNumber
     *
     * @return string|null
     */
    public function getBankAccountNumber()
    {
        return $this->container['bankAccountNumber'];
    }

    /**
     * Sets bankAccountNumber
     *
     * @param string|null $bankAccountNumber The bank account number (without separators).
     *
     * @return self
     */
    public function setBankAccountNumber($bankAccountNumber)
    {
        $this->container['bankAccountNumber'] = $bankAccountNumber;

        return $this;
    }

    /**
     * Gets bankAccountType
     *
     * @return string|null
     */
    public function getBankAccountType()
    {
        return $this->container['bankAccountType'];
    }

    /**
     * Sets bankAccountType
     *
     * @param string|null $bankAccountType The bank account type (checking, savings...).
     *
     * @return self
     */
    public function setBankAccountType($bankAccountType)
    {
        $this->container['bankAccountType'] = $bankAccountType;

        return $this;
    }

    /**
     * Gets bankLocationId
     *
     * @return string|null
     */
    public function getBankLocationId()
    {
        return $this->container['bankLocationId'];
    }

    /**
     * Sets bankLocationId
     *
     * @param string|null $bankLocationId The bank routing number of the account.
     *
     * @return self
     */
    public function setBankLocationId($bankLocationId)
    {
        $this->container['bankLocationId'] = $bankLocationId;

        return $this;
    }

    /**
     * Gets checkoutAttemptId
     *
     * @return string|null
     */
    public function getCheckoutAttemptId()
    {
        return $this->container['checkoutAttemptId'];
    }

    /**
     * Sets checkoutAttemptId
     *
     * @param string|null $checkoutAttemptId The checkout attempt identifier.
     *
     * @return self
     */
    public function setCheckoutAttemptId($checkoutAttemptId)
    {
        $this->container['checkoutAttemptId'] = $checkoutAttemptId;

        return $this;
    }

    /**
     * Gets encryptedBankAccountNumber
     *
     * @return string|null
     */
    public function getEncryptedBankAccountNumber()
    {
        return $this->container['encryptedBankAccountNumber'];
    }

    /**
     * Sets encryptedBankAccountNumber
     *
     * @param string|null $encryptedBankAccountNumber Encrypted bank account number. The bank account number (without separators).
     *
     * @return self
     */
    public function setEncryptedBankAccountNumber($encryptedBankAccountNumber)
    {
        $this->container['encryptedBankAccountNumber'] = $encryptedBankAccountNumber;

        return $this;
    }

    /**
     * Gets encryptedBankLocationId
     *
     * @return string|null
     */
    public function getEncryptedBankLocationId()
    {
        return $this->container['encryptedBankLocationId'];
    }

    /**
     * Sets encryptedBankLocationId
     *
     * @param string|null $encryptedBankLocationId Encrypted location id. The bank routing number of the account. The field value is `nil` in most cases.
     *
     * @return self
     */
    public function setEncryptedBankLocationId($encryptedBankLocationId)
    {
        $this->container['encryptedBankLocationId'] = $encryptedBankLocationId;

        return $this;
    }

    /**
     * Gets ownerName
     *
     * @return string
     */
    public function getOwnerName()
    {
        return $this->container['ownerName'];
    }

    /**
     * Sets ownerName
     *
     * @param string $ownerName The name of the bank account holder.
     *
     * @return self
     */
    public function setOwnerName($ownerName)
    {
        $this->container['ownerName'] = $ownerName;

        return $this;
    }

    /**
     * Gets recurringDetailReference
     *
     * @return string|null
     * @deprecated since Adyen Checkout API v49. "Use `storedPaymentMethodId` instead."
     */
    public function getRecurringDetailReference()
    {
        return $this->container['recurringDetailReference'];
    }

    /**
     * Sets recurringDetailReference
     *
     * @param string|null $recurringDetailReference This is the `recurringDetailReference` returned in the response when you created the token.
     *
     * @return self
     * @deprecated since Adyen Checkout API v49. "Use `storedPaymentMethodId` instead."
     */
    public function setRecurringDetailReference($recurringDetailReference)
    {
        $this->container['recurringDetailReference'] = $recurringDetailReference;

        return $this;
    }

    /**
     * Gets storedPaymentMethodId
     *
     * @return string|null
     */
    public function getStoredPaymentMethodId()
    {
        return $this->container['storedPaymentMethodId'];
    }

    /**
     * Sets storedPaymentMethodId
     *
     * @param string|null $storedPaymentMethodId This is the `recurringDetailReference` returned in the response when you created the token.
     *
     * @return self
     */
    public function setStoredPaymentMethodId($storedPaymentMethodId)
    {
        $this->container['storedPaymentMethodId'] = $storedPaymentMethodId;

        return $this;
    }

    /**
     * Gets transferInstrumentId
     *
     * @return string|null
     */
    public function getTransferInstrumentId()
    {
        return $this->container['transferInstrumentId'];
    }

    /**
     * Sets transferInstrumentId
     *
     * @param string|null $transferInstrumentId The unique identifier of your user's verified transfer instrument, which you can use to top up their balance accounts.
     *
     * @return self
     */
    public function setTransferInstrumentId($transferInstrumentId)
    {
        $this->container['transferInstrumentId'] = $transferInstrumentId;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string $type **zip**
     *
     * @return self
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets billingAddress
     *
     * @return string|null
     */
    public function getBillingAddress()
    {
        return $this->container['billingAddress'];
    }

    /**
     * Sets billingAddress
     *
     * @param string|null $billingAddress The address where to send the invoice.
     *
     * @return self
     */
    public function setBillingAddress($billingAddress)
    {
        $this->container['billingAddress'] = $billingAddress;

        return $this;
    }

    /**
     * Gets deliveryAddress
     *
     * @return string|null
     */
    public function getDeliveryAddress()
    {
        return $this->container['deliveryAddress'];
    }

    /**
     * Sets deliveryAddress
     *
     * @param string|null $deliveryAddress The address where the goods should be delivered.
     *
     * @return self
     */
    public function setDeliveryAddress($deliveryAddress)
    {
        $this->container['deliveryAddress'] = $deliveryAddress;

        return $this;
    }

    /**
     * Gets personalDetails
     *
     * @return string|null
     */
    public function getPersonalDetails()
    {
        return $this->container['personalDetails'];
    }

    /**
     * Sets personalDetails
     *
     * @param string|null $personalDetails Shopper name, date of birth, phone number, and email address.
     *
     * @return self
     */
    public function setPersonalDetails($personalDetails)
    {
        $this->container['personalDetails'] = $personalDetails;

        return $this;
    }

    /**
     * Gets amazonPayToken
     *
     * @return string|null
     */
    public function getAmazonPayToken()
    {
        return $this->container['amazonPayToken'];
    }

    /**
     * Sets amazonPayToken
     *
     * @param string|null $amazonPayToken This is the `amazonPayToken` that you obtained from the [Get Checkout Session](https://amazon-pay-acquirer-guide.s3-eu-west-1.amazonaws.com/v1/amazon-pay-api-v2/checkout-session.html#get-checkout-session) response. This token is used for API only integration specifically.
     *
     * @return self
     */
    public function setAmazonPayToken($amazonPayToken)
    {
        $this->container['amazonPayToken'] = $amazonPayToken;

        return $this;
    }

    /**
     * Gets checkoutSessionId
     *
     * @return string|null
     */
    public function getCheckoutSessionId()
    {
        return $this->container['checkoutSessionId'];
    }

    /**
     * Sets checkoutSessionId
     *
     * @param string|null $checkoutSessionId The `checkoutSessionId` is used to identify the checkout session at the Amazon Pay side. This field is required only for drop-in and components integration, where it replaces the amazonPayToken.
     *
     * @return self
     */
    public function setCheckoutSessionId($checkoutSessionId)
    {
        $this->container['checkoutSessionId'] = $checkoutSessionId;

        return $this;
    }

    /**
     * Gets beneficiaryId
     *
     * @return string|null
     */
    public function getBeneficiaryId()
    {
        return $this->container['beneficiaryId'];
    }

    /**
     * Sets beneficiaryId
     *
     * @param string|null $beneficiaryId ANCV account identification (email or account number)
     *
     * @return self
     */
    public function setBeneficiaryId($beneficiaryId)
    {
        $this->container['beneficiaryId'] = $beneficiaryId;

        return $this;
    }

    /**
     * Gets applePayToken
     *
     * @return string
     */
    public function getApplePayToken()
    {
        return $this->container['applePayToken'];
    }

    /**
     * Sets applePayToken
     *
     * @param string $applePayToken The stringified and base64 encoded `paymentData` you retrieved from the Apple framework.
     *
     * @return self
     */
    public function setApplePayToken($applePayToken)
    {
        $this->container['applePayToken'] = $applePayToken;

        return $this;
    }

    /**
     * Gets fundingSource
     *
     * @return string|null
     */
    public function getFundingSource()
    {
        return $this->container['fundingSource'];
    }

    /**
     * Sets fundingSource
     *
     * @param string|null $fundingSource The funding source that should be used when multiple sources are available. For Brazilian combo cards, by default the funding source is credit. To use debit, set this value to **debit**.
     *
     * @return self
     */
    public function setFundingSource($fundingSource)
    {
        $this->container['fundingSource'] = $fundingSource;

        return $this;
    }

    /**
     * Gets holderName
     *
     * @return string|null
     */
    public function getHolderName()
    {
        return $this->container['holderName'];
    }

    /**
     * Sets holderName
     *
     * @param string|null $holderName The name of the card holder.
     *
     * @return self
     */
    public function setHolderName($holderName)
    {
        $this->container['holderName'] = $holderName;

        return $this;
    }

    /**
     * Gets issuer
     *
     * @return string
     */
    public function getIssuer()
    {
        return $this->container['issuer'];
    }

    /**
     * Sets issuer
     *
     * @param string $issuer The PayByBank issuer value of the shopper's selected bank.
     *
     * @return self
     */
    public function setIssuer($issuer)
    {
        $this->container['issuer'] = $issuer;

        return $this;
    }

    /**
     * Gets blikCode
     *
     * @return string|null
     */
    public function getBlikCode()
    {
        return $this->container['blikCode'];
    }

    /**
     * Sets blikCode
     *
     * @param string|null $blikCode BLIK code consisting of 6 digits.
     *
     * @return self
     */
    public function setBlikCode($blikCode)
    {
        $this->container['blikCode'] = $blikCode;

        return $this;
    }

    /**
     * Gets brand
     *
     * @return string|null
     */
    public function getBrand()
    {
        return $this->container['brand'];
    }

    /**
     * Sets brand
     *
     * @param string|null $brand Secondary brand of the card. For example: **plastix**, **hmclub**.
     *
     * @return self
     */
    public function setBrand($brand)
    {
        $this->container['brand'] = $brand;

        return $this;
    }

    /**
     * Gets cupsecureplusSmscode
     *
     * @return string|null
     * @deprecated
     */
    public function getCupsecureplusSmscode()
    {
        return $this->container['cupsecureplusSmscode'];
    }

    /**
     * Sets cupsecureplusSmscode
     *
     * @param string|null $cupsecureplusSmscode cupsecureplusSmscode
     *
     * @return self
     * @deprecated
     */
    public function setCupsecureplusSmscode($cupsecureplusSmscode)
    {
        $this->container['cupsecureplusSmscode'] = $cupsecureplusSmscode;

        return $this;
    }

    /**
     * Gets cvc
     *
     * @return string|null
     */
    public function getCvc()
    {
        return $this->container['cvc'];
    }

    /**
     * Sets cvc
     *
     * @param string|null $cvc The card verification code. Only collect raw card data if you are [fully PCI compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
     *
     * @return self
     */
    public function setCvc($cvc)
    {
        $this->container['cvc'] = $cvc;

        return $this;
    }

    /**
     * Gets encryptedCard
     *
     * @return string|null
     */
    public function getEncryptedCard()
    {
        return $this->container['encryptedCard'];
    }

    /**
     * Sets encryptedCard
     *
     * @param string|null $encryptedCard Only include this for JSON Web Encryption (JWE) implementations. The JWE-encrypted card details.
     *
     * @return self
     */
    public function setEncryptedCard($encryptedCard)
    {
        $this->container['encryptedCard'] = $encryptedCard;

        return $this;
    }

    /**
     * Gets encryptedCardNumber
     *
     * @return string|null
     */
    public function getEncryptedCardNumber()
    {
        return $this->container['encryptedCardNumber'];
    }

    /**
     * Sets encryptedCardNumber
     *
     * @param string|null $encryptedCardNumber The encrypted card number.
     *
     * @return self
     */
    public function setEncryptedCardNumber($encryptedCardNumber)
    {
        $this->container['encryptedCardNumber'] = $encryptedCardNumber;

        return $this;
    }

    /**
     * Gets encryptedExpiryMonth
     *
     * @return string|null
     */
    public function getEncryptedExpiryMonth()
    {
        return $this->container['encryptedExpiryMonth'];
    }

    /**
     * Sets encryptedExpiryMonth
     *
     * @param string|null $encryptedExpiryMonth The encrypted card expiry month.
     *
     * @return self
     */
    public function setEncryptedExpiryMonth($encryptedExpiryMonth)
    {
        $this->container['encryptedExpiryMonth'] = $encryptedExpiryMonth;

        return $this;
    }

    /**
     * Gets encryptedExpiryYear
     *
     * @return string|null
     */
    public function getEncryptedExpiryYear()
    {
        return $this->container['encryptedExpiryYear'];
    }

    /**
     * Sets encryptedExpiryYear
     *
     * @param string|null $encryptedExpiryYear The encrypted card expiry year.
     *
     * @return self
     */
    public function setEncryptedExpiryYear($encryptedExpiryYear)
    {
        $this->container['encryptedExpiryYear'] = $encryptedExpiryYear;

        return $this;
    }

    /**
     * Gets encryptedSecurityCode
     *
     * @return string|null
     */
    public function getEncryptedSecurityCode()
    {
        return $this->container['encryptedSecurityCode'];
    }

    /**
     * Sets encryptedSecurityCode
     *
     * @param string|null $encryptedSecurityCode The encrypted card verification code.
     *
     * @return self
     */
    public function setEncryptedSecurityCode($encryptedSecurityCode)
    {
        $this->container['encryptedSecurityCode'] = $encryptedSecurityCode;

        return $this;
    }

    /**
     * Gets expiryMonth
     *
     * @return string|null
     */
    public function getExpiryMonth()
    {
        return $this->container['expiryMonth'];
    }

    /**
     * Sets expiryMonth
     *
     * @param string|null $expiryMonth The card expiry month. Only collect raw card data if you are [fully PCI compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
     *
     * @return self
     */
    public function setExpiryMonth($expiryMonth)
    {
        $this->container['expiryMonth'] = $expiryMonth;

        return $this;
    }

    /**
     * Gets expiryYear
     *
     * @return string|null
     */
    public function getExpiryYear()
    {
        return $this->container['expiryYear'];
    }

    /**
     * Sets expiryYear
     *
     * @param string|null $expiryYear The card expiry year. Only collect raw card data if you are [fully PCI compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
     *
     * @return self
     */
    public function setExpiryYear($expiryYear)
    {
        $this->container['expiryYear'] = $expiryYear;

        return $this;
    }

    /**
     * Gets fastlaneData
     *
     * @return string
     */
    public function getFastlaneData()
    {
        return $this->container['fastlaneData'];
    }

    /**
     * Sets fastlaneData
     *
     * @param string $fastlaneData The encoded fastlane data blob
     *
     * @return self
     */
    public function setFastlaneData($fastlaneData)
    {
        $this->container['fastlaneData'] = $fastlaneData;

        return $this;
    }

    /**
     * Gets networkPaymentReference
     *
     * @return string|null
     */
    public function getNetworkPaymentReference()
    {
        return $this->container['networkPaymentReference'];
    }

    /**
     * Sets networkPaymentReference
     *
     * @param string|null $networkPaymentReference The transaction identifier from card schemes. This is the [`networkTxReference`](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/payments__resParam_additionalData-ResponseAdditionalDataCommon-networkTxReference) from the response to the first payment.
     *
     * @return self
     */
    public function setNetworkPaymentReference($networkPaymentReference)
    {
        $this->container['networkPaymentReference'] = $networkPaymentReference;

        return $this;
    }

    /**
     * Gets number
     *
     * @return string|null
     */
    public function getNumber()
    {
        return $this->container['number'];
    }

    /**
     * Sets number
     *
     * @param string|null $number The card number. Only collect raw card data if you are [fully PCI compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
     *
     * @return self
     */
    public function setNumber($number)
    {
        $this->container['number'] = $number;

        return $this;
    }

    /**
     * Gets shopperNotificationReference
     *
     * @return string|null
     */
    public function getShopperNotificationReference()
    {
        return $this->container['shopperNotificationReference'];
    }

    /**
     * Sets shopperNotificationReference
     *
     * @param string|null $shopperNotificationReference The `shopperNotificationReference` returned in the response when you requested to notify the shopper. Used for recurring payment only.
     *
     * @return self
     */
    public function setShopperNotificationReference($shopperNotificationReference)
    {
        $this->container['shopperNotificationReference'] = $shopperNotificationReference;

        return $this;
    }

    /**
     * Gets srcCorrelationId
     *
     * @return string|null
     */
    public function getSrcCorrelationId()
    {
        return $this->container['srcCorrelationId'];
    }

    /**
     * Sets srcCorrelationId
     *
     * @param string|null $srcCorrelationId An identifier used for the Click to Pay transaction.
     *
     * @return self
     */
    public function setSrcCorrelationId($srcCorrelationId)
    {
        $this->container['srcCorrelationId'] = $srcCorrelationId;

        return $this;
    }

    /**
     * Gets srcDigitalCardId
     *
     * @return string|null
     */
    public function getSrcDigitalCardId()
    {
        return $this->container['srcDigitalCardId'];
    }

    /**
     * Sets srcDigitalCardId
     *
     * @param string|null $srcDigitalCardId The SRC reference for the Click to Pay token.
     *
     * @return self
     */
    public function setSrcDigitalCardId($srcDigitalCardId)
    {
        $this->container['srcDigitalCardId'] = $srcDigitalCardId;

        return $this;
    }

    /**
     * Gets srcScheme
     *
     * @return string|null
     */
    public function getSrcScheme()
    {
        return $this->container['srcScheme'];
    }

    /**
     * Sets srcScheme
     *
     * @param string|null $srcScheme The scheme that is being used for Click to Pay.
     *
     * @return self
     */
    public function setSrcScheme($srcScheme)
    {
        $this->container['srcScheme'] = $srcScheme;

        return $this;
    }

    /**
     * Gets srcTokenReference
     *
     * @return string|null
     */
    public function getSrcTokenReference()
    {
        return $this->container['srcTokenReference'];
    }

    /**
     * Sets srcTokenReference
     *
     * @param string|null $srcTokenReference The reference for the Click to Pay token.
     *
     * @return self
     */
    public function setSrcTokenReference($srcTokenReference)
    {
        $this->container['srcTokenReference'] = $srcTokenReference;

        return $this;
    }

    /**
     * Gets threeDS2SdkVersion
     *
     * @return string|null
     */
    public function getThreeDS2SdkVersion()
    {
        return $this->container['threeDS2SdkVersion'];
    }

    /**
     * Sets threeDS2SdkVersion
     *
     * @param string|null $threeDS2SdkVersion Required for mobile integrations. Version of the 3D Secure 2 mobile SDK.
     *
     * @return self
     */
    public function setThreeDS2SdkVersion($threeDS2SdkVersion)
    {
        $this->container['threeDS2SdkVersion'] = $threeDS2SdkVersion;

        return $this;
    }

    /**
     * Gets cashtag
     *
     * @return string|null
     */
    public function getCashtag()
    {
        return $this->container['cashtag'];
    }

    /**
     * Sets cashtag
     *
     * @param string|null $cashtag Cash App issued cashtag for recurring payment
     *
     * @return self
     */
    public function setCashtag($cashtag)
    {
        $this->container['cashtag'] = $cashtag;

        return $this;
    }

    /**
     * Gets customerId
     *
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->container['customerId'];
    }

    /**
     * Sets customerId
     *
     * @param string|null $customerId Cash App issued customerId for recurring payment
     *
     * @return self
     */
    public function setCustomerId($customerId)
    {
        $this->container['customerId'] = $customerId;

        return $this;
    }

    /**
     * Gets grantId
     *
     * @return string|null
     */
    public function getGrantId()
    {
        return $this->container['grantId'];
    }

    /**
     * Sets grantId
     *
     * @param string|null $grantId Cash App issued grantId for one time payment
     *
     * @return self
     */
    public function setGrantId($grantId)
    {
        $this->container['grantId'] = $grantId;

        return $this;
    }

    /**
     * Gets onFileGrantId
     *
     * @return string|null
     */
    public function getOnFileGrantId()
    {
        return $this->container['onFileGrantId'];
    }

    /**
     * Sets onFileGrantId
     *
     * @param string|null $onFileGrantId Cash App issued onFileGrantId for recurring payment
     *
     * @return self
     */
    public function setOnFileGrantId($onFileGrantId)
    {
        $this->container['onFileGrantId'] = $onFileGrantId;

        return $this;
    }

    /**
     * Gets requestId
     *
     * @return string|null
     */
    public function getRequestId()
    {
        return $this->container['requestId'];
    }

    /**
     * Sets requestId
     *
     * @param string|null $requestId Cash App request id
     *
     * @return self
     */
    public function setRequestId($requestId)
    {
        $this->container['requestId'] = $requestId;

        return $this;
    }

    /**
     * Gets subtype
     *
     * @return string|null
     */
    public function getSubtype()
    {
        return $this->container['subtype'];
    }

    /**
     * Sets subtype
     *
     * @param string|null $subtype The type of flow to initiate.
     *
     * @return self
     */
    public function setSubtype($subtype)
    {
        $this->container['subtype'] = $subtype;

        return $this;
    }

    /**
     * Gets firstName
     *
     * @return string
     */
    public function getFirstName()
    {
        return $this->container['firstName'];
    }

    /**
     * Sets firstName
     *
     * @param string $firstName The shopper's first name.
     *
     * @return self
     */
    public function setFirstName($firstName)
    {
        $this->container['firstName'] = $firstName;

        return $this;
    }

    /**
     * Gets lastName
     *
     * @return string
     */
    public function getLastName()
    {
        return $this->container['lastName'];
    }

    /**
     * Sets lastName
     *
     * @param string $lastName The shopper's last name.
     *
     * @return self
     */
    public function setLastName($lastName)
    {
        $this->container['lastName'] = $lastName;

        return $this;
    }

    /**
     * Gets shopperEmail
     *
     * @return string
     */
    public function getShopperEmail()
    {
        return $this->container['shopperEmail'];
    }

    /**
     * Sets shopperEmail
     *
     * @param string $shopperEmail
     *
     * @return self
     */
    public function setShopperEmail($shopperEmail)
    {
        $this->container['shopperEmail'] = $shopperEmail;

        return $this;
    }

    /**
     * Gets telephoneNumber
     *
     * @return string
     */
    public function getTelephoneNumber()
    {
        return $this->container['telephoneNumber'];
    }

    /**
     * Sets telephoneNumber
     *
     * @param string $telephoneNumber
     *
     * @return self
     */
    public function setTelephoneNumber($telephoneNumber)
    {
        $this->container['telephoneNumber'] = $telephoneNumber;

        return $this;
    }

    /**
     * Gets bankCode
     *
     * @return string|null
     */
    public function getBankCode()
    {
        return $this->container['bankCode'];
    }

    /**
     * Sets bankCode
     *
     * @param string|null $bankCode The financial institution code.
     *
     * @return self
     */
    public function setBankCode($bankCode)
    {
        $this->container['bankCode'] = $bankCode;

        return $this;
    }

    /**
     * Gets googlePayCardNetwork
     *
     * @return string|null
     */
    public function getGooglePayCardNetwork()
    {
        return $this->container['googlePayCardNetwork'];
    }

    /**
     * Sets googlePayCardNetwork
     *
     * @param string|null $googlePayCardNetwork The selected payment card network.
     *
     * @return self
     */
    public function setGooglePayCardNetwork($googlePayCardNetwork)
    {
        $this->container['googlePayCardNetwork'] = $googlePayCardNetwork;

        return $this;
    }

    /**
     * Gets googlePayToken
     *
     * @return string
     */
    public function getGooglePayToken()
    {
        return $this->container['googlePayToken'];
    }

    /**
     * Sets googlePayToken
     *
     * @param string $googlePayToken The `token` that you obtained from the [Google Pay API](https://developers.google.com/pay/api/web/reference/response-objects#PaymentData) `PaymentData` response.
     *
     * @return self
     */
    public function setGooglePayToken($googlePayToken)
    {
        $this->container['googlePayToken'] = $googlePayToken;

        return $this;
    }

    /**
     * Gets masterpassTransactionId
     *
     * @return string
     */
    public function getMasterpassTransactionId()
    {
        return $this->container['masterpassTransactionId'];
    }

    /**
     * Sets masterpassTransactionId
     *
     * @param string $masterpassTransactionId The Masterpass transaction ID.
     *
     * @return self
     */
    public function setMasterpassTransactionId($masterpassTransactionId)
    {
        $this->container['masterpassTransactionId'] = $masterpassTransactionId;

        return $this;
    }

    /**
     * Gets orderID
     *
     * @return string|null
     */
    public function getOrderID()
    {
        return $this->container['orderID'];
    }

    /**
     * Sets orderID
     *
     * @param string|null $orderID The unique ID associated with the order.
     *
     * @return self
     */
    public function setOrderID($orderID)
    {
        $this->container['orderID'] = $orderID;

        return $this;
    }

    /**
     * Gets payeePreferred
     *
     * @return string|null
     */
    public function getPayeePreferred()
    {
        return $this->container['payeePreferred'];
    }

    /**
     * Sets payeePreferred
     *
     * @param string|null $payeePreferred IMMEDIATE_PAYMENT_REQUIRED or UNRESTRICTED
     *
     * @return self
     */
    public function setPayeePreferred($payeePreferred)
    {
        $this->container['payeePreferred'] = $payeePreferred;

        return $this;
    }

    /**
     * Gets payerID
     *
     * @return string|null
     */
    public function getPayerID()
    {
        return $this->container['payerID'];
    }

    /**
     * Sets payerID
     *
     * @param string|null $payerID The unique ID associated with the payer.
     *
     * @return self
     */
    public function setPayerID($payerID)
    {
        $this->container['payerID'] = $payerID;

        return $this;
    }

    /**
     * Gets payerSelected
     *
     * @return string|null
     */
    public function getPayerSelected()
    {
        return $this->container['payerSelected'];
    }

    /**
     * Sets payerSelected
     *
     * @param string|null $payerSelected PAYPAL or PAYPAL_CREDIT
     *
     * @return self
     */
    public function setPayerSelected($payerSelected)
    {
        $this->container['payerSelected'] = $payerSelected;

        return $this;
    }

    /**
     * Gets shopperAccountIdentifier
     *
     * @return string|null
     */
    public function getShopperAccountIdentifier()
    {
        return $this->container['shopperAccountIdentifier'];
    }

    /**
     * Sets shopperAccountIdentifier
     *
     * @param string|null $shopperAccountIdentifier The shopper's banking details or payId reference, used to complete payment.
     *
     * @return self
     */
    public function setShopperAccountIdentifier($shopperAccountIdentifier)
    {
        $this->container['shopperAccountIdentifier'] = $shopperAccountIdentifier;

        return $this;
    }

    /**
     * Gets virtualPaymentAddress
     *
     * @return string|null
     */
    public function getVirtualPaymentAddress()
    {
        return $this->container['virtualPaymentAddress'];
    }

    /**
     * Sets virtualPaymentAddress
     *
     * @param string|null $virtualPaymentAddress The virtual payment address for UPI.
     *
     * @return self
     */
    public function setVirtualPaymentAddress($virtualPaymentAddress)
    {
        $this->container['virtualPaymentAddress'] = $virtualPaymentAddress;

        return $this;
    }

    /**
     * Gets pixRecurring
     *
     * @return \Adyen\Model\Checkout\PixRecurring|null
     */
    public function getPixRecurring()
    {
        return $this->container['pixRecurring'];
    }

    /**
     * Sets pixRecurring
     *
     * @param \Adyen\Model\Checkout\PixRecurring|null $pixRecurring pixRecurring
     *
     * @return self
     */
    public function setPixRecurring($pixRecurring)
    {
        $this->container['pixRecurring'] = $pixRecurring;

        return $this;
    }

    /**
     * Gets bank
     *
     * @return string
     */
    public function getBank()
    {
        return $this->container['bank'];
    }

    /**
     * Sets bank
     *
     * @param string $bank The shopper's bank.
     *
     * @return self
     */
    public function setBank($bank)
    {
        $this->container['bank'] = $bank;

        return $this;
    }

    /**
     * Gets clientType
     *
     * @return string
     */
    public function getClientType()
    {
        return $this->container['clientType'];
    }

    /**
     * Sets clientType
     *
     * @param string $clientType The client type.
     *
     * @return self
     */
    public function setClientType($clientType)
    {
        $this->container['clientType'] = $clientType;

        return $this;
    }

    /**
     * Gets identification
     *
     * @return string
     */
    public function getIdentification()
    {
        return $this->container['identification'];
    }

    /**
     * Sets identification
     *
     * @param string $identification The identification code.
     *
     * @return self
     */
    public function setIdentification($identification)
    {
        $this->container['identification'] = $identification;

        return $this;
    }

    /**
     * Gets identificationType
     *
     * @return string
     */
    public function getIdentificationType()
    {
        return $this->container['identificationType'];
    }

    /**
     * Sets identificationType
     *
     * @param string $identificationType The identification type.
     *
     * @return self
     */
    public function setIdentificationType($identificationType)
    {
        $this->container['identificationType'] = $identificationType;

        return $this;
    }

    /**
     * Gets deviceFingerprint
     *
     * @return string|null
     */
    public function getDeviceFingerprint()
    {
        return $this->container['deviceFingerprint'];
    }

    /**
     * Sets deviceFingerprint
     *
     * @param string|null $deviceFingerprint A string containing the shopper's device fingerprint. For more information, refer to [Device fingerprinting](https://docs.adyen.com/risk-management/device-fingerprinting).
     *
     * @return self
     */
    public function setDeviceFingerprint($deviceFingerprint)
    {
        $this->container['deviceFingerprint'] = $deviceFingerprint;

        return $this;
    }

    /**
     * Gets iban
     *
     * @return string
     */
    public function getIban()
    {
        return $this->container['iban'];
    }

    /**
     * Sets iban
     *
     * @param string $iban The International Bank Account Number (IBAN).
     *
     * @return self
     */
    public function setIban($iban)
    {
        $this->container['iban'] = $iban;

        return $this;
    }

    /**
     * Gets samsungPayToken
     *
     * @return string
     */
    public function getSamsungPayToken()
    {
        return $this->container['samsungPayToken'];
    }

    /**
     * Sets samsungPayToken
     *
     * @param string $samsungPayToken The payload you received from the Samsung Pay SDK response.
     *
     * @return self
     */
    public function setSamsungPayToken($samsungPayToken)
    {
        $this->container['samsungPayToken'] = $samsungPayToken;

        return $this;
    }

    /**
     * Gets billingSequenceNumber
     *
     * @return string
     */
    public function getBillingSequenceNumber()
    {
        return $this->container['billingSequenceNumber'];
    }

    /**
     * Sets billingSequenceNumber
     *
     * @param string $billingSequenceNumber The sequence number for the debit. For example, send **2** if this is the second debit for the subscription. The sequence number is included in the notification sent to the shopper.
     *
     * @return self
     */
    public function setBillingSequenceNumber($billingSequenceNumber)
    {
        $this->container['billingSequenceNumber'] = $billingSequenceNumber;

        return $this;
    }

    /**
     * Gets appId
     *
     * @return string|null
     */
    public function getAppId()
    {
        return $this->container['appId'];
    }

    /**
     * Sets appId
     *
     * @param string|null $appId appId
     *
     * @return self
     */
    public function setAppId($appId)
    {
        $this->container['appId'] = $appId;

        return $this;
    }

    /**
     * Gets visaCheckoutCallId
     *
     * @return string
     */
    public function getVisaCheckoutCallId()
    {
        return $this->container['visaCheckoutCallId'];
    }

    /**
     * Sets visaCheckoutCallId
     *
     * @param string $visaCheckoutCallId The Visa Click to Pay Call ID value. When your shopper selects a payment and/or a shipping address from Visa Click to Pay, you will receive a Visa Click to Pay Call ID.
     *
     * @return self
     */
    public function setVisaCheckoutCallId($visaCheckoutCallId)
    {
        $this->container['visaCheckoutCallId'] = $visaCheckoutCallId;

        return $this;
    }

    /**
     * Gets openid
     *
     * @return string|null
     */
    public function getOpenid()
    {
        return $this->container['openid'];
    }

    /**
     * Sets openid
     *
     * @param string|null $openid openid
     *
     * @return self
     */
    public function setOpenid($openid)
    {
        $this->container['openid'] = $openid;

        return $this;
    }

    /**
     * Gets clickAndCollect
     *
     * @return string|null
     */
    public function getClickAndCollect()
    {
        return $this->container['clickAndCollect'];
    }

    /**
     * Sets clickAndCollect
     *
     * @param string|null $clickAndCollect Set this to **true** if the shopper would like to pick up and collect their order, instead of having the goods delivered to them.
     *
     * @return self
     */
    public function setClickAndCollect($clickAndCollect)
    {
        $this->container['clickAndCollect'] = $clickAndCollect;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    public function toArray(): array
    {
        $array = [];
        foreach (self::$openAPITypes as $propertyName => $propertyType) {
            $propertyValue = $this[$propertyName];
            if ($propertyValue !== null) {
                // Check if the property value is an object and has a toArray() method
                if (is_object($propertyValue) && method_exists($propertyValue, 'toArray')) {
                    $array[$propertyName] = $propertyValue->toArray();
                // Check if it's type datetime
                } elseif ($propertyValue instanceof \DateTime) {
                    $array[$propertyName] = $propertyValue->format(DATE_ATOM);
                // If it's an array type we should check whether it contains objects and if so call toArray method
                } elseif (is_array($propertyValue)) {
                    $array[$propertyName] = array_map(function ($item) {
                        return $item instanceof ModelInterface ? $item->toArray() : $item;
                    }, $propertyValue);
                } else {
                    // Otherwise, directly assign the property value to the array
                    $array[$propertyName] = $propertyValue;
                }
            }
        }
        return $array;
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}
