<?php

namespace PaymentWebhooks\Infrastructure;

final class Config
{
    private static bool $loaded = false;
    private static array $store = [];

    public static function load(): void
    {
        if (self::$loaded) {
            return;
        }

        if (function_exists('get_fields')) {
            $allFields = get_fields('option');
            if (is_array($allFields)) {
                self::$store = array_filter(
                    $allFields,
                    fn ($k) => str_starts_with($k, 'PW_'),
                    ARRAY_FILTER_USE_KEY
                );
            }
        }
        self::$loaded = true;
    }

    public static function get(string $key, $default = null)
    {
        self::load();
        return self::$store[$key] ?? $default;
    }

    public static function gateway(string $gateway): array
    {
        $path = dirname(__DIR__, 2) . '/config/' . strtolower($gateway) . '.php';
        return file_exists($path) ? include $path : [];
    }
}
