<?php

namespace PaymentWebhooks\Gateway\Common;

use PaymentWebhooks\Contract\OrderIdResolverInterface;
use PaymentWebhooks\Infrastructure\Config;

class CommonOrderIdResolver implements OrderIdResolverInterface
{
    public function __construct(private string $gateway)
    {
    }

    public function resolve(array $payload): ?int
    {
        $path = Config::gateway($this->gateway)['json_fields']['order_id'] ?? null;

        if (!$path) {
            return null;
        }

        $value = PayloadHelper::getByPath($payload, $path);

        return (is_string($value) && ctype_digit($value)) ? (int)$value : null;
    }

}
