<?php

namespace PaymentWebhooks\Application;

use PaymentWebhooks\Core\AsynchronousOrderUpdater;
use PaymentWebhooks\Infrastructure\Config;
use WP_REST_Request;
use WP_REST_Response;

class Plugin
{
    public static function init(): void
    {
        add_action('acf/init', [Config::class, 'load'], 99);
        add_action('rest_api_init', [self::class, 'registerRoutes']);
        add_action('acf/init', [self::class, 'initUpdaters'], 100);
    }

    public static function initUpdaters(): void
    {
        if (Config::get('PW_ASYNC_UPDATE', false)) {
            foreach (['adyen', 'paypal'] as $gateway) {
                new AsynchronousOrderUpdater($gateway);
            }
        }
    }

    public static function registerRoutes(): void
    {
        register_rest_route(
            'payments/v1',
            '/(?P<gateway>[a-z]+)/payment-status',
            [
                'methods'             => 'POST',
                'callback'            => [WebhookController::class, 'handle'],
                'permission_callback' => '__return_true',
            ]
        );
    }
}
