<?php

namespace PaymentWebhooks\Application\Admin;

use PaymentWebhooks\Contract\WordPress\HookableInterface;

final class SettingsNotice implements HookableInterface
{
    private array $requiredKeys = [
        'PW_ADYEN_USER',
        'PW_ADYEN_PASS',
        'PW_ADYEN_HMAC_KEY',
        'PW_PAYPAL_WEBHOOK_ID',
        'PW_PAYPAL_CERT_FOLDER_NAME',
    ];

    public function hooks(): void
    {
        add_action('admin_notices', [$this, 'outputNotice']);
    }

    public function outputNotice(): void
    {
        if (!current_user_can('manage_options')) {
            return;
        }

        $config = get_fields('option') ?? [];

        if (!is_array($config)) {
            $config = [];
        }

        $missing = array_filter(
            $this->requiredKeys,
            static fn ($key) => empty($config[$key])
        );

        if (!$missing) {
            return;
        }

        printf(
            '<div class="notice notice-error"><p>%s</p></div>',
            sprintf(
                /* translators: %s: list of option keys */
                esc_html__('Payment Webhooks: fill required fields: %s', 'payment-webhooks'),
                implode(', ', array_map('esc_html', $missing))
            )
        );
    }
}
