<?php

/**
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Adyen\Model\Checkout;

use \ArrayAccess;
use Adyen\Model\Checkout\ObjectSerializer;

/**
 * PaymentLinkResponse Class Doc Comment
 *
 * @category Class
 * @package  Adyen
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PaymentLinkResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PaymentLinkResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'allowedPaymentMethods' => 'string[]',
        'amount' => '\Adyen\Model\Checkout\Amount',
        'applicationInfo' => '\Adyen\Model\Checkout\ApplicationInfo',
        'billingAddress' => '\Adyen\Model\Checkout\Address',
        'blockedPaymentMethods' => 'string[]',
        'captureDelayHours' => 'int',
        'countryCode' => 'string',
        'dateOfBirth' => '\DateTime',
        'deliverAt' => '\DateTime',
        'deliveryAddress' => '\Adyen\Model\Checkout\Address',
        'description' => 'string',
        'expiresAt' => '\DateTime',
        'fundOrigin' => '\Adyen\Model\Checkout\FundOrigin',
        'fundRecipient' => '\Adyen\Model\Checkout\FundRecipient',
        'id' => 'string',
        'installmentOptions' => 'array<string,\Adyen\Model\Checkout\InstallmentOption>',
        'lineItems' => '\Adyen\Model\Checkout\LineItem[]',
        'manualCapture' => 'bool',
        'mcc' => 'string',
        'merchantAccount' => 'string',
        'merchantOrderReference' => 'string',
        'metadata' => 'array<string,string>',
        'platformChargebackLogic' => '\Adyen\Model\Checkout\PlatformChargebackLogic',
        'recurringProcessingModel' => 'string',
        'reference' => 'string',
        'requiredShopperFields' => 'string[]',
        'returnUrl' => 'string',
        'reusable' => 'bool',
        'riskData' => '\Adyen\Model\Checkout\RiskData',
        'shopperEmail' => 'string',
        'shopperLocale' => 'string',
        'shopperName' => '\Adyen\Model\Checkout\Name',
        'shopperReference' => 'string',
        'shopperStatement' => 'string',
        'showRemovePaymentMethodButton' => 'bool',
        'socialSecurityNumber' => 'string',
        'splitCardFundingSources' => 'bool',
        'splits' => '\Adyen\Model\Checkout\Split[]',
        'status' => 'string',
        'store' => 'string',
        'storePaymentMethodMode' => 'string',
        'telephoneNumber' => 'string',
        'themeId' => 'string',
        'threeDS2RequestData' => '\Adyen\Model\Checkout\CheckoutSessionThreeDS2RequestData',
        'updatedAt' => '\DateTime',
        'url' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'allowedPaymentMethods' => null,
        'amount' => null,
        'applicationInfo' => null,
        'billingAddress' => null,
        'blockedPaymentMethods' => null,
        'captureDelayHours' => 'int32',
        'countryCode' => null,
        'dateOfBirth' => 'date',
        'deliverAt' => 'date-time',
        'deliveryAddress' => null,
        'description' => null,
        'expiresAt' => 'date-time',
        'fundOrigin' => null,
        'fundRecipient' => null,
        'id' => null,
        'installmentOptions' => null,
        'lineItems' => null,
        'manualCapture' => null,
        'mcc' => null,
        'merchantAccount' => null,
        'merchantOrderReference' => null,
        'metadata' => null,
        'platformChargebackLogic' => null,
        'recurringProcessingModel' => null,
        'reference' => null,
        'requiredShopperFields' => null,
        'returnUrl' => null,
        'reusable' => null,
        'riskData' => null,
        'shopperEmail' => null,
        'shopperLocale' => null,
        'shopperName' => null,
        'shopperReference' => null,
        'shopperStatement' => null,
        'showRemovePaymentMethodButton' => null,
        'socialSecurityNumber' => null,
        'splitCardFundingSources' => null,
        'splits' => null,
        'status' => null,
        'store' => null,
        'storePaymentMethodMode' => null,
        'telephoneNumber' => null,
        'themeId' => null,
        'threeDS2RequestData' => null,
        'updatedAt' => 'date-time',
        'url' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'allowedPaymentMethods' => false,
        'amount' => false,
        'applicationInfo' => false,
        'billingAddress' => false,
        'blockedPaymentMethods' => false,
        'captureDelayHours' => true,
        'countryCode' => false,
        'dateOfBirth' => false,
        'deliverAt' => false,
        'deliveryAddress' => false,
        'description' => false,
        'expiresAt' => false,
        'fundOrigin' => false,
        'fundRecipient' => false,
        'id' => false,
        'installmentOptions' => false,
        'lineItems' => false,
        'manualCapture' => false,
        'mcc' => false,
        'merchantAccount' => false,
        'merchantOrderReference' => false,
        'metadata' => false,
        'platformChargebackLogic' => false,
        'recurringProcessingModel' => false,
        'reference' => false,
        'requiredShopperFields' => false,
        'returnUrl' => false,
        'reusable' => false,
        'riskData' => false,
        'shopperEmail' => false,
        'shopperLocale' => false,
        'shopperName' => false,
        'shopperReference' => false,
        'shopperStatement' => false,
        'showRemovePaymentMethodButton' => false,
        'socialSecurityNumber' => false,
        'splitCardFundingSources' => false,
        'splits' => false,
        'status' => false,
        'store' => false,
        'storePaymentMethodMode' => false,
        'telephoneNumber' => false,
        'themeId' => false,
        'threeDS2RequestData' => false,
        'updatedAt' => false,
        'url' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'allowedPaymentMethods' => 'allowedPaymentMethods',
        'amount' => 'amount',
        'applicationInfo' => 'applicationInfo',
        'billingAddress' => 'billingAddress',
        'blockedPaymentMethods' => 'blockedPaymentMethods',
        'captureDelayHours' => 'captureDelayHours',
        'countryCode' => 'countryCode',
        'dateOfBirth' => 'dateOfBirth',
        'deliverAt' => 'deliverAt',
        'deliveryAddress' => 'deliveryAddress',
        'description' => 'description',
        'expiresAt' => 'expiresAt',
        'fundOrigin' => 'fundOrigin',
        'fundRecipient' => 'fundRecipient',
        'id' => 'id',
        'installmentOptions' => 'installmentOptions',
        'lineItems' => 'lineItems',
        'manualCapture' => 'manualCapture',
        'mcc' => 'mcc',
        'merchantAccount' => 'merchantAccount',
        'merchantOrderReference' => 'merchantOrderReference',
        'metadata' => 'metadata',
        'platformChargebackLogic' => 'platformChargebackLogic',
        'recurringProcessingModel' => 'recurringProcessingModel',
        'reference' => 'reference',
        'requiredShopperFields' => 'requiredShopperFields',
        'returnUrl' => 'returnUrl',
        'reusable' => 'reusable',
        'riskData' => 'riskData',
        'shopperEmail' => 'shopperEmail',
        'shopperLocale' => 'shopperLocale',
        'shopperName' => 'shopperName',
        'shopperReference' => 'shopperReference',
        'shopperStatement' => 'shopperStatement',
        'showRemovePaymentMethodButton' => 'showRemovePaymentMethodButton',
        'socialSecurityNumber' => 'socialSecurityNumber',
        'splitCardFundingSources' => 'splitCardFundingSources',
        'splits' => 'splits',
        'status' => 'status',
        'store' => 'store',
        'storePaymentMethodMode' => 'storePaymentMethodMode',
        'telephoneNumber' => 'telephoneNumber',
        'themeId' => 'themeId',
        'threeDS2RequestData' => 'threeDS2RequestData',
        'updatedAt' => 'updatedAt',
        'url' => 'url'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'allowedPaymentMethods' => 'setAllowedPaymentMethods',
        'amount' => 'setAmount',
        'applicationInfo' => 'setApplicationInfo',
        'billingAddress' => 'setBillingAddress',
        'blockedPaymentMethods' => 'setBlockedPaymentMethods',
        'captureDelayHours' => 'setCaptureDelayHours',
        'countryCode' => 'setCountryCode',
        'dateOfBirth' => 'setDateOfBirth',
        'deliverAt' => 'setDeliverAt',
        'deliveryAddress' => 'setDeliveryAddress',
        'description' => 'setDescription',
        'expiresAt' => 'setExpiresAt',
        'fundOrigin' => 'setFundOrigin',
        'fundRecipient' => 'setFundRecipient',
        'id' => 'setId',
        'installmentOptions' => 'setInstallmentOptions',
        'lineItems' => 'setLineItems',
        'manualCapture' => 'setManualCapture',
        'mcc' => 'setMcc',
        'merchantAccount' => 'setMerchantAccount',
        'merchantOrderReference' => 'setMerchantOrderReference',
        'metadata' => 'setMetadata',
        'platformChargebackLogic' => 'setPlatformChargebackLogic',
        'recurringProcessingModel' => 'setRecurringProcessingModel',
        'reference' => 'setReference',
        'requiredShopperFields' => 'setRequiredShopperFields',
        'returnUrl' => 'setReturnUrl',
        'reusable' => 'setReusable',
        'riskData' => 'setRiskData',
        'shopperEmail' => 'setShopperEmail',
        'shopperLocale' => 'setShopperLocale',
        'shopperName' => 'setShopperName',
        'shopperReference' => 'setShopperReference',
        'shopperStatement' => 'setShopperStatement',
        'showRemovePaymentMethodButton' => 'setShowRemovePaymentMethodButton',
        'socialSecurityNumber' => 'setSocialSecurityNumber',
        'splitCardFundingSources' => 'setSplitCardFundingSources',
        'splits' => 'setSplits',
        'status' => 'setStatus',
        'store' => 'setStore',
        'storePaymentMethodMode' => 'setStorePaymentMethodMode',
        'telephoneNumber' => 'setTelephoneNumber',
        'themeId' => 'setThemeId',
        'threeDS2RequestData' => 'setThreeDS2RequestData',
        'updatedAt' => 'setUpdatedAt',
        'url' => 'setUrl'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'allowedPaymentMethods' => 'getAllowedPaymentMethods',
        'amount' => 'getAmount',
        'applicationInfo' => 'getApplicationInfo',
        'billingAddress' => 'getBillingAddress',
        'blockedPaymentMethods' => 'getBlockedPaymentMethods',
        'captureDelayHours' => 'getCaptureDelayHours',
        'countryCode' => 'getCountryCode',
        'dateOfBirth' => 'getDateOfBirth',
        'deliverAt' => 'getDeliverAt',
        'deliveryAddress' => 'getDeliveryAddress',
        'description' => 'getDescription',
        'expiresAt' => 'getExpiresAt',
        'fundOrigin' => 'getFundOrigin',
        'fundRecipient' => 'getFundRecipient',
        'id' => 'getId',
        'installmentOptions' => 'getInstallmentOptions',
        'lineItems' => 'getLineItems',
        'manualCapture' => 'getManualCapture',
        'mcc' => 'getMcc',
        'merchantAccount' => 'getMerchantAccount',
        'merchantOrderReference' => 'getMerchantOrderReference',
        'metadata' => 'getMetadata',
        'platformChargebackLogic' => 'getPlatformChargebackLogic',
        'recurringProcessingModel' => 'getRecurringProcessingModel',
        'reference' => 'getReference',
        'requiredShopperFields' => 'getRequiredShopperFields',
        'returnUrl' => 'getReturnUrl',
        'reusable' => 'getReusable',
        'riskData' => 'getRiskData',
        'shopperEmail' => 'getShopperEmail',
        'shopperLocale' => 'getShopperLocale',
        'shopperName' => 'getShopperName',
        'shopperReference' => 'getShopperReference',
        'shopperStatement' => 'getShopperStatement',
        'showRemovePaymentMethodButton' => 'getShowRemovePaymentMethodButton',
        'socialSecurityNumber' => 'getSocialSecurityNumber',
        'splitCardFundingSources' => 'getSplitCardFundingSources',
        'splits' => 'getSplits',
        'status' => 'getStatus',
        'store' => 'getStore',
        'storePaymentMethodMode' => 'getStorePaymentMethodMode',
        'telephoneNumber' => 'getTelephoneNumber',
        'themeId' => 'getThemeId',
        'threeDS2RequestData' => 'getThreeDS2RequestData',
        'updatedAt' => 'getUpdatedAt',
        'url' => 'getUrl'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const RECURRING_PROCESSING_MODEL_CARD_ON_FILE = 'CardOnFile';
    public const RECURRING_PROCESSING_MODEL_SUBSCRIPTION = 'Subscription';
    public const RECURRING_PROCESSING_MODEL_UNSCHEDULED_CARD_ON_FILE = 'UnscheduledCardOnFile';
    public const REQUIRED_SHOPPER_FIELDS_BILLING_ADDRESS = 'billingAddress';
    public const REQUIRED_SHOPPER_FIELDS_DELIVERY_ADDRESS = 'deliveryAddress';
    public const REQUIRED_SHOPPER_FIELDS_SHOPPER_EMAIL = 'shopperEmail';
    public const REQUIRED_SHOPPER_FIELDS_SHOPPER_NAME = 'shopperName';
    public const REQUIRED_SHOPPER_FIELDS_TELEPHONE_NUMBER = 'telephoneNumber';
    public const STATUS_ACTIVE = 'active';
    public const STATUS_COMPLETED = 'completed';
    public const STATUS_EXPIRED = 'expired';
    public const STATUS_PAID = 'paid';
    public const STATUS_PAYMENT_PENDING = 'paymentPending';
    public const STORE_PAYMENT_METHOD_MODE_ASK_FOR_CONSENT = 'askForConsent';
    public const STORE_PAYMENT_METHOD_MODE_DISABLED = 'disabled';
    public const STORE_PAYMENT_METHOD_MODE_ENABLED = 'enabled';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getRecurringProcessingModelAllowableValues()
    {
        return [
            self::RECURRING_PROCESSING_MODEL_CARD_ON_FILE,
            self::RECURRING_PROCESSING_MODEL_SUBSCRIPTION,
            self::RECURRING_PROCESSING_MODEL_UNSCHEDULED_CARD_ON_FILE,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getRequiredShopperFieldsAllowableValues()
    {
        return [
            self::REQUIRED_SHOPPER_FIELDS_BILLING_ADDRESS,
            self::REQUIRED_SHOPPER_FIELDS_DELIVERY_ADDRESS,
            self::REQUIRED_SHOPPER_FIELDS_SHOPPER_EMAIL,
            self::REQUIRED_SHOPPER_FIELDS_SHOPPER_NAME,
            self::REQUIRED_SHOPPER_FIELDS_TELEPHONE_NUMBER,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_ACTIVE,
            self::STATUS_COMPLETED,
            self::STATUS_EXPIRED,
            self::STATUS_PAID,
            self::STATUS_PAYMENT_PENDING,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStorePaymentMethodModeAllowableValues()
    {
        return [
            self::STORE_PAYMENT_METHOD_MODE_ASK_FOR_CONSENT,
            self::STORE_PAYMENT_METHOD_MODE_DISABLED,
            self::STORE_PAYMENT_METHOD_MODE_ENABLED,
        ];
    }
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('allowedPaymentMethods', $data ?? [], null);
        $this->setIfExists('amount', $data ?? [], null);
        $this->setIfExists('applicationInfo', $data ?? [], null);
        $this->setIfExists('billingAddress', $data ?? [], null);
        $this->setIfExists('blockedPaymentMethods', $data ?? [], null);
        $this->setIfExists('captureDelayHours', $data ?? [], null);
        $this->setIfExists('countryCode', $data ?? [], null);
        $this->setIfExists('dateOfBirth', $data ?? [], null);
        $this->setIfExists('deliverAt', $data ?? [], null);
        $this->setIfExists('deliveryAddress', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('expiresAt', $data ?? [], null);
        $this->setIfExists('fundOrigin', $data ?? [], null);
        $this->setIfExists('fundRecipient', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('installmentOptions', $data ?? [], null);
        $this->setIfExists('lineItems', $data ?? [], null);
        $this->setIfExists('manualCapture', $data ?? [], null);
        $this->setIfExists('mcc', $data ?? [], null);
        $this->setIfExists('merchantAccount', $data ?? [], null);
        $this->setIfExists('merchantOrderReference', $data ?? [], null);
        $this->setIfExists('metadata', $data ?? [], null);
        $this->setIfExists('platformChargebackLogic', $data ?? [], null);
        $this->setIfExists('recurringProcessingModel', $data ?? [], null);
        $this->setIfExists('reference', $data ?? [], null);
        $this->setIfExists('requiredShopperFields', $data ?? [], null);
        $this->setIfExists('returnUrl', $data ?? [], null);
        $this->setIfExists('reusable', $data ?? [], null);
        $this->setIfExists('riskData', $data ?? [], null);
        $this->setIfExists('shopperEmail', $data ?? [], null);
        $this->setIfExists('shopperLocale', $data ?? [], null);
        $this->setIfExists('shopperName', $data ?? [], null);
        $this->setIfExists('shopperReference', $data ?? [], null);
        $this->setIfExists('shopperStatement', $data ?? [], null);
        $this->setIfExists('showRemovePaymentMethodButton', $data ?? [], null);
        $this->setIfExists('socialSecurityNumber', $data ?? [], null);
        $this->setIfExists('splitCardFundingSources', $data ?? [], null);
        $this->setIfExists('splits', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('store', $data ?? [], null);
        $this->setIfExists('storePaymentMethodMode', $data ?? [], null);
        $this->setIfExists('telephoneNumber', $data ?? [], null);
        $this->setIfExists('themeId', $data ?? [], null);
        $this->setIfExists('threeDS2RequestData', $data ?? [], null);
        $this->setIfExists('updatedAt', $data ?? [], null);
        $this->setIfExists('url', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['amount'] === null) {
            $invalidProperties[] = "'amount' can't be null";
        }
        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['merchantAccount'] === null) {
            $invalidProperties[] = "'merchantAccount' can't be null";
        }
        $allowedValues = $this->getRecurringProcessingModelAllowableValues();
        if (!is_null($this->container['recurringProcessingModel']) && !in_array($this->container['recurringProcessingModel'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'recurringProcessingModel', must be one of '%s'",
                $this->container['recurringProcessingModel'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['reference'] === null) {
            $invalidProperties[] = "'reference' can't be null";
        }
        if ($this->container['status'] === null) {
            $invalidProperties[] = "'status' can't be null";
        }
        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($this->container['status']) && !in_array($this->container['status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'status', must be one of '%s'",
                $this->container['status'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getStorePaymentMethodModeAllowableValues();
        if (!is_null($this->container['storePaymentMethodMode']) && !in_array($this->container['storePaymentMethodMode'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'storePaymentMethodMode', must be one of '%s'",
                $this->container['storePaymentMethodMode'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['url'] === null) {
            $invalidProperties[] = "'url' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets allowedPaymentMethods
     *
     * @return string[]|null
     */
    public function getAllowedPaymentMethods()
    {
        return $this->container['allowedPaymentMethods'];
    }

    /**
     * Sets allowedPaymentMethods
     *
     * @param string[]|null $allowedPaymentMethods List of payment methods to be presented to the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: `\"allowedPaymentMethods\":[\"ideal\",\"giropay\"]`
     *
     * @return self
     */
    public function setAllowedPaymentMethods($allowedPaymentMethods)
    {
        $this->container['allowedPaymentMethods'] = $allowedPaymentMethods;

        return $this;
    }

    /**
     * Gets amount
     *
     * @return \Adyen\Model\Checkout\Amount
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     *
     * @param \Adyen\Model\Checkout\Amount $amount amount
     *
     * @return self
     */
    public function setAmount($amount)
    {
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets applicationInfo
     *
     * @return \Adyen\Model\Checkout\ApplicationInfo|null
     */
    public function getApplicationInfo()
    {
        return $this->container['applicationInfo'];
    }

    /**
     * Sets applicationInfo
     *
     * @param \Adyen\Model\Checkout\ApplicationInfo|null $applicationInfo applicationInfo
     *
     * @return self
     */
    public function setApplicationInfo($applicationInfo)
    {
        $this->container['applicationInfo'] = $applicationInfo;

        return $this;
    }

    /**
     * Gets billingAddress
     *
     * @return \Adyen\Model\Checkout\Address|null
     */
    public function getBillingAddress()
    {
        return $this->container['billingAddress'];
    }

    /**
     * Sets billingAddress
     *
     * @param \Adyen\Model\Checkout\Address|null $billingAddress billingAddress
     *
     * @return self
     */
    public function setBillingAddress($billingAddress)
    {
        $this->container['billingAddress'] = $billingAddress;

        return $this;
    }

    /**
     * Gets blockedPaymentMethods
     *
     * @return string[]|null
     */
    public function getBlockedPaymentMethods()
    {
        return $this->container['blockedPaymentMethods'];
    }

    /**
     * Sets blockedPaymentMethods
     *
     * @param string[]|null $blockedPaymentMethods List of payment methods to be hidden from the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: `\"blockedPaymentMethods\":[\"ideal\",\"giropay\"]`
     *
     * @return self
     */
    public function setBlockedPaymentMethods($blockedPaymentMethods)
    {
        $this->container['blockedPaymentMethods'] = $blockedPaymentMethods;

        return $this;
    }

    /**
     * Gets captureDelayHours
     *
     * @return int|null
     */
    public function getCaptureDelayHours()
    {
        return $this->container['captureDelayHours'];
    }

    /**
     * Sets captureDelayHours
     *
     * @param int|null $captureDelayHours The delay between the authorisation and scheduled auto-capture, specified in hours.
     *
     * @return self
     */
    public function setCaptureDelayHours($captureDelayHours)
    {
        $this->container['captureDelayHours'] = $captureDelayHours;

        return $this;
    }

    /**
     * Gets countryCode
     *
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->container['countryCode'];
    }

    /**
     * Sets countryCode
     *
     * @param string|null $countryCode The shopper's two-letter country code.
     *
     * @return self
     */
    public function setCountryCode($countryCode)
    {
        $this->container['countryCode'] = $countryCode;

        return $this;
    }

    /**
     * Gets dateOfBirth
     *
     * @return \DateTime|null
     */
    public function getDateOfBirth()
    {
        return $this->container['dateOfBirth'];
    }

    /**
     * Sets dateOfBirth
     *
     * @param \DateTime|null $dateOfBirth The shopper's date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD
     *
     * @return self
     */
    public function setDateOfBirth($dateOfBirth)
    {
        $this->container['dateOfBirth'] = $dateOfBirth;

        return $this;
    }

    /**
     * Gets deliverAt
     *
     * @return \DateTime|null
     */
    public function getDeliverAt()
    {
        return $this->container['deliverAt'];
    }

    /**
     * Sets deliverAt
     *
     * @param \DateTime|null $deliverAt The date and time when the purchased goods should be delivered.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.
     *
     * @return self
     */
    public function setDeliverAt($deliverAt)
    {
        $this->container['deliverAt'] = $deliverAt;

        return $this;
    }

    /**
     * Gets deliveryAddress
     *
     * @return \Adyen\Model\Checkout\Address|null
     */
    public function getDeliveryAddress()
    {
        return $this->container['deliveryAddress'];
    }

    /**
     * Sets deliveryAddress
     *
     * @param \Adyen\Model\Checkout\Address|null $deliveryAddress deliveryAddress
     *
     * @return self
     */
    public function setDeliveryAddress($deliveryAddress)
    {
        $this->container['deliveryAddress'] = $deliveryAddress;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description A short description visible on the payment page. Maximum length: 280 characters.
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets expiresAt
     *
     * @return \DateTime|null
     */
    public function getExpiresAt()
    {
        return $this->container['expiresAt'];
    }

    /**
     * Sets expiresAt
     *
     * @param \DateTime|null $expiresAt The date when the payment link expires.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format with time zone offset: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.  The maximum expiry date is 70 days after the payment link is created.  If not provided, the payment link expires 24 hours after it was created.
     *
     * @return self
     */
    public function setExpiresAt($expiresAt)
    {
        $this->container['expiresAt'] = $expiresAt;

        return $this;
    }

    /**
     * Gets fundOrigin
     *
     * @return \Adyen\Model\Checkout\FundOrigin|null
     */
    public function getFundOrigin()
    {
        return $this->container['fundOrigin'];
    }

    /**
     * Sets fundOrigin
     *
     * @param \Adyen\Model\Checkout\FundOrigin|null $fundOrigin fundOrigin
     *
     * @return self
     */
    public function setFundOrigin($fundOrigin)
    {
        $this->container['fundOrigin'] = $fundOrigin;

        return $this;
    }

    /**
     * Gets fundRecipient
     *
     * @return \Adyen\Model\Checkout\FundRecipient|null
     */
    public function getFundRecipient()
    {
        return $this->container['fundRecipient'];
    }

    /**
     * Sets fundRecipient
     *
     * @param \Adyen\Model\Checkout\FundRecipient|null $fundRecipient fundRecipient
     *
     * @return self
     */
    public function setFundRecipient($fundRecipient)
    {
        $this->container['fundRecipient'] = $fundRecipient;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string $id A unique identifier of the payment link.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets installmentOptions
     *
     * @return array<string,\Adyen\Model\Checkout\InstallmentOption>|null
     */
    public function getInstallmentOptions()
    {
        return $this->container['installmentOptions'];
    }

    /**
     * Sets installmentOptions
     *
     * @param array<string,\Adyen\Model\Checkout\InstallmentOption>|null $installmentOptions A set of key-value pairs that specifies the installment options available per payment method. The key must be a payment method name in lowercase. For example, **card** to specify installment options for all cards, or **visa** or **mc**. The value must be an object containing the installment options.
     *
     * @return self
     */
    public function setInstallmentOptions($installmentOptions)
    {
        $this->container['installmentOptions'] = $installmentOptions;

        return $this;
    }

    /**
     * Gets lineItems
     *
     * @return \Adyen\Model\Checkout\LineItem[]|null
     */
    public function getLineItems()
    {
        return $this->container['lineItems'];
    }

    /**
     * Sets lineItems
     *
     * @param \Adyen\Model\Checkout\LineItem[]|null $lineItems Price and product information about the purchased items, to be included on the invoice sent to the shopper. This parameter is required for open invoice (_buy now, pay later_) payment methods such Afterpay, Clearpay, Klarna, RatePay, Riverty, and Zip.
     *
     * @return self
     */
    public function setLineItems($lineItems)
    {
        $this->container['lineItems'] = $lineItems;

        return $this;
    }

    /**
     * Gets manualCapture
     *
     * @return bool|null
     */
    public function getManualCapture()
    {
        return $this->container['manualCapture'];
    }

    /**
     * Sets manualCapture
     *
     * @param bool|null $manualCapture Indicates if the payment must be [captured manually](https://docs.adyen.com/online-payments/capture).
     *
     * @return self
     */
    public function setManualCapture($manualCapture)
    {
        $this->container['manualCapture'] = $manualCapture;

        return $this;
    }

    /**
     * Gets mcc
     *
     * @return string|null
     */
    public function getMcc()
    {
        return $this->container['mcc'];
    }

    /**
     * Sets mcc
     *
     * @param string|null $mcc The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.
     *
     * @return self
     */
    public function setMcc($mcc)
    {
        $this->container['mcc'] = $mcc;

        return $this;
    }

    /**
     * Gets merchantAccount
     *
     * @return string
     */
    public function getMerchantAccount()
    {
        return $this->container['merchantAccount'];
    }

    /**
     * Sets merchantAccount
     *
     * @param string $merchantAccount The merchant account identifier for which the payment link is created.
     *
     * @return self
     */
    public function setMerchantAccount($merchantAccount)
    {
        $this->container['merchantAccount'] = $merchantAccount;

        return $this;
    }

    /**
     * Gets merchantOrderReference
     *
     * @return string|null
     */
    public function getMerchantOrderReference()
    {
        return $this->container['merchantOrderReference'];
    }

    /**
     * Sets merchantOrderReference
     *
     * @param string|null $merchantOrderReference This reference allows linking multiple transactions to each other for reporting purposes (for example, order auth-rate). The reference should be unique per billing cycle.
     *
     * @return self
     */
    public function setMerchantOrderReference($merchantOrderReference)
    {
        $this->container['merchantOrderReference'] = $merchantOrderReference;

        return $this;
    }

    /**
     * Gets metadata
     *
     * @return array<string,string>|null
     */
    public function getMetadata()
    {
        return $this->container['metadata'];
    }

    /**
     * Sets metadata
     *
     * @param array<string,string>|null $metadata Metadata consists of entries, each of which includes a key and a value. Limitations: * Maximum 20 key-value pairs per request. Otherwise, error \"177\" occurs: \"Metadata size exceeds limit\" * Maximum 20 characters per key. Otherwise, error \"178\" occurs: \"Metadata key size exceeds limit\" * A key cannot have the name `checkout.linkId`. Any value that you provide with this key is going to be replaced by the real payment link ID.
     *
     * @return self
     */
    public function setMetadata($metadata)
    {
        $this->container['metadata'] = $metadata;

        return $this;
    }

    /**
     * Gets platformChargebackLogic
     *
     * @return \Adyen\Model\Checkout\PlatformChargebackLogic|null
     */
    public function getPlatformChargebackLogic()
    {
        return $this->container['platformChargebackLogic'];
    }

    /**
     * Sets platformChargebackLogic
     *
     * @param \Adyen\Model\Checkout\PlatformChargebackLogic|null $platformChargebackLogic platformChargebackLogic
     *
     * @return self
     */
    public function setPlatformChargebackLogic($platformChargebackLogic)
    {
        $this->container['platformChargebackLogic'] = $platformChargebackLogic;

        return $this;
    }

    /**
     * Gets recurringProcessingModel
     *
     * @return string|null
     */
    public function getRecurringProcessingModel()
    {
        return $this->container['recurringProcessingModel'];
    }

    /**
     * Sets recurringProcessingModel
     *
     * @param string|null $recurringProcessingModel Defines a recurring payment type. Required when `storePaymentMethodMode` is set to **askForConsent** or **enabled**. Possible values: * **Subscription** – A transaction for a fixed or variable amount, which follows a fixed schedule. * **CardOnFile** – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * **UnscheduledCardOnFile** – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or has variable amounts. For example, automatic top-ups when a cardholder's balance drops below a certain amount.
     *
     * @return self
     */
    public function setRecurringProcessingModel($recurringProcessingModel)
    {
        $allowedValues = $this->getRecurringProcessingModelAllowableValues();
        if (!in_array($recurringProcessingModel, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'recurringProcessingModel', must be one of '%s'",
                    $recurringProcessingModel,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['recurringProcessingModel'] = $recurringProcessingModel;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string $reference A reference that is used to uniquely identify the payment in future communications about the payment status.
     *
     * @return self
     */
    public function setReference($reference)
    {
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets requiredShopperFields
     *
     * @return string[]|null
     */
    public function getRequiredShopperFields()
    {
        return $this->container['requiredShopperFields'];
    }

    /**
     * Sets requiredShopperFields
     *
     * @param string[]|null $requiredShopperFields List of fields that the shopper has to provide on the payment page before completing the payment. For more information, refer to [Provide shopper information](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#shopper-information).  Possible values: * **billingAddress** – The address where to send the invoice. * **deliveryAddress** – The address where the purchased goods should be delivered. * **shopperEmail** – The shopper's email address. * **shopperName** – The shopper's full name. * **telephoneNumber** – The shopper's phone number.
     *
     * @return self
     */
    public function setRequiredShopperFields($requiredShopperFields)
    {
        $allowedValues = $this->getRequiredShopperFieldsAllowableValues();
        if (array_diff($requiredShopperFields, $allowedValues)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'requiredShopperFields', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['requiredShopperFields'] = $requiredShopperFields;

        return $this;
    }

    /**
     * Gets returnUrl
     *
     * @return string|null
     */
    public function getReturnUrl()
    {
        return $this->container['returnUrl'];
    }

    /**
     * Sets returnUrl
     *
     * @param string|null $returnUrl Website URL used for redirection after payment is completed. If provided, a **Continue** button will be shown on the payment page. If shoppers select the button, they are redirected to the specified URL.
     *
     * @return self
     */
    public function setReturnUrl($returnUrl)
    {
        $this->container['returnUrl'] = $returnUrl;

        return $this;
    }

    /**
     * Gets reusable
     *
     * @return bool|null
     */
    public function getReusable()
    {
        return $this->container['reusable'];
    }

    /**
     * Sets reusable
     *
     * @param bool|null $reusable Indicates whether the payment link can be reused for multiple payments. If not provided, this defaults to **false** which means the link can be used for one successful payment only.
     *
     * @return self
     */
    public function setReusable($reusable)
    {
        $this->container['reusable'] = $reusable;

        return $this;
    }

    /**
     * Gets riskData
     *
     * @return \Adyen\Model\Checkout\RiskData|null
     */
    public function getRiskData()
    {
        return $this->container['riskData'];
    }

    /**
     * Sets riskData
     *
     * @param \Adyen\Model\Checkout\RiskData|null $riskData riskData
     *
     * @return self
     */
    public function setRiskData($riskData)
    {
        $this->container['riskData'] = $riskData;

        return $this;
    }

    /**
     * Gets shopperEmail
     *
     * @return string|null
     */
    public function getShopperEmail()
    {
        return $this->container['shopperEmail'];
    }

    /**
     * Sets shopperEmail
     *
     * @param string|null $shopperEmail The shopper's email address.
     *
     * @return self
     */
    public function setShopperEmail($shopperEmail)
    {
        $this->container['shopperEmail'] = $shopperEmail;

        return $this;
    }

    /**
     * Gets shopperLocale
     *
     * @return string|null
     */
    public function getShopperLocale()
    {
        return $this->container['shopperLocale'];
    }

    /**
     * Sets shopperLocale
     *
     * @param string|null $shopperLocale The language to be used in the payment page, specified by a combination of a language and country code. For example, `en-US`.  For a list of shopper locales that Pay by Link supports, refer to [Language and localization](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#language).
     *
     * @return self
     */
    public function setShopperLocale($shopperLocale)
    {
        $this->container['shopperLocale'] = $shopperLocale;

        return $this;
    }

    /**
     * Gets shopperName
     *
     * @return \Adyen\Model\Checkout\Name|null
     */
    public function getShopperName()
    {
        return $this->container['shopperName'];
    }

    /**
     * Sets shopperName
     *
     * @param \Adyen\Model\Checkout\Name|null $shopperName shopperName
     *
     * @return self
     */
    public function setShopperName($shopperName)
    {
        $this->container['shopperName'] = $shopperName;

        return $this;
    }

    /**
     * Gets shopperReference
     *
     * @return string|null
     */
    public function getShopperReference()
    {
        return $this->container['shopperReference'];
    }

    /**
     * Sets shopperReference
     *
     * @param string|null $shopperReference Your reference to uniquely identify this shopper, for example user ID or account ID. The value is case-sensitive and must be at least three characters. > Your reference must not include personally identifiable information (PII) such as name or email address.
     *
     * @return self
     */
    public function setShopperReference($shopperReference)
    {
        $this->container['shopperReference'] = $shopperReference;

        return $this;
    }

    /**
     * Gets shopperStatement
     *
     * @return string|null
     */
    public function getShopperStatement()
    {
        return $this->container['shopperStatement'];
    }

    /**
     * Sets shopperStatement
     *
     * @param string|null $shopperStatement The text to be shown on the shopper's bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , ' _ - ? + * /_**.
     *
     * @return self
     */
    public function setShopperStatement($shopperStatement)
    {
        $this->container['shopperStatement'] = $shopperStatement;

        return $this;
    }

    /**
     * Gets showRemovePaymentMethodButton
     *
     * @return bool|null
     */
    public function getShowRemovePaymentMethodButton()
    {
        return $this->container['showRemovePaymentMethodButton'];
    }

    /**
     * Sets showRemovePaymentMethodButton
     *
     * @param bool|null $showRemovePaymentMethodButton Set to **false** to hide the button that lets the shopper remove a stored payment method.
     *
     * @return self
     */
    public function setShowRemovePaymentMethodButton($showRemovePaymentMethodButton)
    {
        $this->container['showRemovePaymentMethodButton'] = $showRemovePaymentMethodButton;

        return $this;
    }

    /**
     * Gets socialSecurityNumber
     *
     * @return string|null
     */
    public function getSocialSecurityNumber()
    {
        return $this->container['socialSecurityNumber'];
    }

    /**
     * Sets socialSecurityNumber
     *
     * @param string|null $socialSecurityNumber The shopper's social security number.
     *
     * @return self
     */
    public function setSocialSecurityNumber($socialSecurityNumber)
    {
        $this->container['socialSecurityNumber'] = $socialSecurityNumber;

        return $this;
    }

    /**
     * Gets splitCardFundingSources
     *
     * @return bool|null
     */
    public function getSplitCardFundingSources()
    {
        return $this->container['splitCardFundingSources'];
    }

    /**
     * Sets splitCardFundingSources
     *
     * @param bool|null $splitCardFundingSources Boolean value indicating whether the card payment method should be split into separate debit and credit options.
     *
     * @return self
     */
    public function setSplitCardFundingSources($splitCardFundingSources)
    {
        $this->container['splitCardFundingSources'] = $splitCardFundingSources;

        return $this;
    }

    /**
     * Gets splits
     *
     * @return \Adyen\Model\Checkout\Split[]|null
     */
    public function getSplits()
    {
        return $this->container['splits'];
    }

    /**
     * Sets splits
     *
     * @param \Adyen\Model\Checkout\Split[]|null $splits An array of objects specifying how to split a payment when using [Adyen for Platforms](https://docs.adyen.com/platforms/process-payments#providing-split-information), [Classic Platforms integration](https://docs.adyen.com/classic-platforms/processing-payments#providing-split-information), or [Issuing](https://docs.adyen.com/issuing/manage-funds#split).
     *
     * @return self
     */
    public function setSplits($splits)
    {
        $this->container['splits'] = $splits;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string $status Status of the payment link. Possible values: * **active**: The link can be used to make payments. * **expired**: The expiry date for the payment link has passed. Shoppers can no longer use the link to make payments. * **completed**: The shopper completed the payment. * **paymentPending**: The shopper is in the process of making the payment. Applies to payment methods with an asynchronous flow.
     *
     * @return self
     */
    public function setStatus($status)
    {
        $allowedValues = $this->getStatusAllowableValues();
        if (!in_array($status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'status', must be one of '%s'",
                    $status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets store
     *
     * @return string|null
     */
    public function getStore()
    {
        return $this->container['store'];
    }

    /**
     * Sets store
     *
     * @param string|null $store The physical store, for which this payment is processed.
     *
     * @return self
     */
    public function setStore($store)
    {
        $this->container['store'] = $store;

        return $this;
    }

    /**
     * Gets storePaymentMethodMode
     *
     * @return string|null
     */
    public function getStorePaymentMethodMode()
    {
        return $this->container['storePaymentMethodMode'];
    }

    /**
     * Sets storePaymentMethodMode
     *
     * @param string|null $storePaymentMethodMode Indicates if the details of the payment method will be stored for the shopper. Possible values: * **disabled** – No details will be stored (default). * **askForConsent** – If the `shopperReference` is provided, the UI lets the shopper choose if they want their payment details to be stored. * **enabled** – If the `shopperReference` is provided, the details will be stored without asking the shopper for consent.   When set to **askForConsent** or **enabled**, you must also include the `recurringProcessingModel` parameter.
     *
     * @return self
     */
    public function setStorePaymentMethodMode($storePaymentMethodMode)
    {
        $allowedValues = $this->getStorePaymentMethodModeAllowableValues();
        if (!in_array($storePaymentMethodMode, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'storePaymentMethodMode', must be one of '%s'",
                    $storePaymentMethodMode,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['storePaymentMethodMode'] = $storePaymentMethodMode;

        return $this;
    }

    /**
     * Gets telephoneNumber
     *
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->container['telephoneNumber'];
    }

    /**
     * Sets telephoneNumber
     *
     * @param string|null $telephoneNumber The shopper's telephone number.
     *
     * @return self
     */
    public function setTelephoneNumber($telephoneNumber)
    {
        $this->container['telephoneNumber'] = $telephoneNumber;

        return $this;
    }

    /**
     * Gets themeId
     *
     * @return string|null
     */
    public function getThemeId()
    {
        return $this->container['themeId'];
    }

    /**
     * Sets themeId
     *
     * @param string|null $themeId A [theme](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#themes) to customize the appearance of the payment page. If not specified, the payment page is rendered according to the theme set as default in your Customer Area.
     *
     * @return self
     */
    public function setThemeId($themeId)
    {
        $this->container['themeId'] = $themeId;

        return $this;
    }

    /**
     * Gets threeDS2RequestData
     *
     * @return \Adyen\Model\Checkout\CheckoutSessionThreeDS2RequestData|null
     */
    public function getThreeDS2RequestData()
    {
        return $this->container['threeDS2RequestData'];
    }

    /**
     * Sets threeDS2RequestData
     *
     * @param \Adyen\Model\Checkout\CheckoutSessionThreeDS2RequestData|null $threeDS2RequestData threeDS2RequestData
     *
     * @return self
     */
    public function setThreeDS2RequestData($threeDS2RequestData)
    {
        $this->container['threeDS2RequestData'] = $threeDS2RequestData;

        return $this;
    }

    /**
     * Gets updatedAt
     *
     * @return \DateTime|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updatedAt'];
    }

    /**
     * Sets updatedAt
     *
     * @param \DateTime|null $updatedAt The date when the payment link status was updated.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.
     *
     * @return self
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->container['updatedAt'] = $updatedAt;

        return $this;
    }

    /**
     * Gets url
     *
     * @return string
     */
    public function getUrl()
    {
        return $this->container['url'];
    }

    /**
     * Sets url
     *
     * @param string $url The URL at which the shopper can complete the payment.
     *
     * @return self
     */
    public function setUrl($url)
    {
        $this->container['url'] = $url;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    public function toArray(): array
    {
        $array = [];
        foreach (self::$openAPITypes as $propertyName => $propertyType) {
            $propertyValue = $this[$propertyName];
            if ($propertyValue !== null) {
                // Check if the property value is an object and has a toArray() method
                if (is_object($propertyValue) && method_exists($propertyValue, 'toArray')) {
                    $array[$propertyName] = $propertyValue->toArray();
                // Check if it's type datetime
                } elseif ($propertyValue instanceof \DateTime) {
                    $array[$propertyName] = $propertyValue->format(DATE_ATOM);
                // If it's an array type we should check whether it contains objects and if so call toArray method
                } elseif (is_array($propertyValue)) {
                    $array[$propertyName] = array_map(function ($item) {
                        return $item instanceof ModelInterface ? $item->toArray() : $item;
                    }, $propertyValue);
                } else {
                    // Otherwise, directly assign the property value to the array
                    $array[$propertyName] = $propertyValue;
                }
            }
        }
        return $array;
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}
