<?php

namespace PaymentWebhooks\Gateway\Checkout;

use PaymentWebhooks\Contract\StatusMapperInterface;
use PaymentWebhooks\Gateway\Common\CommonStatusMapper;
use PaymentWebhooks\Gateway\Common\PayloadHelper;

final class CheckoutStatusMapper extends CommonStatusMapper implements StatusMapperInterface
{
    public function __construct(string $gateway)
    {
        parent::__construct($gateway);
    }

    public function map(array $payload): ?string
    {
        $responseTypePath = $this->jsonFields['response_type'] ?? '';
        $responseType = PayloadHelper::getByPath($payload, $responseTypePath);

        if (!is_string($responseType)) {
            throw new \RuntimeException('Invalid Checkout payload or config');
        }
        return $this->map[$responseType] ?? null;
    }
}
