<?php

namespace PaymentWebhooks\Gateway\Adyen;

use Adyen\Util\HmacSignature;
use PaymentWebhooks\Infrastructure\Config;
use PaymentWebhooks\Contract\PostValidatorInterface;
use WP_REST_Request;

final class AdyenPostValidator implements PostValidatorInterface
{
    public function verify(array $payload, WP_REST_Request $request): bool
    {
        $hmacKey = Config::get('PW_ADYEN_HMAC_KEY', '');
        $validator = new HmacSignature();
        $item = $payload['notificationItems'][0]['NotificationRequestItem'] ?? null;

        if (!$validator->isValidNotificationHMAC($hmacKey, $item)) {
            return false;
        }
        return true;
    }
}
