<?php

namespace PaymentWebhooks\Application;

use PaymentWebhooks\Core\AsynchronousOrderUpdater;
use PaymentWebhooks\Enum\GatewayEnum;
use PaymentWebhooks\Infrastructure\Config;
use WP_REST_Request;
use WP_REST_Response;

class Plugin
{
    public static function init(): void
    {
        add_action('rest_api_init', [self::class, 'registerRoutes']);
        add_action('init', [self::class, 'initUpdaters'], 100);
    }

    public static function initUpdaters(): void
    {
        if (Config::get('PW_ASYNC_UPDATE')) {
            foreach (GatewayEnum::cases() as $gatewayEnum) {
                new AsynchronousOrderUpdater($gatewayEnum->value);
            }
        }
    }

    public static function registerRoutes(): void
    {
        foreach (GatewayEnum::cases() as $case) {
            $slug = $case->value;
            register_rest_route(
                "payments/v1",
                "/$slug/payment-status",
                [
                    'methods'             => 'POST',
                    'callback'            => static function (\WP_REST_Request $req) use ($case) {
                        return WebhookController::handleForGateway($req, $case);
                    },
                    'permission_callback' => '__return_true',
                ]
            );

        }

    }
}
