<?php
use PaymentWebhooks\Infrastructure\Config;

return [
    'log_enabled' => Config::get('PW_CHECKOUT_LOG'),
    'status_map' => [
        'payment_captured' => 'processing',
        'payment_declined' => 'failed',
        'payment_refunded' => 'refunded',
    ],
    'json_fields' => [
        'order_id' =>            'data.reference',
        'response_type' =>       'type',
        'transaction_id' =>      'data.id',
    ],
    // Payment update block
    'payment_collect_data_trigger' => [
        'response_type' => 'payment_captured',
    ],
    'payment_data' => [
        'method_prefix' => 'nuxt_checkout_',
        'title_prefix'  => 'Checkout ',
    ],
];
