<?php
/**
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Adyen\Service\LegalEntityManagement;

use Adyen\AdyenException;
use Adyen\Client;
use Adyen\Service;
use Adyen\Model\LegalEntityManagement\ObjectSerializer;

class TaxEDeliveryConsentApi extends Service
{
    /**
     * @var array|string|string[]
     */
    private $baseURL;

    /**
     * TaxEDeliveryConsentApi constructor.
     *
     * @param \Adyen\Client $client
     * @throws AdyenException
     */
    public function __construct(Client $client)
    {
        parent::__construct($client);

        // Create the baseUrl based on live/test and optional live-url-prefix
        $this->baseURL = $this->createBaseUrl("https://kyc-test.adyen.com/lem/v3");
    }

    /**
    * Check the status of consent for electronic delivery of tax forms
    *
    * @param string $id
    * @param array|null $requestOptions
    * @return \Adyen\Model\LegalEntityManagement\CheckTaxElectronicDeliveryConsentResponse
    * @throws AdyenException
    */
    public function checkStatusOfConsentForElectronicDeliveryOfTaxForms(string $id, array $requestOptions = null): \Adyen\Model\LegalEntityManagement\CheckTaxElectronicDeliveryConsentResponse
    {
        $endpoint = $this->baseURL . str_replace(['{id}'], [$id], "/legalEntities/{id}/checkTaxElectronicDeliveryConsent");
        $response = $this->requestHttp($endpoint, strtolower('POST'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\LegalEntityManagement\CheckTaxElectronicDeliveryConsentResponse::class);
    }

    /**
    * Set the consent status for electronic delivery of tax forms
    *
    * @param string $id
    * @param \Adyen\Model\LegalEntityManagement\SetTaxElectronicDeliveryConsentRequest $setTaxElectronicDeliveryConsentRequest
    * @param array|null $requestOptions

    * @throws AdyenException
    */
    public function setConsentStatusForElectronicDeliveryOfTaxForms(string $id, \Adyen\Model\LegalEntityManagement\SetTaxElectronicDeliveryConsentRequest $setTaxElectronicDeliveryConsentRequest, array $requestOptions = null)
    {
        $endpoint = $this->baseURL . str_replace(['{id}'], [$id], "/legalEntities/{id}/setTaxElectronicDeliveryConsent");
        $this->requestHttp($endpoint, strtolower('POST'), (array) $setTaxElectronicDeliveryConsentRequest->jsonSerialize(), $requestOptions);
    }
}
