<?php

/**
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Adyen\Model\Checkout;

use \ArrayAccess;
use Adyen\Model\Checkout\ObjectSerializer;

/**
 * PixRecurring Class Doc Comment
 *
 * @category Class
 * @package  Adyen
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PixRecurring implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PixRecurring';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'billingDate' => 'string',
        'endsAt' => 'string',
        'frequency' => 'string',
        'minAmount' => '\Adyen\Model\Checkout\Amount',
        'originalPspReference' => 'string',
        'recurringAmount' => '\Adyen\Model\Checkout\Amount',
        'recurringStatement' => 'string',
        'retryPolicy' => 'bool',
        'startsAt' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'billingDate' => null,
        'endsAt' => null,
        'frequency' => null,
        'minAmount' => null,
        'originalPspReference' => null,
        'recurringAmount' => null,
        'recurringStatement' => null,
        'retryPolicy' => null,
        'startsAt' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'billingDate' => false,
        'endsAt' => false,
        'frequency' => false,
        'minAmount' => false,
        'originalPspReference' => false,
        'recurringAmount' => false,
        'recurringStatement' => false,
        'retryPolicy' => false,
        'startsAt' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'billingDate' => 'billingDate',
        'endsAt' => 'endsAt',
        'frequency' => 'frequency',
        'minAmount' => 'minAmount',
        'originalPspReference' => 'originalPspReference',
        'recurringAmount' => 'recurringAmount',
        'recurringStatement' => 'recurringStatement',
        'retryPolicy' => 'retryPolicy',
        'startsAt' => 'startsAt'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'billingDate' => 'setBillingDate',
        'endsAt' => 'setEndsAt',
        'frequency' => 'setFrequency',
        'minAmount' => 'setMinAmount',
        'originalPspReference' => 'setOriginalPspReference',
        'recurringAmount' => 'setRecurringAmount',
        'recurringStatement' => 'setRecurringStatement',
        'retryPolicy' => 'setRetryPolicy',
        'startsAt' => 'setStartsAt'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'billingDate' => 'getBillingDate',
        'endsAt' => 'getEndsAt',
        'frequency' => 'getFrequency',
        'minAmount' => 'getMinAmount',
        'originalPspReference' => 'getOriginalPspReference',
        'recurringAmount' => 'getRecurringAmount',
        'recurringStatement' => 'getRecurringStatement',
        'retryPolicy' => 'getRetryPolicy',
        'startsAt' => 'getStartsAt'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const FREQUENCY_WEEKLY = 'weekly';
    public const FREQUENCY_MONTHLY = 'monthly';
    public const FREQUENCY_QUARTERLY = 'quarterly';
    public const FREQUENCY_HALF_YEARLY = 'half-yearly';
    public const FREQUENCY_YEARLY = 'yearly';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getFrequencyAllowableValues()
    {
        return [
            self::FREQUENCY_WEEKLY,
            self::FREQUENCY_MONTHLY,
            self::FREQUENCY_QUARTERLY,
            self::FREQUENCY_HALF_YEARLY,
            self::FREQUENCY_YEARLY,
        ];
    }
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('billingDate', $data ?? [], null);
        $this->setIfExists('endsAt', $data ?? [], null);
        $this->setIfExists('frequency', $data ?? [], null);
        $this->setIfExists('minAmount', $data ?? [], null);
        $this->setIfExists('originalPspReference', $data ?? [], null);
        $this->setIfExists('recurringAmount', $data ?? [], null);
        $this->setIfExists('recurringStatement', $data ?? [], null);
        $this->setIfExists('retryPolicy', $data ?? [], null);
        $this->setIfExists('startsAt', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getFrequencyAllowableValues();
        if (!is_null($this->container['frequency']) && !in_array($this->container['frequency'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'frequency', must be one of '%s'",
                $this->container['frequency'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets billingDate
     *
     * @return string|null
     */
    public function getBillingDate()
    {
        return $this->container['billingDate'];
    }

    /**
     * Sets billingDate
     *
     * @param string|null $billingDate The date on which the shopper's payment method will be charged, in YYYY-MM-DD format.
     *
     * @return self
     */
    public function setBillingDate($billingDate)
    {
        $this->container['billingDate'] = $billingDate;

        return $this;
    }

    /**
     * Gets endsAt
     *
     * @return string|null
     */
    public function getEndsAt()
    {
        return $this->container['endsAt'];
    }

    /**
     * Sets endsAt
     *
     * @param string|null $endsAt End date of the billing plan, in YYYY-MM-DD format. The end date must align with the frequency and the start date of the billing plan. If left blank, the subscription will continue indefinitely unless it is cancelled by the shopper.
     *
     * @return self
     */
    public function setEndsAt($endsAt)
    {
        $this->container['endsAt'] = $endsAt;

        return $this;
    }

    /**
     * Gets frequency
     *
     * @return string|null
     */
    public function getFrequency()
    {
        return $this->container['frequency'];
    }

    /**
     * Sets frequency
     *
     * @param string|null $frequency The frequency at which the shopper will be charged.
     *
     * @return self
     */
    public function setFrequency($frequency)
    {
        $allowedValues = $this->getFrequencyAllowableValues();
        if (!in_array($frequency, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'frequency', must be one of '%s'",
                    $frequency,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['frequency'] = $frequency;

        return $this;
    }

    /**
     * Gets minAmount
     *
     * @return \Adyen\Model\Checkout\Amount|null
     */
    public function getMinAmount()
    {
        return $this->container['minAmount'];
    }

    /**
     * Sets minAmount
     *
     * @param \Adyen\Model\Checkout\Amount|null $minAmount minAmount
     *
     * @return self
     */
    public function setMinAmount($minAmount)
    {
        $this->container['minAmount'] = $minAmount;

        return $this;
    }

    /**
     * Gets originalPspReference
     *
     * @return string|null
     */
    public function getOriginalPspReference()
    {
        return $this->container['originalPspReference'];
    }

    /**
     * Sets originalPspReference
     *
     * @param string|null $originalPspReference The pspReference for the failed recurring payment. Find this in AUTHORISATION webhook you received after the billing date.
     *
     * @return self
     */
    public function setOriginalPspReference($originalPspReference)
    {
        $this->container['originalPspReference'] = $originalPspReference;

        return $this;
    }

    /**
     * Gets recurringAmount
     *
     * @return \Adyen\Model\Checkout\Amount|null
     */
    public function getRecurringAmount()
    {
        return $this->container['recurringAmount'];
    }

    /**
     * Sets recurringAmount
     *
     * @param \Adyen\Model\Checkout\Amount|null $recurringAmount recurringAmount
     *
     * @return self
     */
    public function setRecurringAmount($recurringAmount)
    {
        $this->container['recurringAmount'] = $recurringAmount;

        return $this;
    }

    /**
     * Gets recurringStatement
     *
     * @return string|null
     */
    public function getRecurringStatement()
    {
        return $this->container['recurringStatement'];
    }

    /**
     * Sets recurringStatement
     *
     * @param string|null $recurringStatement The text that that will be shown on the shopper's bank statement for the recurring payments. We recommend to add a descriptive text about the subscription to let your shoppers recognize your recurring payments. Maximum length: 35 characters.
     *
     * @return self
     */
    public function setRecurringStatement($recurringStatement)
    {
        $this->container['recurringStatement'] = $recurringStatement;

        return $this;
    }

    /**
     * Gets retryPolicy
     *
     * @return bool|null
     */
    public function getRetryPolicy()
    {
        return $this->container['retryPolicy'];
    }

    /**
     * Sets retryPolicy
     *
     * @param bool|null $retryPolicy When set to true, you can retry for failed recurring payments. The default value is true.
     *
     * @return self
     */
    public function setRetryPolicy($retryPolicy)
    {
        $this->container['retryPolicy'] = $retryPolicy;

        return $this;
    }

    /**
     * Gets startsAt
     *
     * @return string|null
     */
    public function getStartsAt()
    {
        return $this->container['startsAt'];
    }

    /**
     * Sets startsAt
     *
     * @param string|null $startsAt Start date of the billing plan, in YYYY-MM-DD format. The default value is the transaction date.
     *
     * @return self
     */
    public function setStartsAt($startsAt)
    {
        $this->container['startsAt'] = $startsAt;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    public function toArray(): array
    {
        $array = [];
        foreach (self::$openAPITypes as $propertyName => $propertyType) {
            $propertyValue = $this[$propertyName];
            if ($propertyValue !== null) {
                // Check if the property value is an object and has a toArray() method
                if (is_object($propertyValue) && method_exists($propertyValue, 'toArray')) {
                    $array[$propertyName] = $propertyValue->toArray();
                // Check if it's type datetime
                } elseif ($propertyValue instanceof \DateTime) {
                    $array[$propertyName] = $propertyValue->format(DATE_ATOM);
                // If it's an array type we should check whether it contains objects and if so call toArray method
                } elseif (is_array($propertyValue)) {
                    $array[$propertyName] = array_map(function ($item) {
                        return $item instanceof ModelInterface ? $item->toArray() : $item;
                    }, $propertyValue);
                } else {
                    // Otherwise, directly assign the property value to the array
                    $array[$propertyName] = $propertyValue;
                }
            }
        }
        return $array;
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}
