<?php

namespace PaymentWebhooks\Gateway\PayPal;

use PaymentWebhooks\Contract\StatusMapperInterface;
use PaymentWebhooks\Gateway\Common\PayloadHelper;
use PaymentWebhooks\Gateway\Common\CommonStatusMapper;

final class PayPalStatusMapper extends CommonStatusMapper implements StatusMapperInterface
{
    public function __construct(string $gateway)
    {
        parent::__construct($gateway);
    }

    public function map(array $payload): ?string
    {
        $path = $this->jsonFields['event'];
        $event = PayloadHelper::getByPath($payload, $path);
        return $this->map[$event] ?? null;
    }
}
