<?php
/**
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Adyen\Service\BalancePlatform;

use Adyen\AdyenException;
use Adyen\Client;
use Adyen\Service;
use Adyen\Model\BalancePlatform\ObjectSerializer;

class GrantOffersApi extends Service
{
    /**
     * @var array|string|string[]
     */
    private $baseURL;

    /**
     * GrantOffersApi constructor.
     *
     * @param \Adyen\Client $client
     * @throws AdyenException
     */
    public function __construct(Client $client)
    {
        parent::__construct($client);

        // Create the baseUrl based on live/test and optional live-url-prefix
        $this->baseURL = $this->createBaseUrl("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    /**
    * Get all available grant offers
    *
    * @deprecated since Configuration API v2. "Use the `/grantOffers` endpoint from the [Capital API](https://docs.adyen.com/api-explorer/capital/latest/get/grantOffers) instead."
    * @param array|null $requestOptions ['queryParams' => ['accountHolderId'=> string]]
    * @return \Adyen\Model\BalancePlatform\GrantOffers
    * @throws AdyenException
    */
    public function getAllAvailableGrantOffers(array $requestOptions = null): \Adyen\Model\BalancePlatform\GrantOffers
    {
        $endpoint = $this->baseURL . "/grantOffers";
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\GrantOffers::class);
    }

    /**
    * Get a grant offer
    *
    * @deprecated since Configuration API v2. "Use the `/grantOffers/{id}` endpoint from the [Capital API](https://docs.adyen.com/api-explorer/capital/latest/get/grantOffers/(id)) instead."
    * @param string $grantOfferId
    * @param array|null $requestOptions
    * @return \Adyen\Model\BalancePlatform\GrantOffer
    * @throws AdyenException
    */
    public function getGrantOffer(string $grantOfferId, array $requestOptions = null): \Adyen\Model\BalancePlatform\GrantOffer
    {
        $endpoint = $this->baseURL . str_replace(['{grantOfferId}'], [$grantOfferId], "/grantOffers/{grantOfferId}");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\GrantOffer::class);
    }
}
