<?php

namespace PaymentWebhooks\Infrastructure;

use Monolog\Handler\StreamHandler;
use Monolog\Logger as MonoLogger;
use Psr\Log\LoggerInterface;
use Psr\Log\NullLogger;

class LoggerFactory
{
    public static function make(string $gateway): LoggerInterface
    {
        $config = Config::gateway($gateway);
        $enabled = $config['log_enabled'] ?? false;
        if (!$enabled) {
            return new NullLogger();
        }

        $log = new MonoLogger('payment-webhooks-' . $gateway);

        $uploadDir = wp_upload_dir();
        $logFile = $uploadDir['basedir'] . '/payments.log';
        $log->pushHandler(new StreamHandler($logFile, MonoLogger::INFO));
        return $log;
    }
}
