<?php

namespace PaymentWebhooks\Application;

use WP_REST_Request;
use WP_REST_Response;

class WebhookController
{
    public static function handle(WP_REST_Request $request): WP_REST_Response
    {
        $gateway = strtolower($request['gateway'] ?? '');

        $handler = WebhookHandlerFactory::make($gateway);

        if ($handler === null) {
            return new WP_REST_Response(['error' => 'Gateway not supported'], 404);
        }

        return $handler->process($request);
    }
}
