<?php

namespace PaymentWebhooks\Infrastructure;

use Dotenv\Dotenv;

class Config
{
    private static bool $loaded = false;

    public static function load(): void
    {
        if (self::$loaded) {
            return;
        }
        $root = dirname(__DIR__, 2);
        if (file_exists($root . '/.env')) {
            $dotenv = Dotenv::createImmutable($root);
            $dotenv->safeLoad();
        }
        self::$loaded = true;
    }

    public static function get(string $key, $default = null)
    {
        self::load();
        return $_ENV[$key] ?? getenv($key) ?: $default;
    }

    public static function gateway(string $gateway): array
    {
        $path = dirname(__DIR__, 2) . '/config/' . strtolower($gateway) . '.php';
        if (file_exists($path)) {
            return include $path;
        }
        return [];
    }
}
