<?php

namespace PaymentWebhooks\Gateway\Adyen;

use PaymentWebhooks\Contract\AuthenticatorInterface;
use PaymentWebhooks\Infrastructure\Config;
use WP_REST_Request;

final class AdyenAuthenticator implements AuthenticatorInterface
{
    public function authenticate(WP_REST_Request $request): bool
    {
        $configUser = Config::get('PW_ADYEN_USER');
        $configPassword = Config::get('PW_ADYEN_PASS');
        $basicAuthHeader = $request->get_header('Authorization');
        if (!$basicAuthHeader || !str_starts_with($basicAuthHeader, 'Basic ')) {
            return false;
        }
        $decoded = base64_decode(substr($basicAuthHeader, 6));
        [$requestUser, $requestPassword] = explode(':', $decoded, 2) + [null, null];
        return $requestUser === $configUser && $requestPassword === $configPassword;
    }
}
