<?php

namespace PaymentWebhooks\Application;

use PaymentWebhooks\Infrastructure\Config;
use WP_REST_Request;
use WP_REST_Response;

class Plugin
{
    public static function init(): void
    {
        Config::load();
        add_action('rest_api_init', [self::class, 'registerRoutes']);
    }

    public static function registerRoutes(): void
    {
        register_rest_route(
            'payments/v1',
            '/(?P<gateway>[a-z]+)/payment-status',
            [
                'methods'             => 'POST',
                'callback'            => [WebhookController::class, 'handle'],
                'permission_callback' => '__return_true',
            ]
        );
    }
}
