<?php
/**
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Adyen\Service\BalancePlatform;

use Adyen\AdyenException;
use Adyen\Client;
use Adyen\Service;
use Adyen\Model\BalancePlatform\ObjectSerializer;

class PlatformApi extends Service
{
    /**
     * @var array|string|string[]
     */
    private $baseURL;

    /**
     * PlatformApi constructor.
     *
     * @param \Adyen\Client $client
     * @throws AdyenException
     */
    public function __construct(Client $client)
    {
        parent::__construct($client);

        // Create the baseUrl based on live/test and optional live-url-prefix
        $this->baseURL = $this->createBaseUrl("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    /**
    * Get all account holders under a balance platform
    *
    * @param string $id
    * @param array|null $requestOptions ['queryParams' => ['offset'=> int, 'limit'=> int]]
    * @return \Adyen\Model\BalancePlatform\PaginatedAccountHoldersResponse
    * @throws AdyenException
    */
    public function getAllAccountHoldersUnderBalancePlatform(string $id, array $requestOptions = null): \Adyen\Model\BalancePlatform\PaginatedAccountHoldersResponse
    {
        $endpoint = $this->baseURL . str_replace(['{id}'], [$id], "/balancePlatforms/{id}/accountHolders");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\PaginatedAccountHoldersResponse::class);
    }

    /**
    * Get all transaction rules for a balance platform
    *
    * @param string $id
    * @param array|null $requestOptions
    * @return \Adyen\Model\BalancePlatform\TransactionRulesResponse
    * @throws AdyenException
    */
    public function getAllTransactionRulesForBalancePlatform(string $id, array $requestOptions = null): \Adyen\Model\BalancePlatform\TransactionRulesResponse
    {
        $endpoint = $this->baseURL . str_replace(['{id}'], [$id], "/balancePlatforms/{id}/transactionRules");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\TransactionRulesResponse::class);
    }

    /**
    * Get a balance platform
    *
    * @param string $id
    * @param array|null $requestOptions
    * @return \Adyen\Model\BalancePlatform\BalancePlatform
    * @throws AdyenException
    */
    public function getBalancePlatform(string $id, array $requestOptions = null): \Adyen\Model\BalancePlatform\BalancePlatform
    {
        $endpoint = $this->baseURL . str_replace(['{id}'], [$id], "/balancePlatforms/{id}");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\BalancePlatform::class);
    }
}
