<?php

/**
 * Adyen Payout API
 *
 * The version of the OpenAPI document: 68
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Adyen\Model\Payout;

use \ArrayAccess;
use Adyen\Model\Payout\ObjectSerializer;

/**
 * ResponseAdditionalDataCommon Class Doc Comment
 *
 * @category Class
 * @package  Adyen
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ResponseAdditionalDataCommon implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ResponseAdditionalDataCommon';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'acquirerAccountCode' => 'string',
        'acquirerCode' => 'string',
        'acquirerReference' => 'string',
        'alias' => 'string',
        'aliasType' => 'string',
        'authCode' => 'string',
        'authorisationMid' => 'string',
        'authorisedAmountCurrency' => 'string',
        'authorisedAmountValue' => 'string',
        'avsResult' => 'string',
        'avsResultRaw' => 'string',
        'bic' => 'string',
        'coBrandedWith' => 'string',
        'cvcResult' => 'string',
        'cvcResultRaw' => 'string',
        'dsTransID' => 'string',
        'eci' => 'string',
        'expiryDate' => 'string',
        'extraCostsCurrency' => 'string',
        'extraCostsValue' => 'string',
        'fraudCheckItemNrFraudCheckname' => 'string',
        'fraudManualReview' => 'string',
        'fraudResultType' => 'string',
        'fundingSource' => 'string',
        'fundsAvailability' => 'string',
        'inferredRefusalReason' => 'string',
        'isCardCommercial' => 'string',
        'issuerCountry' => 'string',
        'liabilityShift' => 'string',
        'mcBankNetReferenceNumber' => 'string',
        'merchantAdviceCode' => 'string',
        'merchantReference' => 'string',
        'networkTxReference' => 'string',
        'ownerName' => 'string',
        'paymentAccountReference' => 'string',
        'paymentMethod' => 'string',
        'paymentMethodVariant' => 'string',
        'payoutEligible' => 'string',
        'realtimeAccountUpdaterStatus' => 'string',
        'receiptFreeText' => 'string',
        'recurringContractTypes' => 'string',
        'recurringFirstPspReference' => 'string',
        'recurringRecurringDetailReference' => 'string',
        'recurringShopperReference' => 'string',
        'recurringProcessingModel' => 'string',
        'referred' => 'string',
        'refusalReasonRaw' => 'string',
        'requestAmount' => 'string',
        'requestCurrencyCode' => 'string',
        'shopperInteraction' => 'string',
        'shopperReference' => 'string',
        'terminalId' => 'string',
        'threeDAuthenticated' => 'string',
        'threeDAuthenticatedResponse' => 'string',
        'threeDOffered' => 'string',
        'threeDOfferedResponse' => 'string',
        'threeDSVersion' => 'string',
        'tokenizationShopperReference' => 'string',
        'tokenizationStoreOperationType' => 'string',
        'tokenizationStoredPaymentMethodId' => 'string',
        'visaTransactionId' => 'string',
        'xid' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'acquirerAccountCode' => null,
        'acquirerCode' => null,
        'acquirerReference' => null,
        'alias' => null,
        'aliasType' => null,
        'authCode' => null,
        'authorisationMid' => null,
        'authorisedAmountCurrency' => null,
        'authorisedAmountValue' => null,
        'avsResult' => null,
        'avsResultRaw' => null,
        'bic' => null,
        'coBrandedWith' => null,
        'cvcResult' => null,
        'cvcResultRaw' => null,
        'dsTransID' => null,
        'eci' => null,
        'expiryDate' => null,
        'extraCostsCurrency' => null,
        'extraCostsValue' => null,
        'fraudCheckItemNrFraudCheckname' => null,
        'fraudManualReview' => null,
        'fraudResultType' => null,
        'fundingSource' => null,
        'fundsAvailability' => null,
        'inferredRefusalReason' => null,
        'isCardCommercial' => null,
        'issuerCountry' => null,
        'liabilityShift' => null,
        'mcBankNetReferenceNumber' => null,
        'merchantAdviceCode' => null,
        'merchantReference' => null,
        'networkTxReference' => null,
        'ownerName' => null,
        'paymentAccountReference' => null,
        'paymentMethod' => null,
        'paymentMethodVariant' => null,
        'payoutEligible' => null,
        'realtimeAccountUpdaterStatus' => null,
        'receiptFreeText' => null,
        'recurringContractTypes' => null,
        'recurringFirstPspReference' => null,
        'recurringRecurringDetailReference' => null,
        'recurringShopperReference' => null,
        'recurringProcessingModel' => null,
        'referred' => null,
        'refusalReasonRaw' => null,
        'requestAmount' => null,
        'requestCurrencyCode' => null,
        'shopperInteraction' => null,
        'shopperReference' => null,
        'terminalId' => null,
        'threeDAuthenticated' => null,
        'threeDAuthenticatedResponse' => null,
        'threeDOffered' => null,
        'threeDOfferedResponse' => null,
        'threeDSVersion' => null,
        'tokenizationShopperReference' => null,
        'tokenizationStoreOperationType' => null,
        'tokenizationStoredPaymentMethodId' => null,
        'visaTransactionId' => null,
        'xid' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'acquirerAccountCode' => false,
        'acquirerCode' => false,
        'acquirerReference' => false,
        'alias' => false,
        'aliasType' => false,
        'authCode' => false,
        'authorisationMid' => false,
        'authorisedAmountCurrency' => false,
        'authorisedAmountValue' => false,
        'avsResult' => false,
        'avsResultRaw' => false,
        'bic' => false,
        'coBrandedWith' => false,
        'cvcResult' => false,
        'cvcResultRaw' => false,
        'dsTransID' => false,
        'eci' => false,
        'expiryDate' => false,
        'extraCostsCurrency' => false,
        'extraCostsValue' => false,
        'fraudCheckItemNrFraudCheckname' => false,
        'fraudManualReview' => false,
        'fraudResultType' => false,
        'fundingSource' => false,
        'fundsAvailability' => false,
        'inferredRefusalReason' => false,
        'isCardCommercial' => false,
        'issuerCountry' => false,
        'liabilityShift' => false,
        'mcBankNetReferenceNumber' => false,
        'merchantAdviceCode' => false,
        'merchantReference' => false,
        'networkTxReference' => false,
        'ownerName' => false,
        'paymentAccountReference' => false,
        'paymentMethod' => false,
        'paymentMethodVariant' => false,
        'payoutEligible' => false,
        'realtimeAccountUpdaterStatus' => false,
        'receiptFreeText' => false,
        'recurringContractTypes' => false,
        'recurringFirstPspReference' => false,
        'recurringRecurringDetailReference' => false,
        'recurringShopperReference' => false,
        'recurringProcessingModel' => false,
        'referred' => false,
        'refusalReasonRaw' => false,
        'requestAmount' => false,
        'requestCurrencyCode' => false,
        'shopperInteraction' => false,
        'shopperReference' => false,
        'terminalId' => false,
        'threeDAuthenticated' => false,
        'threeDAuthenticatedResponse' => false,
        'threeDOffered' => false,
        'threeDOfferedResponse' => false,
        'threeDSVersion' => false,
        'tokenizationShopperReference' => false,
        'tokenizationStoreOperationType' => false,
        'tokenizationStoredPaymentMethodId' => false,
        'visaTransactionId' => false,
        'xid' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'acquirerAccountCode' => 'acquirerAccountCode',
        'acquirerCode' => 'acquirerCode',
        'acquirerReference' => 'acquirerReference',
        'alias' => 'alias',
        'aliasType' => 'aliasType',
        'authCode' => 'authCode',
        'authorisationMid' => 'authorisationMid',
        'authorisedAmountCurrency' => 'authorisedAmountCurrency',
        'authorisedAmountValue' => 'authorisedAmountValue',
        'avsResult' => 'avsResult',
        'avsResultRaw' => 'avsResultRaw',
        'bic' => 'bic',
        'coBrandedWith' => 'coBrandedWith',
        'cvcResult' => 'cvcResult',
        'cvcResultRaw' => 'cvcResultRaw',
        'dsTransID' => 'dsTransID',
        'eci' => 'eci',
        'expiryDate' => 'expiryDate',
        'extraCostsCurrency' => 'extraCostsCurrency',
        'extraCostsValue' => 'extraCostsValue',
        'fraudCheckItemNrFraudCheckname' => 'fraudCheck-[itemNr]-[FraudCheckname]',
        'fraudManualReview' => 'fraudManualReview',
        'fraudResultType' => 'fraudResultType',
        'fundingSource' => 'fundingSource',
        'fundsAvailability' => 'fundsAvailability',
        'inferredRefusalReason' => 'inferredRefusalReason',
        'isCardCommercial' => 'isCardCommercial',
        'issuerCountry' => 'issuerCountry',
        'liabilityShift' => 'liabilityShift',
        'mcBankNetReferenceNumber' => 'mcBankNetReferenceNumber',
        'merchantAdviceCode' => 'merchantAdviceCode',
        'merchantReference' => 'merchantReference',
        'networkTxReference' => 'networkTxReference',
        'ownerName' => 'ownerName',
        'paymentAccountReference' => 'paymentAccountReference',
        'paymentMethod' => 'paymentMethod',
        'paymentMethodVariant' => 'paymentMethodVariant',
        'payoutEligible' => 'payoutEligible',
        'realtimeAccountUpdaterStatus' => 'realtimeAccountUpdaterStatus',
        'receiptFreeText' => 'receiptFreeText',
        'recurringContractTypes' => 'recurring.contractTypes',
        'recurringFirstPspReference' => 'recurring.firstPspReference',
        'recurringRecurringDetailReference' => 'recurring.recurringDetailReference',
        'recurringShopperReference' => 'recurring.shopperReference',
        'recurringProcessingModel' => 'recurringProcessingModel',
        'referred' => 'referred',
        'refusalReasonRaw' => 'refusalReasonRaw',
        'requestAmount' => 'requestAmount',
        'requestCurrencyCode' => 'requestCurrencyCode',
        'shopperInteraction' => 'shopperInteraction',
        'shopperReference' => 'shopperReference',
        'terminalId' => 'terminalId',
        'threeDAuthenticated' => 'threeDAuthenticated',
        'threeDAuthenticatedResponse' => 'threeDAuthenticatedResponse',
        'threeDOffered' => 'threeDOffered',
        'threeDOfferedResponse' => 'threeDOfferedResponse',
        'threeDSVersion' => 'threeDSVersion',
        'tokenizationShopperReference' => 'tokenization.shopperReference',
        'tokenizationStoreOperationType' => 'tokenization.store.operationType',
        'tokenizationStoredPaymentMethodId' => 'tokenization.storedPaymentMethodId',
        'visaTransactionId' => 'visaTransactionId',
        'xid' => 'xid'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'acquirerAccountCode' => 'setAcquirerAccountCode',
        'acquirerCode' => 'setAcquirerCode',
        'acquirerReference' => 'setAcquirerReference',
        'alias' => 'setAlias',
        'aliasType' => 'setAliasType',
        'authCode' => 'setAuthCode',
        'authorisationMid' => 'setAuthorisationMid',
        'authorisedAmountCurrency' => 'setAuthorisedAmountCurrency',
        'authorisedAmountValue' => 'setAuthorisedAmountValue',
        'avsResult' => 'setAvsResult',
        'avsResultRaw' => 'setAvsResultRaw',
        'bic' => 'setBic',
        'coBrandedWith' => 'setCoBrandedWith',
        'cvcResult' => 'setCvcResult',
        'cvcResultRaw' => 'setCvcResultRaw',
        'dsTransID' => 'setDsTransID',
        'eci' => 'setEci',
        'expiryDate' => 'setExpiryDate',
        'extraCostsCurrency' => 'setExtraCostsCurrency',
        'extraCostsValue' => 'setExtraCostsValue',
        'fraudCheckItemNrFraudCheckname' => 'setFraudCheckItemNrFraudCheckname',
        'fraudManualReview' => 'setFraudManualReview',
        'fraudResultType' => 'setFraudResultType',
        'fundingSource' => 'setFundingSource',
        'fundsAvailability' => 'setFundsAvailability',
        'inferredRefusalReason' => 'setInferredRefusalReason',
        'isCardCommercial' => 'setIsCardCommercial',
        'issuerCountry' => 'setIssuerCountry',
        'liabilityShift' => 'setLiabilityShift',
        'mcBankNetReferenceNumber' => 'setMcBankNetReferenceNumber',
        'merchantAdviceCode' => 'setMerchantAdviceCode',
        'merchantReference' => 'setMerchantReference',
        'networkTxReference' => 'setNetworkTxReference',
        'ownerName' => 'setOwnerName',
        'paymentAccountReference' => 'setPaymentAccountReference',
        'paymentMethod' => 'setPaymentMethod',
        'paymentMethodVariant' => 'setPaymentMethodVariant',
        'payoutEligible' => 'setPayoutEligible',
        'realtimeAccountUpdaterStatus' => 'setRealtimeAccountUpdaterStatus',
        'receiptFreeText' => 'setReceiptFreeText',
        'recurringContractTypes' => 'setRecurringContractTypes',
        'recurringFirstPspReference' => 'setRecurringFirstPspReference',
        'recurringRecurringDetailReference' => 'setRecurringRecurringDetailReference',
        'recurringShopperReference' => 'setRecurringShopperReference',
        'recurringProcessingModel' => 'setRecurringProcessingModel',
        'referred' => 'setReferred',
        'refusalReasonRaw' => 'setRefusalReasonRaw',
        'requestAmount' => 'setRequestAmount',
        'requestCurrencyCode' => 'setRequestCurrencyCode',
        'shopperInteraction' => 'setShopperInteraction',
        'shopperReference' => 'setShopperReference',
        'terminalId' => 'setTerminalId',
        'threeDAuthenticated' => 'setThreeDAuthenticated',
        'threeDAuthenticatedResponse' => 'setThreeDAuthenticatedResponse',
        'threeDOffered' => 'setThreeDOffered',
        'threeDOfferedResponse' => 'setThreeDOfferedResponse',
        'threeDSVersion' => 'setThreeDSVersion',
        'tokenizationShopperReference' => 'setTokenizationShopperReference',
        'tokenizationStoreOperationType' => 'setTokenizationStoreOperationType',
        'tokenizationStoredPaymentMethodId' => 'setTokenizationStoredPaymentMethodId',
        'visaTransactionId' => 'setVisaTransactionId',
        'xid' => 'setXid'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'acquirerAccountCode' => 'getAcquirerAccountCode',
        'acquirerCode' => 'getAcquirerCode',
        'acquirerReference' => 'getAcquirerReference',
        'alias' => 'getAlias',
        'aliasType' => 'getAliasType',
        'authCode' => 'getAuthCode',
        'authorisationMid' => 'getAuthorisationMid',
        'authorisedAmountCurrency' => 'getAuthorisedAmountCurrency',
        'authorisedAmountValue' => 'getAuthorisedAmountValue',
        'avsResult' => 'getAvsResult',
        'avsResultRaw' => 'getAvsResultRaw',
        'bic' => 'getBic',
        'coBrandedWith' => 'getCoBrandedWith',
        'cvcResult' => 'getCvcResult',
        'cvcResultRaw' => 'getCvcResultRaw',
        'dsTransID' => 'getDsTransID',
        'eci' => 'getEci',
        'expiryDate' => 'getExpiryDate',
        'extraCostsCurrency' => 'getExtraCostsCurrency',
        'extraCostsValue' => 'getExtraCostsValue',
        'fraudCheckItemNrFraudCheckname' => 'getFraudCheckItemNrFraudCheckname',
        'fraudManualReview' => 'getFraudManualReview',
        'fraudResultType' => 'getFraudResultType',
        'fundingSource' => 'getFundingSource',
        'fundsAvailability' => 'getFundsAvailability',
        'inferredRefusalReason' => 'getInferredRefusalReason',
        'isCardCommercial' => 'getIsCardCommercial',
        'issuerCountry' => 'getIssuerCountry',
        'liabilityShift' => 'getLiabilityShift',
        'mcBankNetReferenceNumber' => 'getMcBankNetReferenceNumber',
        'merchantAdviceCode' => 'getMerchantAdviceCode',
        'merchantReference' => 'getMerchantReference',
        'networkTxReference' => 'getNetworkTxReference',
        'ownerName' => 'getOwnerName',
        'paymentAccountReference' => 'getPaymentAccountReference',
        'paymentMethod' => 'getPaymentMethod',
        'paymentMethodVariant' => 'getPaymentMethodVariant',
        'payoutEligible' => 'getPayoutEligible',
        'realtimeAccountUpdaterStatus' => 'getRealtimeAccountUpdaterStatus',
        'receiptFreeText' => 'getReceiptFreeText',
        'recurringContractTypes' => 'getRecurringContractTypes',
        'recurringFirstPspReference' => 'getRecurringFirstPspReference',
        'recurringRecurringDetailReference' => 'getRecurringRecurringDetailReference',
        'recurringShopperReference' => 'getRecurringShopperReference',
        'recurringProcessingModel' => 'getRecurringProcessingModel',
        'referred' => 'getReferred',
        'refusalReasonRaw' => 'getRefusalReasonRaw',
        'requestAmount' => 'getRequestAmount',
        'requestCurrencyCode' => 'getRequestCurrencyCode',
        'shopperInteraction' => 'getShopperInteraction',
        'shopperReference' => 'getShopperReference',
        'terminalId' => 'getTerminalId',
        'threeDAuthenticated' => 'getThreeDAuthenticated',
        'threeDAuthenticatedResponse' => 'getThreeDAuthenticatedResponse',
        'threeDOffered' => 'getThreeDOffered',
        'threeDOfferedResponse' => 'getThreeDOfferedResponse',
        'threeDSVersion' => 'getThreeDSVersion',
        'tokenizationShopperReference' => 'getTokenizationShopperReference',
        'tokenizationStoreOperationType' => 'getTokenizationStoreOperationType',
        'tokenizationStoredPaymentMethodId' => 'getTokenizationStoredPaymentMethodId',
        'visaTransactionId' => 'getVisaTransactionId',
        'xid' => 'getXid'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const FRAUD_RESULT_TYPE_GREEN = 'GREEN';
    public const FRAUD_RESULT_TYPE_FRAUD = 'FRAUD';
    public const RECURRING_PROCESSING_MODEL_CARD_ON_FILE = 'CardOnFile';
    public const RECURRING_PROCESSING_MODEL_SUBSCRIPTION = 'Subscription';
    public const RECURRING_PROCESSING_MODEL_UNSCHEDULED_CARD_ON_FILE = 'UnscheduledCardOnFile';
    public const TOKENIZATION_STORE_OPERATION_TYPE_CREATED = 'created';
    public const TOKENIZATION_STORE_OPERATION_TYPE_UPDATED = 'updated';
    public const TOKENIZATION_STORE_OPERATION_TYPE_ALREADY_EXISTING = 'alreadyExisting';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getFraudResultTypeAllowableValues()
    {
        return [
            self::FRAUD_RESULT_TYPE_GREEN,
            self::FRAUD_RESULT_TYPE_FRAUD,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getRecurringProcessingModelAllowableValues()
    {
        return [
            self::RECURRING_PROCESSING_MODEL_CARD_ON_FILE,
            self::RECURRING_PROCESSING_MODEL_SUBSCRIPTION,
            self::RECURRING_PROCESSING_MODEL_UNSCHEDULED_CARD_ON_FILE,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTokenizationStoreOperationTypeAllowableValues()
    {
        return [
            self::TOKENIZATION_STORE_OPERATION_TYPE_CREATED,
            self::TOKENIZATION_STORE_OPERATION_TYPE_UPDATED,
            self::TOKENIZATION_STORE_OPERATION_TYPE_ALREADY_EXISTING,
        ];
    }
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('acquirerAccountCode', $data ?? [], null);
        $this->setIfExists('acquirerCode', $data ?? [], null);
        $this->setIfExists('acquirerReference', $data ?? [], null);
        $this->setIfExists('alias', $data ?? [], null);
        $this->setIfExists('aliasType', $data ?? [], null);
        $this->setIfExists('authCode', $data ?? [], null);
        $this->setIfExists('authorisationMid', $data ?? [], null);
        $this->setIfExists('authorisedAmountCurrency', $data ?? [], null);
        $this->setIfExists('authorisedAmountValue', $data ?? [], null);
        $this->setIfExists('avsResult', $data ?? [], null);
        $this->setIfExists('avsResultRaw', $data ?? [], null);
        $this->setIfExists('bic', $data ?? [], null);
        $this->setIfExists('coBrandedWith', $data ?? [], null);
        $this->setIfExists('cvcResult', $data ?? [], null);
        $this->setIfExists('cvcResultRaw', $data ?? [], null);
        $this->setIfExists('dsTransID', $data ?? [], null);
        $this->setIfExists('eci', $data ?? [], null);
        $this->setIfExists('expiryDate', $data ?? [], null);
        $this->setIfExists('extraCostsCurrency', $data ?? [], null);
        $this->setIfExists('extraCostsValue', $data ?? [], null);
        $this->setIfExists('fraudCheckItemNrFraudCheckname', $data ?? [], null);
        $this->setIfExists('fraudManualReview', $data ?? [], null);
        $this->setIfExists('fraudResultType', $data ?? [], null);
        $this->setIfExists('fundingSource', $data ?? [], null);
        $this->setIfExists('fundsAvailability', $data ?? [], null);
        $this->setIfExists('inferredRefusalReason', $data ?? [], null);
        $this->setIfExists('isCardCommercial', $data ?? [], null);
        $this->setIfExists('issuerCountry', $data ?? [], null);
        $this->setIfExists('liabilityShift', $data ?? [], null);
        $this->setIfExists('mcBankNetReferenceNumber', $data ?? [], null);
        $this->setIfExists('merchantAdviceCode', $data ?? [], null);
        $this->setIfExists('merchantReference', $data ?? [], null);
        $this->setIfExists('networkTxReference', $data ?? [], null);
        $this->setIfExists('ownerName', $data ?? [], null);
        $this->setIfExists('paymentAccountReference', $data ?? [], null);
        $this->setIfExists('paymentMethod', $data ?? [], null);
        $this->setIfExists('paymentMethodVariant', $data ?? [], null);
        $this->setIfExists('payoutEligible', $data ?? [], null);
        $this->setIfExists('realtimeAccountUpdaterStatus', $data ?? [], null);
        $this->setIfExists('receiptFreeText', $data ?? [], null);
        $this->setIfExists('recurringContractTypes', $data ?? [], null);
        $this->setIfExists('recurringFirstPspReference', $data ?? [], null);
        $this->setIfExists('recurringRecurringDetailReference', $data ?? [], null);
        $this->setIfExists('recurringShopperReference', $data ?? [], null);
        $this->setIfExists('recurringProcessingModel', $data ?? [], null);
        $this->setIfExists('referred', $data ?? [], null);
        $this->setIfExists('refusalReasonRaw', $data ?? [], null);
        $this->setIfExists('requestAmount', $data ?? [], null);
        $this->setIfExists('requestCurrencyCode', $data ?? [], null);
        $this->setIfExists('shopperInteraction', $data ?? [], null);
        $this->setIfExists('shopperReference', $data ?? [], null);
        $this->setIfExists('terminalId', $data ?? [], null);
        $this->setIfExists('threeDAuthenticated', $data ?? [], null);
        $this->setIfExists('threeDAuthenticatedResponse', $data ?? [], null);
        $this->setIfExists('threeDOffered', $data ?? [], null);
        $this->setIfExists('threeDOfferedResponse', $data ?? [], null);
        $this->setIfExists('threeDSVersion', $data ?? [], null);
        $this->setIfExists('tokenizationShopperReference', $data ?? [], null);
        $this->setIfExists('tokenizationStoreOperationType', $data ?? [], null);
        $this->setIfExists('tokenizationStoredPaymentMethodId', $data ?? [], null);
        $this->setIfExists('visaTransactionId', $data ?? [], null);
        $this->setIfExists('xid', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getFraudResultTypeAllowableValues();
        if (!is_null($this->container['fraudResultType']) && !in_array($this->container['fraudResultType'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'fraudResultType', must be one of '%s'",
                $this->container['fraudResultType'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getRecurringProcessingModelAllowableValues();
        if (!is_null($this->container['recurringProcessingModel']) && !in_array($this->container['recurringProcessingModel'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'recurringProcessingModel', must be one of '%s'",
                $this->container['recurringProcessingModel'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getTokenizationStoreOperationTypeAllowableValues();
        if (!is_null($this->container['tokenizationStoreOperationType']) && !in_array($this->container['tokenizationStoreOperationType'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'tokenizationStoreOperationType', must be one of '%s'",
                $this->container['tokenizationStoreOperationType'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets acquirerAccountCode
     *
     * @return string|null
     */
    public function getAcquirerAccountCode()
    {
        return $this->container['acquirerAccountCode'];
    }

    /**
     * Sets acquirerAccountCode
     *
     * @param string|null $acquirerAccountCode The name of the Adyen acquirer account.  Example: PayPalSandbox_TestAcquirer  > Only relevant for PayPal transactions.
     *
     * @return self
     */
    public function setAcquirerAccountCode($acquirerAccountCode)
    {
        $this->container['acquirerAccountCode'] = $acquirerAccountCode;

        return $this;
    }

    /**
     * Gets acquirerCode
     *
     * @return string|null
     */
    public function getAcquirerCode()
    {
        return $this->container['acquirerCode'];
    }

    /**
     * Sets acquirerCode
     *
     * @param string|null $acquirerCode The name of the acquirer processing the payment request.  Example: TestPmmAcquirer
     *
     * @return self
     */
    public function setAcquirerCode($acquirerCode)
    {
        $this->container['acquirerCode'] = $acquirerCode;

        return $this;
    }

    /**
     * Gets acquirerReference
     *
     * @return string|null
     */
    public function getAcquirerReference()
    {
        return $this->container['acquirerReference'];
    }

    /**
     * Sets acquirerReference
     *
     * @param string|null $acquirerReference The reference number that can be used for reconciliation in case a non-Adyen acquirer is used for settlement.  Example: 7C9N3FNBKT9
     *
     * @return self
     */
    public function setAcquirerReference($acquirerReference)
    {
        $this->container['acquirerReference'] = $acquirerReference;

        return $this;
    }

    /**
     * Gets alias
     *
     * @return string|null
     */
    public function getAlias()
    {
        return $this->container['alias'];
    }

    /**
     * Sets alias
     *
     * @param string|null $alias The Adyen alias of the card.  Example: H167852639363479
     *
     * @return self
     */
    public function setAlias($alias)
    {
        $this->container['alias'] = $alias;

        return $this;
    }

    /**
     * Gets aliasType
     *
     * @return string|null
     */
    public function getAliasType()
    {
        return $this->container['aliasType'];
    }

    /**
     * Sets aliasType
     *
     * @param string|null $aliasType The type of the card alias.  Example: Default
     *
     * @return self
     */
    public function setAliasType($aliasType)
    {
        $this->container['aliasType'] = $aliasType;

        return $this;
    }

    /**
     * Gets authCode
     *
     * @return string|null
     */
    public function getAuthCode()
    {
        return $this->container['authCode'];
    }

    /**
     * Sets authCode
     *
     * @param string|null $authCode Authorisation code: * When the payment is authorised successfully, this field holds the authorisation code for the payment. * When the payment is not authorised, this field is empty.  Example: 58747
     *
     * @return self
     */
    public function setAuthCode($authCode)
    {
        $this->container['authCode'] = $authCode;

        return $this;
    }

    /**
     * Gets authorisationMid
     *
     * @return string|null
     */
    public function getAuthorisationMid()
    {
        return $this->container['authorisationMid'];
    }

    /**
     * Sets authorisationMid
     *
     * @param string|null $authorisationMid Merchant ID known by the acquirer.
     *
     * @return self
     */
    public function setAuthorisationMid($authorisationMid)
    {
        $this->container['authorisationMid'] = $authorisationMid;

        return $this;
    }

    /**
     * Gets authorisedAmountCurrency
     *
     * @return string|null
     */
    public function getAuthorisedAmountCurrency()
    {
        return $this->container['authorisedAmountCurrency'];
    }

    /**
     * Sets authorisedAmountCurrency
     *
     * @param string|null $authorisedAmountCurrency The currency of the authorised amount, as a three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes).
     *
     * @return self
     */
    public function setAuthorisedAmountCurrency($authorisedAmountCurrency)
    {
        $this->container['authorisedAmountCurrency'] = $authorisedAmountCurrency;

        return $this;
    }

    /**
     * Gets authorisedAmountValue
     *
     * @return string|null
     */
    public function getAuthorisedAmountValue()
    {
        return $this->container['authorisedAmountValue'];
    }

    /**
     * Sets authorisedAmountValue
     *
     * @param string|null $authorisedAmountValue Value of the amount authorised.  This amount is represented in minor units according to the [following table](https://docs.adyen.com/development-resources/currency-codes).
     *
     * @return self
     */
    public function setAuthorisedAmountValue($authorisedAmountValue)
    {
        $this->container['authorisedAmountValue'] = $authorisedAmountValue;

        return $this;
    }

    /**
     * Gets avsResult
     *
     * @return string|null
     */
    public function getAvsResult()
    {
        return $this->container['avsResult'];
    }

    /**
     * Sets avsResult
     *
     * @param string|null $avsResult The AVS result code of the payment, which provides information about the outcome of the AVS check.  For possible values, see [AVS](https://docs.adyen.com/risk-management/configure-standard-risk-rules/consistency-rules#billing-address-does-not-match-cardholder-address-avs).
     *
     * @return self
     */
    public function setAvsResult($avsResult)
    {
        $this->container['avsResult'] = $avsResult;

        return $this;
    }

    /**
     * Gets avsResultRaw
     *
     * @return string|null
     */
    public function getAvsResultRaw()
    {
        return $this->container['avsResultRaw'];
    }

    /**
     * Sets avsResultRaw
     *
     * @param string|null $avsResultRaw Raw AVS result received from the acquirer, where available.  Example: D
     *
     * @return self
     */
    public function setAvsResultRaw($avsResultRaw)
    {
        $this->container['avsResultRaw'] = $avsResultRaw;

        return $this;
    }

    /**
     * Gets bic
     *
     * @return string|null
     */
    public function getBic()
    {
        return $this->container['bic'];
    }

    /**
     * Sets bic
     *
     * @param string|null $bic BIC of a bank account.  Example: TESTNL01  > Only relevant for SEPA Direct Debit transactions.
     *
     * @return self
     */
    public function setBic($bic)
    {
        $this->container['bic'] = $bic;

        return $this;
    }

    /**
     * Gets coBrandedWith
     *
     * @return string|null
     */
    public function getCoBrandedWith()
    {
        return $this->container['coBrandedWith'];
    }

    /**
     * Sets coBrandedWith
     *
     * @param string|null $coBrandedWith Includes the co-branded card information.
     *
     * @return self
     */
    public function setCoBrandedWith($coBrandedWith)
    {
        $this->container['coBrandedWith'] = $coBrandedWith;

        return $this;
    }

    /**
     * Gets cvcResult
     *
     * @return string|null
     */
    public function getCvcResult()
    {
        return $this->container['cvcResult'];
    }

    /**
     * Sets cvcResult
     *
     * @param string|null $cvcResult The result of CVC verification.
     *
     * @return self
     */
    public function setCvcResult($cvcResult)
    {
        $this->container['cvcResult'] = $cvcResult;

        return $this;
    }

    /**
     * Gets cvcResultRaw
     *
     * @return string|null
     */
    public function getCvcResultRaw()
    {
        return $this->container['cvcResultRaw'];
    }

    /**
     * Sets cvcResultRaw
     *
     * @param string|null $cvcResultRaw The raw result of CVC verification.
     *
     * @return self
     */
    public function setCvcResultRaw($cvcResultRaw)
    {
        $this->container['cvcResultRaw'] = $cvcResultRaw;

        return $this;
    }

    /**
     * Gets dsTransID
     *
     * @return string|null
     */
    public function getDsTransID()
    {
        return $this->container['dsTransID'];
    }

    /**
     * Sets dsTransID
     *
     * @param string|null $dsTransID Supported for 3D Secure 2. The unique transaction identifier assigned by the DS to identify a single transaction.
     *
     * @return self
     */
    public function setDsTransID($dsTransID)
    {
        $this->container['dsTransID'] = $dsTransID;

        return $this;
    }

    /**
     * Gets eci
     *
     * @return string|null
     */
    public function getEci()
    {
        return $this->container['eci'];
    }

    /**
     * Sets eci
     *
     * @param string|null $eci The Electronic Commerce Indicator returned from the schemes for the 3DS payment session.  Example: 02
     *
     * @return self
     */
    public function setEci($eci)
    {
        $this->container['eci'] = $eci;

        return $this;
    }

    /**
     * Gets expiryDate
     *
     * @return string|null
     */
    public function getExpiryDate()
    {
        return $this->container['expiryDate'];
    }

    /**
     * Sets expiryDate
     *
     * @param string|null $expiryDate The expiry date on the card.  Example: 6/2016  > Returned only in case of a card payment.
     *
     * @return self
     */
    public function setExpiryDate($expiryDate)
    {
        $this->container['expiryDate'] = $expiryDate;

        return $this;
    }

    /**
     * Gets extraCostsCurrency
     *
     * @return string|null
     */
    public function getExtraCostsCurrency()
    {
        return $this->container['extraCostsCurrency'];
    }

    /**
     * Sets extraCostsCurrency
     *
     * @param string|null $extraCostsCurrency The currency of the extra amount charged due to additional amounts set in the skin used in the HPP payment request.  Example: EUR
     *
     * @return self
     */
    public function setExtraCostsCurrency($extraCostsCurrency)
    {
        $this->container['extraCostsCurrency'] = $extraCostsCurrency;

        return $this;
    }

    /**
     * Gets extraCostsValue
     *
     * @return string|null
     */
    public function getExtraCostsValue()
    {
        return $this->container['extraCostsValue'];
    }

    /**
     * Sets extraCostsValue
     *
     * @param string|null $extraCostsValue The value of the extra amount charged due to additional amounts set in the skin used in the HPP payment request. The amount is in minor units.
     *
     * @return self
     */
    public function setExtraCostsValue($extraCostsValue)
    {
        $this->container['extraCostsValue'] = $extraCostsValue;

        return $this;
    }

    /**
     * Gets fraudCheckItemNrFraudCheckname
     *
     * @return string|null
     */
    public function getFraudCheckItemNrFraudCheckname()
    {
        return $this->container['fraudCheckItemNrFraudCheckname'];
    }

    /**
     * Sets fraudCheckItemNrFraudCheckname
     *
     * @param string|null $fraudCheckItemNrFraudCheckname The fraud score due to a particular fraud check. The fraud check name is found in the key of the key-value pair.
     *
     * @return self
     */
    public function setFraudCheckItemNrFraudCheckname($fraudCheckItemNrFraudCheckname)
    {
        $this->container['fraudCheckItemNrFraudCheckname'] = $fraudCheckItemNrFraudCheckname;

        return $this;
    }

    /**
     * Gets fraudManualReview
     *
     * @return string|null
     */
    public function getFraudManualReview()
    {
        return $this->container['fraudManualReview'];
    }

    /**
     * Sets fraudManualReview
     *
     * @param string|null $fraudManualReview Indicates if the payment is sent to manual review.
     *
     * @return self
     */
    public function setFraudManualReview($fraudManualReview)
    {
        $this->container['fraudManualReview'] = $fraudManualReview;

        return $this;
    }

    /**
     * Gets fraudResultType
     *
     * @return string|null
     */
    public function getFraudResultType()
    {
        return $this->container['fraudResultType'];
    }

    /**
     * Sets fraudResultType
     *
     * @param string|null $fraudResultType The fraud result properties of the payment.
     *
     * @return self
     */
    public function setFraudResultType($fraudResultType)
    {
        $allowedValues = $this->getFraudResultTypeAllowableValues();
        if (!in_array($fraudResultType, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'fraudResultType', must be one of '%s'",
                    $fraudResultType,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['fraudResultType'] = $fraudResultType;

        return $this;
    }

    /**
     * Gets fundingSource
     *
     * @return string|null
     */
    public function getFundingSource()
    {
        return $this->container['fundingSource'];
    }

    /**
     * Sets fundingSource
     *
     * @param string|null $fundingSource Information regarding the funding type of the card. The possible return values are: * CHARGE * CREDIT * DEBIT * PREPAID * PREPAID_RELOADABLE  * PREPAID_NONRELOADABLE * DEFFERED_DEBIT  > This functionality requires additional configuration on Adyen's end. To enable it, contact the Support Team.  For receiving this field in the notification, enable **Include Funding Source** in **Notifications** > **Additional settings**.
     *
     * @return self
     */
    public function setFundingSource($fundingSource)
    {
        $this->container['fundingSource'] = $fundingSource;

        return $this;
    }

    /**
     * Gets fundsAvailability
     *
     * @return string|null
     */
    public function getFundsAvailability()
    {
        return $this->container['fundsAvailability'];
    }

    /**
     * Sets fundsAvailability
     *
     * @param string|null $fundsAvailability Indicates availability of funds.  Visa: * \"I\" (fast funds are supported) * \"N\" (otherwise)  Mastercard: * \"I\" (product type is Prepaid or Debit, or issuing country is in CEE/HGEM list) * \"N\" (otherwise)  > Returned when you verify a card BIN or estimate costs, and only if payoutEligible is \"Y\" or \"D\".
     *
     * @return self
     */
    public function setFundsAvailability($fundsAvailability)
    {
        $this->container['fundsAvailability'] = $fundsAvailability;

        return $this;
    }

    /**
     * Gets inferredRefusalReason
     *
     * @return string|null
     */
    public function getInferredRefusalReason()
    {
        return $this->container['inferredRefusalReason'];
    }

    /**
     * Sets inferredRefusalReason
     *
     * @param string|null $inferredRefusalReason Provides the more granular indication of why a transaction was refused. When a transaction fails with either \"Refused\", \"Restricted Card\", \"Transaction Not Permitted\", \"Not supported\" or \"DeclinedNon Generic\" refusalReason from the issuer, Adyen cross references its PSP-wide data for extra insight into the refusal reason. If an inferred refusal reason is available, the `inferredRefusalReason`, field is populated and the `refusalReason`, is set to \"Not Supported\".  Possible values:  * 3D Secure Mandated * Closed Account * ContAuth Not Supported * CVC Mandated * Ecommerce Not Allowed * Crossborder Not Supported * Card Updated  * Low Authrate Bin * Non-reloadable prepaid card
     *
     * @return self
     */
    public function setInferredRefusalReason($inferredRefusalReason)
    {
        $this->container['inferredRefusalReason'] = $inferredRefusalReason;

        return $this;
    }

    /**
     * Gets isCardCommercial
     *
     * @return string|null
     */
    public function getIsCardCommercial()
    {
        return $this->container['isCardCommercial'];
    }

    /**
     * Sets isCardCommercial
     *
     * @param string|null $isCardCommercial Indicates if the card is used for business purposes only.
     *
     * @return self
     */
    public function setIsCardCommercial($isCardCommercial)
    {
        $this->container['isCardCommercial'] = $isCardCommercial;

        return $this;
    }

    /**
     * Gets issuerCountry
     *
     * @return string|null
     */
    public function getIssuerCountry()
    {
        return $this->container['issuerCountry'];
    }

    /**
     * Sets issuerCountry
     *
     * @param string|null $issuerCountry The issuing country of the card based on the BIN list that Adyen maintains.  Example: JP
     *
     * @return self
     */
    public function setIssuerCountry($issuerCountry)
    {
        $this->container['issuerCountry'] = $issuerCountry;

        return $this;
    }

    /**
     * Gets liabilityShift
     *
     * @return string|null
     */
    public function getLiabilityShift()
    {
        return $this->container['liabilityShift'];
    }

    /**
     * Sets liabilityShift
     *
     * @param string|null $liabilityShift A Boolean value indicating whether a liability shift was offered for this payment.
     *
     * @return self
     */
    public function setLiabilityShift($liabilityShift)
    {
        $this->container['liabilityShift'] = $liabilityShift;

        return $this;
    }

    /**
     * Gets mcBankNetReferenceNumber
     *
     * @return string|null
     */
    public function getMcBankNetReferenceNumber()
    {
        return $this->container['mcBankNetReferenceNumber'];
    }

    /**
     * Sets mcBankNetReferenceNumber
     *
     * @param string|null $mcBankNetReferenceNumber The `mcBankNetReferenceNumber`, is a minimum of six characters and a maximum of nine characters long.  > Contact Support Team to enable this field.
     *
     * @return self
     */
    public function setMcBankNetReferenceNumber($mcBankNetReferenceNumber)
    {
        $this->container['mcBankNetReferenceNumber'] = $mcBankNetReferenceNumber;

        return $this;
    }

    /**
     * Gets merchantAdviceCode
     *
     * @return string|null
     */
    public function getMerchantAdviceCode()
    {
        return $this->container['merchantAdviceCode'];
    }

    /**
     * Sets merchantAdviceCode
     *
     * @param string|null $merchantAdviceCode The Merchant Advice Code (MAC) can be returned by Mastercard issuers for refused payments. If present, the MAC contains information about why the payment failed, and whether it can be retried.  For more information see [Mastercard Merchant Advice Codes](https://docs.adyen.com/development-resources/raw-acquirer-responses#mastercard-merchant-advice-codes).
     *
     * @return self
     */
    public function setMerchantAdviceCode($merchantAdviceCode)
    {
        $this->container['merchantAdviceCode'] = $merchantAdviceCode;

        return $this;
    }

    /**
     * Gets merchantReference
     *
     * @return string|null
     */
    public function getMerchantReference()
    {
        return $this->container['merchantReference'];
    }

    /**
     * Sets merchantReference
     *
     * @param string|null $merchantReference The reference provided for the transaction.
     *
     * @return self
     */
    public function setMerchantReference($merchantReference)
    {
        $this->container['merchantReference'] = $merchantReference;

        return $this;
    }

    /**
     * Gets networkTxReference
     *
     * @return string|null
     */
    public function getNetworkTxReference()
    {
        return $this->container['networkTxReference'];
    }

    /**
     * Sets networkTxReference
     *
     * @param string|null $networkTxReference Returned in the response if you are not tokenizing with Adyen and are using the Merchant-initiated transactions (MIT) framework from Mastercard or Visa.  This contains either the Mastercard Trace ID or the Visa Transaction ID.
     *
     * @return self
     */
    public function setNetworkTxReference($networkTxReference)
    {
        $this->container['networkTxReference'] = $networkTxReference;

        return $this;
    }

    /**
     * Gets ownerName
     *
     * @return string|null
     */
    public function getOwnerName()
    {
        return $this->container['ownerName'];
    }

    /**
     * Sets ownerName
     *
     * @param string|null $ownerName The owner name of a bank account.  Only relevant for SEPA Direct Debit transactions.
     *
     * @return self
     */
    public function setOwnerName($ownerName)
    {
        $this->container['ownerName'] = $ownerName;

        return $this;
    }

    /**
     * Gets paymentAccountReference
     *
     * @return string|null
     */
    public function getPaymentAccountReference()
    {
        return $this->container['paymentAccountReference'];
    }

    /**
     * Sets paymentAccountReference
     *
     * @param string|null $paymentAccountReference The Payment Account Reference (PAR) value links a network token with the underlying primary account number (PAN). The PAR value consists of 29 uppercase alphanumeric characters.
     *
     * @return self
     */
    public function setPaymentAccountReference($paymentAccountReference)
    {
        $this->container['paymentAccountReference'] = $paymentAccountReference;

        return $this;
    }

    /**
     * Gets paymentMethod
     *
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->container['paymentMethod'];
    }

    /**
     * Sets paymentMethod
     *
     * @param string|null $paymentMethod The payment method used in the transaction.
     *
     * @return self
     */
    public function setPaymentMethod($paymentMethod)
    {
        $this->container['paymentMethod'] = $paymentMethod;

        return $this;
    }

    /**
     * Gets paymentMethodVariant
     *
     * @return string|null
     */
    public function getPaymentMethodVariant()
    {
        return $this->container['paymentMethodVariant'];
    }

    /**
     * Sets paymentMethodVariant
     *
     * @param string|null $paymentMethodVariant The Adyen sub-variant of the payment method used for the payment request.  For more information, refer to [PaymentMethodVariant](https://docs.adyen.com/development-resources/paymentmethodvariant).  Example: mcpro
     *
     * @return self
     */
    public function setPaymentMethodVariant($paymentMethodVariant)
    {
        $this->container['paymentMethodVariant'] = $paymentMethodVariant;

        return $this;
    }

    /**
     * Gets payoutEligible
     *
     * @return string|null
     */
    public function getPayoutEligible()
    {
        return $this->container['payoutEligible'];
    }

    /**
     * Sets payoutEligible
     *
     * @param string|null $payoutEligible Indicates whether a payout is eligible or not for this card.  Visa: * \"Y\" * \"N\"  Mastercard: * \"Y\" (domestic and cross-border)  * \"D\" (only domestic) * \"N\" (no MoneySend) * \"U\" (unknown)
     *
     * @return self
     */
    public function setPayoutEligible($payoutEligible)
    {
        $this->container['payoutEligible'] = $payoutEligible;

        return $this;
    }

    /**
     * Gets realtimeAccountUpdaterStatus
     *
     * @return string|null
     */
    public function getRealtimeAccountUpdaterStatus()
    {
        return $this->container['realtimeAccountUpdaterStatus'];
    }

    /**
     * Sets realtimeAccountUpdaterStatus
     *
     * @param string|null $realtimeAccountUpdaterStatus The response code from the Real Time Account Updater service.  Possible return values are: * CardChanged * CardExpiryChanged * CloseAccount  * ContactCardAccountHolder
     *
     * @return self
     */
    public function setRealtimeAccountUpdaterStatus($realtimeAccountUpdaterStatus)
    {
        $this->container['realtimeAccountUpdaterStatus'] = $realtimeAccountUpdaterStatus;

        return $this;
    }

    /**
     * Gets receiptFreeText
     *
     * @return string|null
     */
    public function getReceiptFreeText()
    {
        return $this->container['receiptFreeText'];
    }

    /**
     * Sets receiptFreeText
     *
     * @param string|null $receiptFreeText Message to be displayed on the terminal.
     *
     * @return self
     */
    public function setReceiptFreeText($receiptFreeText)
    {
        $this->container['receiptFreeText'] = $receiptFreeText;

        return $this;
    }

    /**
     * Gets recurringContractTypes
     *
     * @return string|null
     */
    public function getRecurringContractTypes()
    {
        return $this->container['recurringContractTypes'];
    }

    /**
     * Sets recurringContractTypes
     *
     * @param string|null $recurringContractTypes The recurring contract types applicable to the transaction.
     *
     * @return self
     */
    public function setRecurringContractTypes($recurringContractTypes)
    {
        $this->container['recurringContractTypes'] = $recurringContractTypes;

        return $this;
    }

    /**
     * Gets recurringFirstPspReference
     *
     * @return string|null
     */
    public function getRecurringFirstPspReference()
    {
        return $this->container['recurringFirstPspReference'];
    }

    /**
     * Sets recurringFirstPspReference
     *
     * @param string|null $recurringFirstPspReference The `pspReference`, of the first recurring payment that created the recurring detail.  This functionality requires additional configuration on Adyen's end. To enable it, contact the Support Team.
     *
     * @return self
     */
    public function setRecurringFirstPspReference($recurringFirstPspReference)
    {
        $this->container['recurringFirstPspReference'] = $recurringFirstPspReference;

        return $this;
    }

    /**
     * Gets recurringRecurringDetailReference
     *
     * @return string|null
     * @deprecated since Adyen Payout API v68. "Use tokenization.storedPaymentMethodId instead."
     */
    public function getRecurringRecurringDetailReference()
    {
        return $this->container['recurringRecurringDetailReference'];
    }

    /**
     * Sets recurringRecurringDetailReference
     *
     * @param string|null $recurringRecurringDetailReference The reference that uniquely identifies the recurring transaction.
     *
     * @return self
     * @deprecated since Adyen Payout API v68. "Use tokenization.storedPaymentMethodId instead."
     */
    public function setRecurringRecurringDetailReference($recurringRecurringDetailReference)
    {
        $this->container['recurringRecurringDetailReference'] = $recurringRecurringDetailReference;

        return $this;
    }

    /**
     * Gets recurringShopperReference
     *
     * @return string|null
     * @deprecated since Adyen Payout API v68. "Use tokenization.shopperReference instead."
     */
    public function getRecurringShopperReference()
    {
        return $this->container['recurringShopperReference'];
    }

    /**
     * Sets recurringShopperReference
     *
     * @param string|null $recurringShopperReference The provided reference of the shopper for a recurring transaction.
     *
     * @return self
     * @deprecated since Adyen Payout API v68. "Use tokenization.shopperReference instead."
     */
    public function setRecurringShopperReference($recurringShopperReference)
    {
        $this->container['recurringShopperReference'] = $recurringShopperReference;

        return $this;
    }

    /**
     * Gets recurringProcessingModel
     *
     * @return string|null
     */
    public function getRecurringProcessingModel()
    {
        return $this->container['recurringProcessingModel'];
    }

    /**
     * Sets recurringProcessingModel
     *
     * @param string|null $recurringProcessingModel The processing model used for the recurring transaction.
     *
     * @return self
     */
    public function setRecurringProcessingModel($recurringProcessingModel)
    {
        $allowedValues = $this->getRecurringProcessingModelAllowableValues();
        if (!in_array($recurringProcessingModel, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'recurringProcessingModel', must be one of '%s'",
                    $recurringProcessingModel,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['recurringProcessingModel'] = $recurringProcessingModel;

        return $this;
    }

    /**
     * Gets referred
     *
     * @return string|null
     */
    public function getReferred()
    {
        return $this->container['referred'];
    }

    /**
     * Sets referred
     *
     * @param string|null $referred If the payment is referred, this field is set to true.  This field is unavailable if the payment is referred and is usually not returned with ecommerce transactions.  Example: true
     *
     * @return self
     */
    public function setReferred($referred)
    {
        $this->container['referred'] = $referred;

        return $this;
    }

    /**
     * Gets refusalReasonRaw
     *
     * @return string|null
     */
    public function getRefusalReasonRaw()
    {
        return $this->container['refusalReasonRaw'];
    }

    /**
     * Sets refusalReasonRaw
     *
     * @param string|null $refusalReasonRaw Raw refusal reason received from the acquirer, where available.  Example: AUTHORISED
     *
     * @return self
     */
    public function setRefusalReasonRaw($refusalReasonRaw)
    {
        $this->container['refusalReasonRaw'] = $refusalReasonRaw;

        return $this;
    }

    /**
     * Gets requestAmount
     *
     * @return string|null
     */
    public function getRequestAmount()
    {
        return $this->container['requestAmount'];
    }

    /**
     * Sets requestAmount
     *
     * @param string|null $requestAmount The amount of the payment request.
     *
     * @return self
     */
    public function setRequestAmount($requestAmount)
    {
        $this->container['requestAmount'] = $requestAmount;

        return $this;
    }

    /**
     * Gets requestCurrencyCode
     *
     * @return string|null
     */
    public function getRequestCurrencyCode()
    {
        return $this->container['requestCurrencyCode'];
    }

    /**
     * Sets requestCurrencyCode
     *
     * @param string|null $requestCurrencyCode The currency of the payment request.
     *
     * @return self
     */
    public function setRequestCurrencyCode($requestCurrencyCode)
    {
        $this->container['requestCurrencyCode'] = $requestCurrencyCode;

        return $this;
    }

    /**
     * Gets shopperInteraction
     *
     * @return string|null
     */
    public function getShopperInteraction()
    {
        return $this->container['shopperInteraction'];
    }

    /**
     * Sets shopperInteraction
     *
     * @param string|null $shopperInteraction The shopper interaction type of the payment request.  Example: Ecommerce
     *
     * @return self
     */
    public function setShopperInteraction($shopperInteraction)
    {
        $this->container['shopperInteraction'] = $shopperInteraction;

        return $this;
    }

    /**
     * Gets shopperReference
     *
     * @return string|null
     */
    public function getShopperReference()
    {
        return $this->container['shopperReference'];
    }

    /**
     * Sets shopperReference
     *
     * @param string|null $shopperReference The shopperReference passed in the payment request.  Example: AdyenTestShopperXX
     *
     * @return self
     */
    public function setShopperReference($shopperReference)
    {
        $this->container['shopperReference'] = $shopperReference;

        return $this;
    }

    /**
     * Gets terminalId
     *
     * @return string|null
     */
    public function getTerminalId()
    {
        return $this->container['terminalId'];
    }

    /**
     * Sets terminalId
     *
     * @param string|null $terminalId The terminal ID used in a point-of-sale payment.  Example: 06022622
     *
     * @return self
     */
    public function setTerminalId($terminalId)
    {
        $this->container['terminalId'] = $terminalId;

        return $this;
    }

    /**
     * Gets threeDAuthenticated
     *
     * @return string|null
     */
    public function getThreeDAuthenticated()
    {
        return $this->container['threeDAuthenticated'];
    }

    /**
     * Sets threeDAuthenticated
     *
     * @param string|null $threeDAuthenticated A Boolean value indicating whether 3DS authentication was completed on this payment.  Example: true
     *
     * @return self
     */
    public function setThreeDAuthenticated($threeDAuthenticated)
    {
        $this->container['threeDAuthenticated'] = $threeDAuthenticated;

        return $this;
    }

    /**
     * Gets threeDAuthenticatedResponse
     *
     * @return string|null
     */
    public function getThreeDAuthenticatedResponse()
    {
        return $this->container['threeDAuthenticatedResponse'];
    }

    /**
     * Sets threeDAuthenticatedResponse
     *
     * @param string|null $threeDAuthenticatedResponse The raw 3DS authentication result from the card issuer.  Example: N
     *
     * @return self
     */
    public function setThreeDAuthenticatedResponse($threeDAuthenticatedResponse)
    {
        $this->container['threeDAuthenticatedResponse'] = $threeDAuthenticatedResponse;

        return $this;
    }

    /**
     * Gets threeDOffered
     *
     * @return string|null
     */
    public function getThreeDOffered()
    {
        return $this->container['threeDOffered'];
    }

    /**
     * Sets threeDOffered
     *
     * @param string|null $threeDOffered A Boolean value indicating whether 3DS was offered for this payment.  Example: true
     *
     * @return self
     */
    public function setThreeDOffered($threeDOffered)
    {
        $this->container['threeDOffered'] = $threeDOffered;

        return $this;
    }

    /**
     * Gets threeDOfferedResponse
     *
     * @return string|null
     */
    public function getThreeDOfferedResponse()
    {
        return $this->container['threeDOfferedResponse'];
    }

    /**
     * Sets threeDOfferedResponse
     *
     * @param string|null $threeDOfferedResponse The raw enrollment result from the 3DS directory services of the card schemes.  Example: Y
     *
     * @return self
     */
    public function setThreeDOfferedResponse($threeDOfferedResponse)
    {
        $this->container['threeDOfferedResponse'] = $threeDOfferedResponse;

        return $this;
    }

    /**
     * Gets threeDSVersion
     *
     * @return string|null
     */
    public function getThreeDSVersion()
    {
        return $this->container['threeDSVersion'];
    }

    /**
     * Sets threeDSVersion
     *
     * @param string|null $threeDSVersion The 3D Secure 2 version.
     *
     * @return self
     */
    public function setThreeDSVersion($threeDSVersion)
    {
        $this->container['threeDSVersion'] = $threeDSVersion;

        return $this;
    }

    /**
     * Gets tokenizationShopperReference
     *
     * @return string|null
     */
    public function getTokenizationShopperReference()
    {
        return $this->container['tokenizationShopperReference'];
    }

    /**
     * Sets tokenizationShopperReference
     *
     * @param string|null $tokenizationShopperReference The reference for the shopper that you sent when tokenizing the payment details.
     *
     * @return self
     */
    public function setTokenizationShopperReference($tokenizationShopperReference)
    {
        $this->container['tokenizationShopperReference'] = $tokenizationShopperReference;

        return $this;
    }

    /**
     * Gets tokenizationStoreOperationType
     *
     * @return string|null
     */
    public function getTokenizationStoreOperationType()
    {
        return $this->container['tokenizationStoreOperationType'];
    }

    /**
     * Sets tokenizationStoreOperationType
     *
     * @param string|null $tokenizationStoreOperationType The operation performed on the token. Possible values:  * **created**: the token has been created. * **updated**: the existing token has been updated. * **alreadyExisting**: the details have already been stored.
     *
     * @return self
     */
    public function setTokenizationStoreOperationType($tokenizationStoreOperationType)
    {
        $allowedValues = $this->getTokenizationStoreOperationTypeAllowableValues();
        if (!in_array($tokenizationStoreOperationType, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'tokenizationStoreOperationType', must be one of '%s'",
                    $tokenizationStoreOperationType,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['tokenizationStoreOperationType'] = $tokenizationStoreOperationType;

        return $this;
    }

    /**
     * Gets tokenizationStoredPaymentMethodId
     *
     * @return string|null
     */
    public function getTokenizationStoredPaymentMethodId()
    {
        return $this->container['tokenizationStoredPaymentMethodId'];
    }

    /**
     * Sets tokenizationStoredPaymentMethodId
     *
     * @param string|null $tokenizationStoredPaymentMethodId The reference that uniquely identifies tokenized payment details.
     *
     * @return self
     */
    public function setTokenizationStoredPaymentMethodId($tokenizationStoredPaymentMethodId)
    {
        $this->container['tokenizationStoredPaymentMethodId'] = $tokenizationStoredPaymentMethodId;

        return $this;
    }

    /**
     * Gets visaTransactionId
     *
     * @return string|null
     */
    public function getVisaTransactionId()
    {
        return $this->container['visaTransactionId'];
    }

    /**
     * Sets visaTransactionId
     *
     * @param string|null $visaTransactionId The `visaTransactionId`, has a fixed length of 15 numeric characters.  > Contact Support Team to enable this field.
     *
     * @return self
     */
    public function setVisaTransactionId($visaTransactionId)
    {
        $this->container['visaTransactionId'] = $visaTransactionId;

        return $this;
    }

    /**
     * Gets xid
     *
     * @return string|null
     */
    public function getXid()
    {
        return $this->container['xid'];
    }

    /**
     * Sets xid
     *
     * @param string|null $xid The 3DS transaction ID of the 3DS session sent in notifications. The value is Base64-encoded and is returned for transactions with directoryResponse 'N' or 'Y'.   Example: ODgxNDc2MDg2MDExODk5MAAAAAA=
     *
     * @return self
     */
    public function setXid($xid)
    {
        $this->container['xid'] = $xid;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    public function toArray(): array
    {
        $array = [];
        foreach (self::$openAPITypes as $propertyName => $propertyType) {
            $propertyValue = $this[$propertyName];
            if ($propertyValue !== null) {
                // Check if the property value is an object and has a toArray() method
                if (is_object($propertyValue) && method_exists($propertyValue, 'toArray')) {
                    $array[$propertyName] = $propertyValue->toArray();
                // Check if it's type datetime
                } elseif ($propertyValue instanceof \DateTime) {
                    $array[$propertyName] = $propertyValue->format(DATE_ATOM);
                // If it's an array type we should check whether it contains objects and if so call toArray method
                } elseif (is_array($propertyValue)) {
                    $array[$propertyName] = array_map(function ($item) {
                        return $item instanceof ModelInterface ? $item->toArray() : $item;
                    }, $propertyValue);
                } else {
                    // Otherwise, directly assign the property value to the array
                    $array[$propertyName] = $propertyValue;
                }
            }
        }
        return $array;
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}
