<?php

/**
 * Management API
 *
 * The version of the OpenAPI document: 3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Adyen\Model\Management;

use \ArrayAccess;
use Adyen\Model\Management\ObjectSerializer;

/**
 * Terminal Class Doc Comment
 *
 * @category Class
 * @package  Adyen
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Terminal implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Terminal';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'assignment' => '\Adyen\Model\Management\TerminalAssignment',
        'connectivity' => '\Adyen\Model\Management\TerminalConnectivity',
        'firmwareVersion' => 'string',
        'id' => 'string',
        'lastActivityAt' => '\DateTime',
        'lastTransactionAt' => '\DateTime',
        'model' => 'string',
        'restartLocalTime' => 'string',
        'serialNumber' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'assignment' => null,
        'connectivity' => null,
        'firmwareVersion' => null,
        'id' => null,
        'lastActivityAt' => 'date-time',
        'lastTransactionAt' => 'date-time',
        'model' => null,
        'restartLocalTime' => null,
        'serialNumber' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'assignment' => false,
        'connectivity' => false,
        'firmwareVersion' => false,
        'id' => false,
        'lastActivityAt' => false,
        'lastTransactionAt' => false,
        'model' => false,
        'restartLocalTime' => false,
        'serialNumber' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'assignment' => 'assignment',
        'connectivity' => 'connectivity',
        'firmwareVersion' => 'firmwareVersion',
        'id' => 'id',
        'lastActivityAt' => 'lastActivityAt',
        'lastTransactionAt' => 'lastTransactionAt',
        'model' => 'model',
        'restartLocalTime' => 'restartLocalTime',
        'serialNumber' => 'serialNumber'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'assignment' => 'setAssignment',
        'connectivity' => 'setConnectivity',
        'firmwareVersion' => 'setFirmwareVersion',
        'id' => 'setId',
        'lastActivityAt' => 'setLastActivityAt',
        'lastTransactionAt' => 'setLastTransactionAt',
        'model' => 'setModel',
        'restartLocalTime' => 'setRestartLocalTime',
        'serialNumber' => 'setSerialNumber'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'assignment' => 'getAssignment',
        'connectivity' => 'getConnectivity',
        'firmwareVersion' => 'getFirmwareVersion',
        'id' => 'getId',
        'lastActivityAt' => 'getLastActivityAt',
        'lastTransactionAt' => 'getLastTransactionAt',
        'model' => 'getModel',
        'restartLocalTime' => 'getRestartLocalTime',
        'serialNumber' => 'getSerialNumber'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('assignment', $data ?? [], null);
        $this->setIfExists('connectivity', $data ?? [], null);
        $this->setIfExists('firmwareVersion', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('lastActivityAt', $data ?? [], null);
        $this->setIfExists('lastTransactionAt', $data ?? [], null);
        $this->setIfExists('model', $data ?? [], null);
        $this->setIfExists('restartLocalTime', $data ?? [], null);
        $this->setIfExists('serialNumber', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets assignment
     *
     * @return \Adyen\Model\Management\TerminalAssignment|null
     */
    public function getAssignment()
    {
        return $this->container['assignment'];
    }

    /**
     * Sets assignment
     *
     * @param \Adyen\Model\Management\TerminalAssignment|null $assignment assignment
     *
     * @return self
     */
    public function setAssignment($assignment)
    {
        $this->container['assignment'] = $assignment;

        return $this;
    }

    /**
     * Gets connectivity
     *
     * @return \Adyen\Model\Management\TerminalConnectivity|null
     */
    public function getConnectivity()
    {
        return $this->container['connectivity'];
    }

    /**
     * Sets connectivity
     *
     * @param \Adyen\Model\Management\TerminalConnectivity|null $connectivity connectivity
     *
     * @return self
     */
    public function setConnectivity($connectivity)
    {
        $this->container['connectivity'] = $connectivity;

        return $this;
    }

    /**
     * Gets firmwareVersion
     *
     * @return string|null
     */
    public function getFirmwareVersion()
    {
        return $this->container['firmwareVersion'];
    }

    /**
     * Sets firmwareVersion
     *
     * @param string|null $firmwareVersion The software release currently in use on the terminal.
     *
     * @return self
     */
    public function setFirmwareVersion($firmwareVersion)
    {
        $this->container['firmwareVersion'] = $firmwareVersion;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id The unique identifier of the terminal.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets lastActivityAt
     *
     * @return \DateTime|null
     */
    public function getLastActivityAt()
    {
        return $this->container['lastActivityAt'];
    }

    /**
     * Sets lastActivityAt
     *
     * @param \DateTime|null $lastActivityAt Date and time of the last activity on the terminal. Not included when the last activity was more than 14 days ago.
     *
     * @return self
     */
    public function setLastActivityAt($lastActivityAt)
    {
        $this->container['lastActivityAt'] = $lastActivityAt;

        return $this;
    }

    /**
     * Gets lastTransactionAt
     *
     * @return \DateTime|null
     */
    public function getLastTransactionAt()
    {
        return $this->container['lastTransactionAt'];
    }

    /**
     * Sets lastTransactionAt
     *
     * @param \DateTime|null $lastTransactionAt Date and time of the last transaction on the terminal. Not included when the last transaction was more than 14 days ago.
     *
     * @return self
     */
    public function setLastTransactionAt($lastTransactionAt)
    {
        $this->container['lastTransactionAt'] = $lastTransactionAt;

        return $this;
    }

    /**
     * Gets model
     *
     * @return string|null
     */
    public function getModel()
    {
        return $this->container['model'];
    }

    /**
     * Sets model
     *
     * @param string|null $model The model name of the terminal.
     *
     * @return self
     */
    public function setModel($model)
    {
        $this->container['model'] = $model;

        return $this;
    }

    /**
     * Gets restartLocalTime
     *
     * @return string|null
     */
    public function getRestartLocalTime()
    {
        return $this->container['restartLocalTime'];
    }

    /**
     * Sets restartLocalTime
     *
     * @param string|null $restartLocalTime The exact time of the terminal reboot, in the timezone of the terminal in **HH:mm** format.
     *
     * @return self
     */
    public function setRestartLocalTime($restartLocalTime)
    {
        $this->container['restartLocalTime'] = $restartLocalTime;

        return $this;
    }

    /**
     * Gets serialNumber
     *
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->container['serialNumber'];
    }

    /**
     * Sets serialNumber
     *
     * @param string|null $serialNumber The serial number of the terminal.
     *
     * @return self
     */
    public function setSerialNumber($serialNumber)
    {
        $this->container['serialNumber'] = $serialNumber;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    public function toArray(): array
    {
        $array = [];
        foreach (self::$openAPITypes as $propertyName => $propertyType) {
            $propertyValue = $this[$propertyName];
            if ($propertyValue !== null) {
                // Check if the property value is an object and has a toArray() method
                if (is_object($propertyValue) && method_exists($propertyValue, 'toArray')) {
                    $array[$propertyName] = $propertyValue->toArray();
                // Check if it's type datetime
                } elseif ($propertyValue instanceof \DateTime) {
                    $array[$propertyName] = $propertyValue->format(DATE_ATOM);
                // If it's an array type we should check whether it contains objects and if so call toArray method
                } elseif (is_array($propertyValue)) {
                    $array[$propertyName] = array_map(function ($item) {
                        return $item instanceof ModelInterface ? $item->toArray() : $item;
                    }, $propertyValue);
                } else {
                    // Otherwise, directly assign the property value to the array
                    $array[$propertyName] = $propertyValue;
                }
            }
        }
        return $array;
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}
