<?php

/**
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Adyen\Model\BalancePlatform;

use \ArrayAccess;
use Adyen\Model\BalancePlatform\ObjectSerializer;

/**
 * TransactionRuleInfo Class Doc Comment
 *
 * @category Class
 * @package  Adyen
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class TransactionRuleInfo implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TransactionRuleInfo';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'aggregationLevel' => 'string',
        'description' => 'string',
        'endDate' => 'string',
        'entityKey' => '\Adyen\Model\BalancePlatform\TransactionRuleEntityKey',
        'interval' => '\Adyen\Model\BalancePlatform\TransactionRuleInterval',
        'outcomeType' => 'string',
        'reference' => 'string',
        'requestType' => 'string',
        'ruleRestrictions' => '\Adyen\Model\BalancePlatform\TransactionRuleRestrictions',
        'score' => 'int',
        'startDate' => 'string',
        'status' => 'string',
        'type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'aggregationLevel' => null,
        'description' => null,
        'endDate' => null,
        'entityKey' => null,
        'interval' => null,
        'outcomeType' => null,
        'reference' => null,
        'requestType' => null,
        'ruleRestrictions' => null,
        'score' => 'int32',
        'startDate' => null,
        'status' => null,
        'type' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'aggregationLevel' => false,
        'description' => false,
        'endDate' => false,
        'entityKey' => false,
        'interval' => false,
        'outcomeType' => false,
        'reference' => false,
        'requestType' => false,
        'ruleRestrictions' => false,
        'score' => true,
        'startDate' => false,
        'status' => false,
        'type' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'aggregationLevel' => 'aggregationLevel',
        'description' => 'description',
        'endDate' => 'endDate',
        'entityKey' => 'entityKey',
        'interval' => 'interval',
        'outcomeType' => 'outcomeType',
        'reference' => 'reference',
        'requestType' => 'requestType',
        'ruleRestrictions' => 'ruleRestrictions',
        'score' => 'score',
        'startDate' => 'startDate',
        'status' => 'status',
        'type' => 'type'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'aggregationLevel' => 'setAggregationLevel',
        'description' => 'setDescription',
        'endDate' => 'setEndDate',
        'entityKey' => 'setEntityKey',
        'interval' => 'setInterval',
        'outcomeType' => 'setOutcomeType',
        'reference' => 'setReference',
        'requestType' => 'setRequestType',
        'ruleRestrictions' => 'setRuleRestrictions',
        'score' => 'setScore',
        'startDate' => 'setStartDate',
        'status' => 'setStatus',
        'type' => 'setType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'aggregationLevel' => 'getAggregationLevel',
        'description' => 'getDescription',
        'endDate' => 'getEndDate',
        'entityKey' => 'getEntityKey',
        'interval' => 'getInterval',
        'outcomeType' => 'getOutcomeType',
        'reference' => 'getReference',
        'requestType' => 'getRequestType',
        'ruleRestrictions' => 'getRuleRestrictions',
        'score' => 'getScore',
        'startDate' => 'getStartDate',
        'status' => 'getStatus',
        'type' => 'getType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const OUTCOME_TYPE_ENFORCE_SCA = 'enforceSCA';
    public const OUTCOME_TYPE_HARD_BLOCK = 'hardBlock';
    public const OUTCOME_TYPE_SCORE_BASED = 'scoreBased';
    public const OUTCOME_TYPE_TIMED_BLOCK = 'timedBlock';
    public const REQUEST_TYPE_AUTHENTICATION = 'authentication';
    public const REQUEST_TYPE_AUTHORIZATION = 'authorization';
    public const REQUEST_TYPE_BANK_TRANSFER = 'bankTransfer';
    public const REQUEST_TYPE_TOKENIZATION = 'tokenization';
    public const STATUS_ACTIVE = 'active';
    public const STATUS_INACTIVE = 'inactive';
    public const TYPE_ALLOW_LIST = 'allowList';
    public const TYPE_BLOCK_LIST = 'blockList';
    public const TYPE_MAX_USAGE = 'maxUsage';
    public const TYPE_VELOCITY = 'velocity';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getOutcomeTypeAllowableValues()
    {
        return [
            self::OUTCOME_TYPE_ENFORCE_SCA,
            self::OUTCOME_TYPE_HARD_BLOCK,
            self::OUTCOME_TYPE_SCORE_BASED,
            self::OUTCOME_TYPE_TIMED_BLOCK,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getRequestTypeAllowableValues()
    {
        return [
            self::REQUEST_TYPE_AUTHENTICATION,
            self::REQUEST_TYPE_AUTHORIZATION,
            self::REQUEST_TYPE_BANK_TRANSFER,
            self::REQUEST_TYPE_TOKENIZATION,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_ACTIVE,
            self::STATUS_INACTIVE,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_ALLOW_LIST,
            self::TYPE_BLOCK_LIST,
            self::TYPE_MAX_USAGE,
            self::TYPE_VELOCITY,
        ];
    }
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('aggregationLevel', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('endDate', $data ?? [], null);
        $this->setIfExists('entityKey', $data ?? [], null);
        $this->setIfExists('interval', $data ?? [], null);
        $this->setIfExists('outcomeType', $data ?? [], null);
        $this->setIfExists('reference', $data ?? [], null);
        $this->setIfExists('requestType', $data ?? [], null);
        $this->setIfExists('ruleRestrictions', $data ?? [], null);
        $this->setIfExists('score', $data ?? [], null);
        $this->setIfExists('startDate', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['description'] === null) {
            $invalidProperties[] = "'description' can't be null";
        }
        if ($this->container['entityKey'] === null) {
            $invalidProperties[] = "'entityKey' can't be null";
        }
        if ($this->container['interval'] === null) {
            $invalidProperties[] = "'interval' can't be null";
        }
        $allowedValues = $this->getOutcomeTypeAllowableValues();
        if (!is_null($this->container['outcomeType']) && !in_array($this->container['outcomeType'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'outcomeType', must be one of '%s'",
                $this->container['outcomeType'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['reference'] === null) {
            $invalidProperties[] = "'reference' can't be null";
        }
        $allowedValues = $this->getRequestTypeAllowableValues();
        if (!is_null($this->container['requestType']) && !in_array($this->container['requestType'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'requestType', must be one of '%s'",
                $this->container['requestType'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['ruleRestrictions'] === null) {
            $invalidProperties[] = "'ruleRestrictions' can't be null";
        }
        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($this->container['status']) && !in_array($this->container['status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'status', must be one of '%s'",
                $this->container['status'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['type'] === null) {
            $invalidProperties[] = "'type' can't be null";
        }
        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'type', must be one of '%s'",
                $this->container['type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets aggregationLevel
     *
     * @return string|null
     */
    public function getAggregationLevel()
    {
        return $this->container['aggregationLevel'];
    }

    /**
     * Sets aggregationLevel
     *
     * @param string|null $aggregationLevel The level at which data must be accumulated, used in rules with `type` **velocity** or **maxUsage**. The level must be the [same or lower in hierarchy](https://docs.adyen.com/issuing/transaction-rules#accumulate-data) than the `entityKey`.  If not provided, by default, the rule will accumulate data at the **paymentInstrument** level.  Possible values: **paymentInstrument**, **paymentInstrumentGroup**, **balanceAccount**, **accountHolder**, **balancePlatform**.
     *
     * @return self
     */
    public function setAggregationLevel($aggregationLevel)
    {
        $this->container['aggregationLevel'] = $aggregationLevel;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string $description Your description for the transaction rule.
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets endDate
     *
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->container['endDate'];
    }

    /**
     * Sets endDate
     *
     * @param string|null $endDate The date when the rule will stop being evaluated, in ISO 8601 extended offset date-time format. For example, **2020-12-18T10:15:30+01:00**.  If not provided, the rule will be evaluated until the rule status is set to **inactive**.
     *
     * @return self
     */
    public function setEndDate($endDate)
    {
        $this->container['endDate'] = $endDate;

        return $this;
    }

    /**
     * Gets entityKey
     *
     * @return \Adyen\Model\BalancePlatform\TransactionRuleEntityKey
     */
    public function getEntityKey()
    {
        return $this->container['entityKey'];
    }

    /**
     * Sets entityKey
     *
     * @param \Adyen\Model\BalancePlatform\TransactionRuleEntityKey $entityKey entityKey
     *
     * @return self
     */
    public function setEntityKey($entityKey)
    {
        $this->container['entityKey'] = $entityKey;

        return $this;
    }

    /**
     * Gets interval
     *
     * @return \Adyen\Model\BalancePlatform\TransactionRuleInterval
     */
    public function getInterval()
    {
        return $this->container['interval'];
    }

    /**
     * Sets interval
     *
     * @param \Adyen\Model\BalancePlatform\TransactionRuleInterval $interval interval
     *
     * @return self
     */
    public function setInterval($interval)
    {
        $this->container['interval'] = $interval;

        return $this;
    }

    /**
     * Gets outcomeType
     *
     * @return string|null
     */
    public function getOutcomeType()
    {
        return $this->container['outcomeType'];
    }

    /**
     * Sets outcomeType
     *
     * @param string|null $outcomeType The [outcome](https://docs.adyen.com/issuing/transaction-rules#outcome) that will be applied when a transaction meets the conditions of the rule.  Possible values: * **hardBlock**: the transaction is declined. * **scoreBased**: the transaction is assigned the `score` you specified. Adyen calculates the total score and if it exceeds 100, the transaction is declined.  Default value: **hardBlock**.  > **scoreBased** is not allowed when `requestType` is **bankTransfer**.
     *
     * @return self
     */
    public function setOutcomeType($outcomeType)
    {
        $allowedValues = $this->getOutcomeTypeAllowableValues();
        if (!in_array($outcomeType, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'outcomeType', must be one of '%s'",
                    $outcomeType,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['outcomeType'] = $outcomeType;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string $reference Your reference for the transaction rule.
     *
     * @return self
     */
    public function setReference($reference)
    {
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets requestType
     *
     * @return string|null
     */
    public function getRequestType()
    {
        return $this->container['requestType'];
    }

    /**
     * Sets requestType
     *
     * @param string|null $requestType Indicates the type of request to which the rule applies. If not provided, by default, this is set to **authorization**.  Possible values: **authorization**, **authentication**, **tokenization**, **bankTransfer**.
     *
     * @return self
     */
    public function setRequestType($requestType)
    {
        $allowedValues = $this->getRequestTypeAllowableValues();
        if (!in_array($requestType, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'requestType', must be one of '%s'",
                    $requestType,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['requestType'] = $requestType;

        return $this;
    }

    /**
     * Gets ruleRestrictions
     *
     * @return \Adyen\Model\BalancePlatform\TransactionRuleRestrictions
     */
    public function getRuleRestrictions()
    {
        return $this->container['ruleRestrictions'];
    }

    /**
     * Sets ruleRestrictions
     *
     * @param \Adyen\Model\BalancePlatform\TransactionRuleRestrictions $ruleRestrictions ruleRestrictions
     *
     * @return self
     */
    public function setRuleRestrictions($ruleRestrictions)
    {
        $this->container['ruleRestrictions'] = $ruleRestrictions;

        return $this;
    }

    /**
     * Gets score
     *
     * @return int|null
     */
    public function getScore()
    {
        return $this->container['score'];
    }

    /**
     * Sets score
     *
     * @param int|null $score A positive or negative score applied to the transaction if it meets the conditions of the rule. Required when `outcomeType` is **scoreBased**.  The value must be between **-100** and **100**.
     *
     * @return self
     */
    public function setScore($score)
    {
        $this->container['score'] = $score;

        return $this;
    }

    /**
     * Gets startDate
     *
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->container['startDate'];
    }

    /**
     * Sets startDate
     *
     * @param string|null $startDate The date when the rule will start to be evaluated, in ISO 8601 extended offset date-time format. For example, **2020-12-18T10:15:30+01:00**.  If not provided when creating a transaction rule, the `startDate` is set to the date when the rule status is set to **active**.
     *
     * @return self
     */
    public function setStartDate($startDate)
    {
        $this->container['startDate'] = $startDate;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status The status of the transaction rule. If you provide a `startDate` in the request, the rule is automatically created  with an **active** status.   Possible values: **active**, **inactive**.
     *
     * @return self
     */
    public function setStatus($status)
    {
        $allowedValues = $this->getStatusAllowableValues();
        if (!in_array($status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'status', must be one of '%s'",
                    $status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string $type The [type of rule](https://docs.adyen.com/issuing/transaction-rules#rule-types), which defines if a rule blocks transactions based on individual characteristics or accumulates data.  Possible values:  * **blockList**: decline a transaction when the conditions are met.  * **maxUsage**: add the amount or number of transactions for the lifetime of a payment instrument, and then decline a transaction when the specified limits are met.  * **velocity**: add the amount or number of transactions based on a specified time interval, and then decline a transaction when the specified limits are met.
     *
     * @return self
     */
    public function setType($type)
    {
        $allowedValues = $this->getTypeAllowableValues();
        if (!in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'type', must be one of '%s'",
                    $type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    public function toArray(): array
    {
        $array = [];
        foreach (self::$openAPITypes as $propertyName => $propertyType) {
            $propertyValue = $this[$propertyName];
            if ($propertyValue !== null) {
                // Check if the property value is an object and has a toArray() method
                if (is_object($propertyValue) && method_exists($propertyValue, 'toArray')) {
                    $array[$propertyName] = $propertyValue->toArray();
                // Check if it's type datetime
                } elseif ($propertyValue instanceof \DateTime) {
                    $array[$propertyName] = $propertyValue->format(DATE_ATOM);
                // If it's an array type we should check whether it contains objects and if so call toArray method
                } elseif (is_array($propertyValue)) {
                    $array[$propertyName] = array_map(function ($item) {
                        return $item instanceof ModelInterface ? $item->toArray() : $item;
                    }, $propertyValue);
                } else {
                    // Otherwise, directly assign the property value to the array
                    $array[$propertyName] = $propertyValue;
                }
            }
        }
        return $array;
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}
