<?php
use PaymentWebhooks\Infrastructure\Config;

return [
    'log_enabled' => (bool) Config::get('PW_ADYEN_LOG', false),
    'status_map' => [
        // key format "EVENTCODE:success"
        // payload['eventCode'], payload['success']
        'AUTHORISATION:true' => 'processing', // tests
        'AUTHORISATION:false' => 'failed', // live logs. Fraud suspected, error status, etc. should be marked as failed
        'CANCELLATION:true' => 'cancelled', // live logs, found in Klarna cases
        'REFUND:true' => 'refunded', // live logs, includes RefundedBulk, RefundScheduled, etc. cases
    ],
    'json_fields' => [
        'order_id' =>       'notificationItems.0.NotificationRequestItem.merchantReference',
        'event_code' =>     'notificationItems.0.NotificationRequestItem.eventCode',
        'success_status' => 'notificationItems.0.NotificationRequestItem.success',
    ],
];
