<?php

namespace PaymentWebhooks\Gateway\Common;

class PayloadHelper
{
    /**
     * Return value from associative array by dot path like
     * notificationItems.0.NotificationRequestItem.merchantReference
     */
    public static function getByPath(array $payload, string $path): mixed
    {
        foreach (explode('.', $path) as $segment) {
            if (!is_array($payload) || !array_key_exists($segment, $payload)) {
                return null;
            }
            $payload = $payload[$segment];
        }
        return $payload;
    }
}
