<?php

namespace PaymentWebhooks\Infrastructure;

final class Config
{
    public static function get(string $key, mixed $default = false): mixed
    {
        if (defined($key)) {
            return constant($key);
        }

        $value = getenv($key) ?: ($_ENV[$key] ?? '');

        if ($value === '') {
            $logger = LoggerFactory::make();
            $logger->warning(sprintf('[Config] %s not set in environment or constants.', $key));
            return $default;
        }

        if (is_string($value)) {
            $lower = strtolower($value);
            if (in_array($lower, ['true', '1', 'yes'], true)) {
                return true;
            }
            if (in_array($lower, ['false', '0', 'no'], true)) {
                return false;
            }
        }

        return $value;
    }


    public static function gateway(string $gateway): array
    {
        $path = dirname(__DIR__, 2) . '/config/' . strtolower($gateway) . '.php';
        return file_exists($path) ? include $path : [];
    }
}
