<?php

namespace PaymentWebhooks\Gateway\Mollie;

use PaymentWebhooks\Contract\StatusMapperInterface;
use PaymentWebhooks\Gateway\Common\PayloadHelper;
use PaymentWebhooks\Gateway\Common\CommonStatusMapper;

final class MollieStatusMapper extends CommonStatusMapper implements StatusMapperInterface
{
    public function __construct(string $gateway)
    {
        parent::__construct($gateway);
    }

    public function map(array $payload): ?string
    {
        $path = $this->jsonFields['status'];
        $status = PayloadHelper::getByPath($payload, $path);
        return $this->map[$status] ?? null;
    }
}
