<?php

namespace PaymentWebhooks\Gateway\Common;

use PaymentWebhooks\Contract\PayloadValidatorInterface;
use WP_REST_Request;

class CommonPayloadValidator implements PayloadValidatorInterface
{
    public function validate(WP_REST_Request $request): ?array
    {
        $json = $request->get_body();
        $data = json_decode($json, true);
        if (json_last_error() !== JSON_ERROR_NONE || !is_array($data)) {
            return null;
        }
        return $data;
    }
}
