<?php

namespace PaymentWebhooks\Gateway\Checkout;

use PaymentWebhooks\Infrastructure\Config;
use PaymentWebhooks\Contract\PostValidatorInterface;
use WP_REST_Request;

final class CheckoutPostValidator implements PostValidatorInterface
{
    public function verify(array $payload, WP_REST_Request $request): bool
    {
        $hmacKey = Config::get('PW_CHECKOUT_HMAC_KEY', '');
        $receivedHmac =  $request->get_header('cko_signature') ?? '';
        $computedHmac = hash_hmac('sha256', $request->get_body(), $hmacKey);

        return hash_equals($computedHmac, $receivedHmac);
    }
}
