<?php
use PaymentWebhooks\Infrastructure\Config;

return [
    'log_enabled' => Config::get('PW_ADYEN_LOG'),
    'status_map' => [
        // key is condition in format "EVENTCODE:success". json_fields['event_code']:json_fields['success_status']
        'AUTHORISATION:true' => 'processing', // tests
        'AUTHORISATION:false' => 'failed', // live logs. Fraud suspected, error status, etc. should be marked as failed
        'CANCELLATION:true' => 'cancelled', // live logs, found in Klarna cases
        'REFUND:true' => 'refunded', // live logs, includes RefundedBulk, RefundScheduled, etc. cases
    ],
    'json_fields' => [
        'order_id' =>            'notificationItems.0.NotificationRequestItem.merchantReference',
        'event_code' =>          'notificationItems.0.NotificationRequestItem.eventCode',
        'success_status' =>      'notificationItems.0.NotificationRequestItem.success',
        // payment data fields
        'payment_method_slug' => 'notificationItems.0.NotificationRequestItem.paymentMethod',
        'transaction_id' =>      'notificationItems.0.NotificationRequestItem.pspReference',
    ],
    // Payment update block
    'payment_collect_data_trigger' => [
        'event_code' => 'AUTHORISATION',
        'success_status' => 'true'
    ],
    'payment_data' => [
        'method_prefix' => 'nuxt_adyen_',
        'title_prefix'  => 'Adyen ',
    ],
];
